/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.util.URLs;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.opengis.feature.simple.SimpleFeature;

class FootprintUtils {
    static final Set<String> IGNORE_PROPS = new HashSet<String>();
    static final String FOOTPRINT_EXT = ".fpt";
    static final String FOOTPRINT_PREFIX = "footprint";
    static final String FOOTPRINT = "footprint.shp";
    private static final Logger LOGGER;

    private FootprintUtils() {
    }

    static void initFootprintsGranuleIDGeometryMap(File footprintSummaryFile, Map<String, Geometry> footprintsIDGeometryMap) {
        block16: {
            Utilities.ensureNonNull((String)"footprintSummaryFile", (Object)footprintSummaryFile);
            if (!footprintSummaryFile.exists() || !footprintSummaryFile.canRead()) {
                throw new IllegalArgumentException("Unable to access to the provided footprint file " + footprintSummaryFile.getAbsolutePath());
            }
            Utilities.ensureNonNull((String)"footprintsID_GeometryMap", footprintsIDGeometryMap);
            try (BufferedReader bReader = new BufferedReader(new FileReader(footprintSummaryFile));){
                String footprint;
                WKTReader geometryReader = new WKTReader();
                while ((footprint = bReader.readLine()) != null) {
                    String[] fpt = footprint.split("=");
                    if (fpt.length != 2) continue;
                    footprintsIDGeometryMap.put(fpt[0], geometryReader.read(fpt[1]));
                }
                bReader.close();
            }
            catch (IOException | ParseException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block16;
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
    }

    static Geometry lookupFootprintGeometry(String featureID, Map<String, Geometry> footprintsMap) {
        Utilities.ensureNonNull((String)"featureID", (Object)featureID);
        Utilities.ensureNonNull((String)"footprintsMap", footprintsMap);
        if (footprintsMap != null && !footprintsMap.isEmpty()) {
            String id = featureID.substring(featureID.lastIndexOf(".") + 1, featureID.length());
            return footprintsMap.containsKey(id) ? footprintsMap.get(id) : null;
        }
        return null;
    }

    static void initFootprintsLocationGeometryMap(ShapefileDataStore footprintStore, Map<String, Geometry> footprintsMap) throws IOException {
        Utilities.ensureNonNull((String)"footprintStore", (Object)footprintStore);
        Utilities.ensureNonNull((String)"footprintsMap", footprintsMap);
        String[] typeNames = footprintStore.getTypeNames();
        if (typeNames.length <= 0) {
            throw new IllegalArgumentException("Problems when opening the footprint, no typenames for the schema are defined");
        }
        String typeName = typeNames[0];
        ContentFeatureSource featureSource = footprintStore.getFeatureSource(typeName);
        FeatureCollection features = featureSource.getFeatures();
        if (features == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No features found in the footprint");
            }
            return;
        }
        try (FeatureIterator it = features.features();){
            if (!it.hasNext()) {
                throw new IllegalArgumentException("The provided FeatureCollection<SimpleFeatureType, SimpleFeature>  or empty, it's impossible to create an index!");
            }
            while (it.hasNext()) {
                SimpleFeature feature = (SimpleFeature)it.next();
                Geometry g = (Geometry)feature.getDefaultGeometry();
                String location = (String)feature.getAttribute("location");
                footprintsMap.put(location, g);
            }
        }
    }

    private static String buildIDGeometryPair(Map<String, Geometry> footprintGeometryMap, String featureID, String locationKey, WKTWriter writer) {
        Geometry polygon;
        String idGeometryPair = "";
        Utilities.ensureNonNull((String)"featureID", (Object)featureID);
        Utilities.ensureNonNull((String)"writer", (Object)writer);
        Utilities.ensureNonNull((String)"locationKey", (Object)locationKey);
        Utilities.ensureNonNull((String)"footprintGeometryMap", footprintGeometryMap);
        if (!footprintGeometryMap.isEmpty() && footprintGeometryMap.containsKey(locationKey) && (polygon = footprintGeometryMap.get(locationKey)) != null) {
            String s = writer.write(polygon);
            String id = featureID;
            id = id.substring(id.lastIndexOf(".") + 1, id.length());
            idGeometryPair = id + "=" + s + "\n";
        }
        return idGeometryPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeFootprintSummary(File footprintSummaryFile, File indexFile, Map<String, Geometry> footprintsLocationGeometryMap) throws MalformedURLException {
        Utilities.ensureNonNull((String)"footprintSummaryFile", (Object)footprintSummaryFile);
        Utilities.ensureNonNull((String)"indexFile", (Object)indexFile);
        Utilities.ensureNonNull((String)"footprintsLocationGeometryMap", footprintsLocationGeometryMap);
        if (footprintsLocationGeometryMap.isEmpty()) {
            return;
        }
        ShapefileDataStore store = new ShapefileDataStore(URLs.fileToUrl((File)indexFile));
        if (footprintsLocationGeometryMap.isEmpty()) {
            return;
        }
        FeatureIterator it = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(footprintSummaryFile));){
            String[] typeNames = store.getTypeNames();
            if (typeNames.length <= 0) {
                throw new IllegalArgumentException("Problems when opening the shapefile, no typenames for the schema are defined");
            }
            String typeName = typeNames[0];
            ContentFeatureSource featureSource = store.getFeatureSource(typeName);
            FeatureCollection features = featureSource.getFeatures();
            if (features == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("No features found in the shapefile");
                }
                return;
            }
            it = features.features();
            if (!it.hasNext()) {
                throw new IllegalArgumentException("The provided FeatureCollection<SimpleFeatureType, SimpleFeature>  or empty, it's impossible to create an index!");
            }
            WKTWriter geometryWriter = new WKTWriter();
            while (it.hasNext()) {
                String locationKey;
                SimpleFeature feature = (SimpleFeature)it.next();
                String location = (String)feature.getAttribute("location");
                if (location == null || location.trim().length() <= 0 || !footprintsLocationGeometryMap.containsKey(locationKey = location)) continue;
                String idGeometryPair = FootprintUtils.buildIDGeometryPair(footprintsLocationGeometryMap, feature.getID(), locationKey, geometryWriter);
                writer.write(idGeometryPair);
            }
            writer.flush();
            writer.close();
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
            }
        }
        finally {
            block48: {
                block47: {
                    try {
                        if (it != null) {
                            it.close();
                        }
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block47;
                        LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                }
                try {
                    store.dispose();
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block48;
                    LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    static File searchFootprint(String indexingDirectory) {
        File file;
        File footprintFile = null;
        if (indexingDirectory != null && indexingDirectory.trim().length() > 0 && (file = new File(indexingDirectory, FOOTPRINT)) != null && file.exists()) {
            footprintFile = file;
        }
        return footprintFile;
    }

    static {
        IGNORE_PROPS.add("Envelope2D");
        IGNORE_PROPS.add("AbsolutePath");
        IGNORE_PROPS.add("SuggestedSPI");
        IGNORE_PROPS.add("ExpandToRGB");
        IGNORE_PROPS.add("Levels");
        IGNORE_PROPS.add("LocationAttribute");
        IGNORE_PROPS.add("Name");
        LOGGER = Logging.getLogger(FootprintUtils.class);
    }
}

