/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.icons;

import de.riwagis.util.gui.highdpi.DpiAwareImage;
import de.riwagis.util.gui.highdpi.HighDpiCursorSupport;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import net.sf.image4j.codec.ico.ICODecoder;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconLoader {
    private static final Logger LOG = LoggerFactory.getLogger(IconLoader.class);
    private static final String DEFAULT_ICONNAME = "common_error.gif";
    private static final String BRANDING_FOLDER = "branding";
    private static final String ICON_FOLDER = "/de/riwagis/icons/";

    private IconLoader() {
    }

    public static ImageIcon image(String identifier) {
        try {
            String svgFile = identifier + ".svg";
            File svgBrandingFile = new File(BRANDING_FOLDER, svgFile);
            if (svgBrandingFile.exists()) {
                return IconLoader.svgIcon(svgFile, -1);
            }
            String pngFile = identifier + ".png";
            File pngBrandingFile = new File(BRANDING_FOLDER, pngFile);
            if (pngBrandingFile.exists()) {
                return IconLoader.icon(pngFile);
            }
            if (IconLoader.class.getResource(svgFile) != null) {
                return IconLoader.svgIcon(svgFile, -1);
            }
            return IconLoader.icon(pngFile);
        }
        catch (Exception e) {
            LOG.error("Could not load icon '{}'", (Object)identifier);
            return IconLoader.loadIconFromResource(DEFAULT_ICONNAME);
        }
    }

    public static ImageIcon icon(String filename) {
        File icoFile = new File(BRANDING_FOLDER, filename);
        if (icoFile.exists()) {
            try {
                return new ImageIcon(icoFile.toString());
            }
            catch (Exception e) {
                LOG.error(String.format("Error loading icon %s from branding directory.", filename), (Throwable)e);
            }
        } else {
            try {
                return IconLoader.loadIconFromResource(filename);
            }
            catch (Exception e) {
                LOG.error(String.format("Error loading icon %s from resources.", filename), (Throwable)e);
            }
        }
        return IconLoader.loadIconFromResource(DEFAULT_ICONNAME);
    }

    public static ImageIcon cursor(String filename) {
        File icoFile = new File(BRANDING_FOLDER, filename);
        if (icoFile.exists()) {
            try {
                return HighDpiCursorSupport.createScaledImage((ImageIcon)new ImageIcon(icoFile.toString()));
            }
            catch (Exception e) {
                LOG.error(String.format("Error loading icon %s from branding directory.", filename), (Throwable)e);
            }
        } else {
            try {
                return HighDpiCursorSupport.createScaledImage((ImageIcon)IconLoader.loadIconFromResource(filename));
            }
            catch (Exception e) {
                LOG.error(String.format("Error loading icon %s from ressources.", filename), (Throwable)e);
            }
        }
        return IconLoader.loadIconFromResource(DEFAULT_ICONNAME);
    }

    public static ImageIcon svgIcon(String filename) {
        return IconLoader.svgIcon(filename, 20);
    }

    public static ImageIcon svgIconSmall(String filename) {
        return IconLoader.svgIcon(filename, 16);
    }

    public static ImageIcon svgIconLarge(String filename) {
        return IconLoader.svgIcon(filename, 32);
    }

    public static ImageIcon svgIconCursortool(String filename) {
        PNGTranscoder pngTranscoder = new PNGTranscoder(){

            protected ImageRenderer createRenderer() {
                ImageRenderer r = super.createRenderer();
                RenderingHints rh = r.getRenderingHints();
                rh.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY));
                rh.add(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR));
                rh.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF));
                rh.add(new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY));
                rh.add(new RenderingHints(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE));
                rh.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
                rh.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
                rh.add(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON));
                rh.add(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF));
                r.setRenderingHints(rh);
                return r;
            }
        };
        return new ImageIcon(IconLoader.rasterSVG(filename, HighDpiCursorSupport.CURSOR_32PIXEL_SIZE, HighDpiCursorSupport.CURSOR_32PIXEL_SIZE, (ImageTranscoder)pngTranscoder));
    }

    public static ImageIcon svgIcon(String filename, int size) {
        return IconLoader.svgIcon(filename, size, size, IconLoader.createDefaultPNGTranscoder());
    }

    public static List<BufferedImage> getIconImagesOfIcoFile(String filename) throws IOException, IllegalArgumentException {
        String fileSuffix = FilenameUtils.getExtension((String)filename);
        if ("ico".equalsIgnoreCase(fileSuffix)) {
            File iconFile = new File(BRANDING_FOLDER, filename);
            if (iconFile.exists()) {
                return ICODecoder.read((File)iconFile);
            }
            return ICODecoder.read((InputStream)IconLoader.class.getResourceAsStream(ICON_FOLDER + filename));
        }
        throw new IllegalArgumentException(String.format("The suffix of the filename '%s' is not supported. Filesuffix has to be '.ico'.", filename));
    }

    public static ImageIcon svgIcon(String filename, int width, int height, PNGTranscoder pngTranscoder) {
        return new ImageIcon((Image)new DpiAwareImage((w, h) -> IconLoader.rasterSVG(filename, w, h, (ImageTranscoder)pngTranscoder), width, height));
    }

    public static PNGTranscoder createDefaultPNGTranscoder() {
        return new PNGTranscoder(){

            protected ImageRenderer createRenderer() {
                ImageRenderer r = super.createRenderer();
                RenderingHints rh = r.getRenderingHints();
                rh.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY));
                rh.add(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC));
                rh.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
                rh.add(new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY));
                rh.add(new RenderingHints(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE));
                rh.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
                rh.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
                rh.add(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON));
                rh.add(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF));
                r.setRenderingHints(rh);
                return r;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image rasterSVG(String filename, int width, int height, ImageTranscoder imgTranscoder) {
        TranscoderInput input = null;
        try {
            BufferedImage bufferedImage;
            byte[] data;
            input = new TranscoderInput(IconLoader.getFileFromBrandingOrProject(filename));
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                TranscoderOutput output = new TranscoderOutput((OutputStream)out);
                if (width != -1) {
                    imgTranscoder.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, (Object)Float.valueOf(width));
                }
                if (height != -1) {
                    imgTranscoder.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, (Object)Float.valueOf(height));
                }
                imgTranscoder.transcode(input, output);
                data = out.toByteArray();
            }
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            try {
                bufferedImage = ImageIO.read(in);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | TranscoderException e) {
                    LOG.error(String.format("Error loading icon %s. Using fallback", filename), e);
                    Image image = IconLoader.loadImageFromResource(DEFAULT_ICONNAME);
                    return image;
                }
            }
            ((InputStream)in).close();
            return bufferedImage;
        }
        finally {
            if (input != null) {
                IOUtils.closeQuietly((InputStream)input.getInputStream());
            }
        }
    }

    private static InputStream getFileFromBrandingOrProject(String filename) throws FileNotFoundException {
        File icoFile = new File(BRANDING_FOLDER, filename);
        if (icoFile.exists()) {
            return new FileInputStream(icoFile.getPath());
        }
        InputStream resource = IconLoader.class.getResourceAsStream(filename);
        if (resource == null) {
            throw new FileNotFoundException("Resource file " + filename + " is missing");
        }
        return resource;
    }

    private static Image loadImageFromResource(String resourceLocation) {
        return IconLoader.loadIconFromResource(resourceLocation).getImage();
    }

    private static ImageIcon loadIconFromResource(String resourceLocation) {
        return new ImageIcon(IconLoader.class.getResource(resourceLocation));
    }
}

