/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.dsmiley.httpproxy;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.mitre.dsmiley.httpproxy.ProxyServlet;

public class URITemplateProxyServlet
extends ProxyServlet {
    protected static final Pattern TEMPLATE_PATTERN = Pattern.compile("\\{(.+?)\\}");
    private static final String ATTR_QUERY_STRING = URITemplateProxyServlet.class.getSimpleName() + ".queryString";
    protected String targetUriTemplate;

    @Override
    protected void initTarget() throws ServletException {
        this.targetUriTemplate = this.getConfigParam("targetUri");
        if (this.targetUriTemplate == null) {
            throw new ServletException("targetUri is required.");
        }
    }

    @Override
    protected void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        URI targetUriObj;
        List pairs;
        Object queryString = "?" + servletRequest.getQueryString();
        int hash = ((String)queryString).indexOf(35);
        if (hash >= 0) {
            queryString = ((String)queryString).substring(0, hash);
        }
        try {
            pairs = URLEncodedUtils.parse((URI)new URI((String)queryString), (String)"UTF-8");
        }
        catch (URISyntaxException e) {
            throw new ServletException("Unexpected URI parsing error on " + (String)queryString, (Throwable)e);
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (NameValuePair pair : pairs) {
            params.put(pair.getName(), pair.getValue());
        }
        StringBuffer urlBuf = new StringBuffer();
        Matcher matcher = TEMPLATE_PATTERN.matcher(this.targetUriTemplate);
        while (matcher.find()) {
            String arg = matcher.group(1);
            String replacement = (String)params.remove(arg);
            if (replacement == null) {
                throw new ServletException("Missing HTTP parameter " + arg + " to fill the template");
            }
            matcher.appendReplacement(urlBuf, replacement);
        }
        matcher.appendTail(urlBuf);
        String newTargetUri = urlBuf.toString();
        servletRequest.setAttribute(ATTR_TARGET_URI, (Object)newTargetUri);
        try {
            targetUriObj = new URI(newTargetUri);
        }
        catch (Exception e) {
            throw new ServletException("Rewritten targetUri is invalid: " + newTargetUri, (Throwable)e);
        }
        servletRequest.setAttribute(ATTR_TARGET_HOST, (Object)URIUtils.extractHost((URI)targetUriObj));
        StringBuilder newQueryBuf = new StringBuilder(((String)queryString).length());
        for (Map.Entry nameVal : params.entrySet()) {
            if (newQueryBuf.length() > 0) {
                newQueryBuf.append('&');
            }
            newQueryBuf.append((String)nameVal.getKey()).append('=');
            if (nameVal.getValue() == null) continue;
            newQueryBuf.append((String)nameVal.getValue());
        }
        servletRequest.setAttribute(ATTR_QUERY_STRING, (Object)newQueryBuf.toString());
        super.service(servletRequest, servletResponse);
    }

    @Override
    protected String rewriteQueryStringFromRequest(HttpServletRequest servletRequest, String queryString) {
        return (String)servletRequest.getAttribute(ATTR_QUERY_STRING);
    }
}

