/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.http;

import de.riwagis.util.Config;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.http.HttpClientProxyConfig;
import de.riwagis.util.i18n.I18N;
import de.riwagis.util.jdom.JDOMUtils;
import de.riwagis.util.security.encryption.DESCryptUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.text.NumberFormat;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyPanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyPanel.class);
    private static final byte[] PROXY_ENC_KEY = new byte[]{25, 34, 110, 10, 11, 79, 42, 100};
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.util.http.i18n.i18n");
    private String strTitle = "Proxy";
    private File configFile;
    private boolean configFileWriteable = true;
    private final DefaultFormatterFactory nff;
    private JCheckBox cboAutodetect;
    private JCheckBox cboForProgram;
    private JLabel lblAuth;
    private JLabel lblAuthDomain;
    private JLabel lblAuthHost;
    private JLabel lblConfigFileWritable;
    private JLabel lblGeneral;
    private JLabel lblHost;
    private JLabel lblISA;
    private JLabel lblNoProxy;
    private JLabel lblNoProxyURL;
    private JLabel lblPort;
    private JLabel lblPwd;
    private JLabel lblSystemProxyHint;
    private JLabel lblUser;
    private JPanel pnlProxy;
    private JTextField txtAuthDomain;
    private JTextField txtAuthHost;
    private JTextField txtHost;
    private JTextField txtNoProxy;
    private JFormattedTextField txtPort;
    private JPasswordField txtPwd;
    private JTextField txtUser;

    public ProxyPanel() {
        this(Beans.isDesignTime() ? null : HttpClientProxyConfig.getProxyFile());
    }

    public ProxyPanel(File configFile) {
        this.configFile = configFile;
        if (configFile != null && configFile.exists()) {
            this.configFileWriteable = Files.isWritable(this.configFile.toPath());
        }
        this.initComponents();
        this.i18n();
        this.init();
        NumberFormat nf = NumberFormat.getIntegerInstance();
        nf.setGroupingUsed(false);
        this.nff = new DefaultFormatterFactory(new NumberFormatter(nf));
        this.updateContols();
    }

    public final void i18n() {
        this.cboAutodetect.setText(i18n.get("http.ProxyPanel.autodetect"));
        this.lblGeneral.setText(i18n.get("http.ProxyPanel.general"));
        this.lblHost.setText(i18n.get("http.ProxyPanel.host"));
        this.lblPort.setText(i18n.get("http.ProxyPanel.port"));
        this.lblAuth.setText(i18n.get("http.ProxyPanel.auth-comment"));
        this.lblUser.setText(i18n.get("http.ProxyPanel.user"));
        this.lblPwd.setText(i18n.get("http.ProxyPanel.pwd"));
        this.lblISA.setText(i18n.get("http.ProxyPanel.isa-comment"));
        this.lblAuthHost.setText(i18n.get("http.ProxyPanel.auth-host"));
        this.lblAuthDomain.setText(i18n.get("http.ProxyPanel.auth-domain"));
        this.lblNoProxy.setText(i18n.get("http.ProxyPanel.no-proxy-comment"));
        this.lblNoProxyURL.setText(i18n.get("http.ProxyPanel.no-proxy"));
        this.cboForProgram.setText(i18n.get("http.ProxyPanel.settings-for-program"));
        this.strTitle = i18n.get("http.ProxyPanel.title");
    }

    private void updateContols() {
        this.lblConfigFileWritable.setVisible(!this.configFileWriteable);
        this.lblGeneral.setEnabled(this.configFileWriteable);
        this.lblISA.setEnabled(this.configFileWriteable);
        this.lblAuth.setEnabled(this.configFileWriteable);
        this.lblNoProxy.setEnabled(this.configFileWriteable);
        this.cboAutodetect.setEnabled(this.configFileWriteable);
        this.lblHost.setEnabled(this.configFileWriteable);
        this.txtHost.setEnabled(this.configFileWriteable);
        this.lblPort.setEnabled(this.configFileWriteable);
        this.txtPort.setEnabled(this.configFileWriteable);
        this.lblAuthDomain.setEnabled(this.configFileWriteable);
        this.txtAuthDomain.setEnabled(this.configFileWriteable);
        this.lblAuthHost.setEnabled(this.configFileWriteable);
        this.txtAuthHost.setEnabled(this.configFileWriteable);
        this.lblUser.setEnabled(this.configFileWriteable);
        this.txtUser.setEnabled(this.configFileWriteable);
        this.lblPwd.setEnabled(this.configFileWriteable);
        this.txtPwd.setEnabled(this.configFileWriteable);
        this.lblNoProxyURL.setEnabled(this.configFileWriteable);
        this.txtNoProxy.setEnabled(this.configFileWriteable);
        this.cboForProgram.setEnabled(this.configFileWriteable);
        if (this.cboAutodetect.isSelected()) {
            this.lblGeneral.setEnabled(false);
            this.lblHost.setEnabled(false);
            this.txtHost.setEnabled(false);
            this.lblPort.setEnabled(false);
            this.txtPort.setEnabled(false);
        } else {
            this.lblGeneral.setEnabled(this.configFileWriteable);
            this.lblHost.setEnabled(this.configFileWriteable);
            this.txtHost.setEnabled(this.configFileWriteable);
            this.lblPort.setEnabled(this.configFileWriteable);
            this.txtPort.setEnabled(this.configFileWriteable);
        }
    }

    public boolean isConfigFileWriteable() {
        return this.configFileWriteable;
    }

    public final void init() {
        block11: {
            try {
                Document doc;
                this.txtPort.setFormatterFactory(this.nff);
                if (this.configFile == null || !this.configFile.exists()) break block11;
                try {
                    doc = JDOMUtils.build((File)this.configFile);
                }
                catch (IOException | JDOMException e) {
                    return;
                }
                Element rElem = doc.getRootElement();
                Namespace ns = rElem.getNamespace();
                Element proxyElem = rElem.getChild("proxy", ns);
                if (proxyElem == null) {
                    return;
                }
                boolean bolAutodetect = false;
                if (proxyElem.getChild("autodetect", ns) != null) {
                    bolAutodetect = true;
                }
                String strHost = ObjectUtils.toString((Object)proxyElem.getChildTextTrim("host", ns));
                String strPort = ObjectUtils.toString((Object)proxyElem.getChildTextTrim("port", ns));
                String strUsername = ObjectUtils.toString((Object)proxyElem.getChildTextTrim("username", ns));
                String strPwd = ObjectUtils.toString((Object)proxyElem.getChildTextTrim("userpwd", ns));
                boolean bolEncPwd = false;
                if (proxyElem.getChild("encpwd", ns) != null) {
                    bolEncPwd = true;
                }
                if (bolEncPwd && strPwd != null) {
                    byte[] arrByteEnc = new Base64().decode(strPwd.getBytes());
                    strPwd = DESCryptUtils.decryptToString((byte[])arrByteEnc, (byte[])PROXY_ENC_KEY);
                }
                String strAuthHost = ObjectUtils.toString((Object)proxyElem.getChildTextTrim("authhost", ns));
                String strAuthDomain = ObjectUtils.toString((Object)proxyElem.getChildTextTrim("authdomain", ns));
                String strNoProxy = ObjectUtils.toString((Object)proxyElem.getChildTextTrim("noproxy", ns));
                this.cboAutodetect.setSelected(bolAutodetect);
                if (!bolAutodetect) {
                    this.txtHost.setText(strHost);
                    this.txtPort.setText(strPort);
                }
                this.txtUser.setText(strUsername);
                this.txtPwd.setText(strPwd);
                this.txtAuthHost.setText(strAuthHost);
                this.txtAuthDomain.setText(strAuthDomain);
                this.txtNoProxy.setText(strNoProxy);
                if (this.configFile.equals(HttpClientProxyConfig.getAppProxyFile())) {
                    this.cboForProgram.setSelected(true);
                } else {
                    this.cboForProgram.setSelected(false);
                }
                this.updateContols();
            }
            catch (Exception e) {
                ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
            }
        }
    }

    public boolean okPressed() {
        if (this.configFileWriteable) {
            try {
                String strNoProxy;
                Document doc;
                if (!this.configFile.exists()) {
                    if (this.txtHost.getText().trim().length() == 0 && !this.cboAutodetect.isSelected()) {
                        return true;
                    }
                    Element proxyConf = new Element("proxyConfig", "http://www.riwagis.de/proxy_configuration");
                    doc = new Document(proxyConf);
                } else {
                    doc = JDOMUtils.build((File)this.configFile);
                }
                Element rElem = doc.getRootElement();
                Namespace ns = rElem.getNamespace();
                rElem.removeChild("proxy", ns);
                String strHost = this.txtHost.getText().trim();
                Element proxyElem = new Element("proxy", ns);
                String strUser = this.txtUser.getText().trim();
                if (strUser.length() > 0) {
                    Element userElem = new Element("username", ns);
                    userElem.setText(strUser);
                    proxyElem.addContent((Content)userElem);
                    Element pwdElem = new Element("userpwd", ns);
                    byte[] arrPwd = DESCryptUtils.encrypt((char[])this.txtPwd.getPassword(), (byte[])PROXY_ENC_KEY);
                    byte[] arrPwd64 = new Base64().encode(arrPwd);
                    String strPwd = new String(arrPwd64);
                    pwdElem.setText(strPwd);
                    proxyElem.addContent((Content)pwdElem);
                    String strAuthHost = this.txtAuthHost.getText().trim();
                    if (strAuthHost.length() > 0) {
                        Element authHostElem = new Element("authhost", ns);
                        authHostElem.setText(strAuthHost);
                        proxyElem.addContent((Content)authHostElem);
                        Element authDomainElem = new Element("authdomain", ns);
                        authDomainElem.setText(this.txtAuthDomain.getText().trim());
                        proxyElem.addContent((Content)authDomainElem);
                    }
                }
                if ((strNoProxy = this.txtNoProxy.getText().trim()).length() > 0) {
                    Element noProxyElem = new Element("noproxy", ns);
                    noProxyElem.setText(strNoProxy);
                    proxyElem.addContent((Content)noProxyElem);
                }
                Element encPwdElem = new Element("encpwd", ns);
                proxyElem.addContent((Content)encPwdElem);
                if (this.cboAutodetect.isSelected()) {
                    Element autodetectElem = new Element("autodetect", ns);
                    proxyElem.addContent((Content)autodetectElem);
                    Element hostElem = new Element("host", ns);
                    hostElem.setText("proxy_autodetection_not_supported");
                    proxyElem.addContent((Content)hostElem);
                    portElem = new Element("port", ns);
                    portElem.setText("-1");
                    proxyElem.addContent((Content)portElem);
                    rElem.addContent((Content)proxyElem);
                } else if (strHost.length() > 0) {
                    Element hostElem = new Element("host", ns);
                    hostElem.setText(strHost);
                    proxyElem.addContent((Content)hostElem);
                    String strPort = this.txtPort.getText();
                    if (strPort.trim().length() == 0) {
                        strPort = "8080";
                    }
                    portElem = new Element("port", ns);
                    portElem.setText(strPort);
                    proxyElem.addContent((Content)portElem);
                    rElem.addContent((Content)proxyElem);
                }
                JDOMUtils.output((Document)doc, (File)this.configFile);
                if (this.configFile.equals(HttpClientProxyConfig.getUserProxyFile()) && HttpClientProxyConfig.getAppProxyFile().exists()) {
                    try {
                        HttpClientProxyConfig.getAppProxyFile().delete();
                    }
                    catch (SecurityException se) {
                        GUISupport.msgbox((Component)this, (String)i18n.get("http.ProxyPanel.missing-rights"), (String)i18n.get("common.error"));
                        return false;
                    }
                }
                return true;
            }
            catch (Exception e) {
                GUISupport.msgbox((Component)this, (String)i18n.fmt("http.ProxyPanel.error-message", new Object[]{this.configFile.getAbsolutePath(), e.getMessage()}), (String)i18n.get("common.error"));
                return false;
            }
        }
        return true;
    }

    public String validateInput() {
        try {
            if (this.configFile.exists() && !this.configFile.renameTo(this.configFile)) {
                throw new IOException(i18n.get("http.ProxyPanel.access-denied"));
            }
        }
        catch (Exception e) {
            return i18n.fmt("http.ProxyPanel.error-message", new Object[]{this.configFile.getAbsolutePath(), e.getMessage()});
        }
        return null;
    }

    private void initComponents() {
        this.pnlProxy = new JPanel();
        this.cboAutodetect = new JCheckBox();
        this.lblGeneral = new JLabel();
        this.lblHost = new JLabel();
        this.txtHost = new JTextField();
        this.lblPort = new JLabel();
        this.txtPort = new JFormattedTextField();
        this.lblAuth = new JLabel();
        this.lblUser = new JLabel();
        this.txtUser = new JTextField();
        this.lblPwd = new JLabel();
        this.txtPwd = new JPasswordField();
        this.lblISA = new JLabel();
        this.lblAuthHost = new JLabel();
        this.txtAuthHost = new JTextField();
        this.lblAuthDomain = new JLabel();
        this.txtAuthDomain = new JTextField();
        this.lblNoProxy = new JLabel();
        this.lblNoProxyURL = new JLabel();
        this.txtNoProxy = new JTextField();
        this.cboForProgram = new JCheckBox();
        this.lblConfigFileWritable = new JLabel();
        this.lblSystemProxyHint = new JLabel();
        this.setMinimumSize(new Dimension(490, 445));
        this.setPreferredSize(new Dimension(490, 445));
        this.setLayout(new GridBagLayout());
        this.pnlProxy.setLayout(new GridBagLayout());
        this.cboAutodetect.setText("Proxyserver automatisch erkennen");
        this.cboAutodetect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProxyPanel.this.cboAutodetectActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 0, 3);
        this.pnlProxy.add((Component)this.cboAutodetect, gridBagConstraints);
        this.lblGeneral.setFont(this.lblGeneral.getFont().deriveFont(this.lblGeneral.getFont().getStyle() | 1));
        this.lblGeneral.setLabelFor(this.txtHost);
        this.lblGeneral.setText("Angaben zu einem Proxyserver f\u00fcr den Internetzugriff:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 9, 3, 3);
        this.pnlProxy.add((Component)this.lblGeneral, gridBagConstraints);
        this.lblHost.setHorizontalAlignment(4);
        this.lblHost.setLabelFor(this.txtHost);
        this.lblHost.setText("Host:");
        this.lblHost.setName("");
        this.lblHost.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlProxy.add((Component)this.lblHost, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlProxy.add((Component)this.txtHost, gridBagConstraints);
        this.lblPort.setHorizontalAlignment(4);
        this.lblPort.setLabelFor(this.txtPort);
        this.lblPort.setText("Port:");
        this.lblPort.setName("");
        this.lblPort.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlProxy.add((Component)this.lblPort, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlProxy.add((Component)this.txtPort, gridBagConstraints);
        this.lblAuth.setFont(this.lblAuth.getFont().deriveFont(this.lblAuth.getFont().getStyle() | 1));
        this.lblAuth.setLabelFor(this.txtUser);
        this.lblAuth.setText("Angaben zur Authentifizierung (wenn keine leer lassen):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 9, 3, 3);
        this.pnlProxy.add((Component)this.lblAuth, gridBagConstraints);
        this.lblUser.setHorizontalAlignment(4);
        this.lblUser.setLabelFor(this.txtUser);
        this.lblUser.setText("Benutzer:");
        this.lblUser.setName("");
        this.lblUser.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlProxy.add((Component)this.lblUser, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlProxy.add((Component)this.txtUser, gridBagConstraints);
        this.lblPwd.setHorizontalAlignment(4);
        this.lblPwd.setLabelFor(this.txtPwd);
        this.lblPwd.setText("Passwort:");
        this.lblPwd.setName("");
        this.lblPwd.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlProxy.add((Component)this.lblPwd, gridBagConstraints);
        this.txtPwd.setMinimumSize(new Dimension(200, 20));
        this.txtPwd.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlProxy.add((Component)this.txtPwd, gridBagConstraints);
        this.lblISA.setFont(this.lblISA.getFont().deriveFont(this.lblISA.getFont().getStyle() | 1));
        this.lblISA.setLabelFor(this.txtAuthHost);
        this.lblISA.setText("Spezialangaben f\u00fcr Microsoft ISA Server:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 9, 3, 3);
        this.pnlProxy.add((Component)this.lblISA, gridBagConstraints);
        this.lblAuthHost.setHorizontalAlignment(4);
        this.lblAuthHost.setLabelFor(this.txtAuthHost);
        this.lblAuthHost.setText("Auth. Host:");
        this.lblAuthHost.setName("");
        this.lblAuthHost.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlProxy.add((Component)this.lblAuthHost, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlProxy.add((Component)this.txtAuthHost, gridBagConstraints);
        this.lblAuthDomain.setHorizontalAlignment(4);
        this.lblAuthDomain.setLabelFor(this.txtAuthDomain);
        this.lblAuthDomain.setText("Auth. Domain:");
        this.lblAuthDomain.setName("");
        this.lblAuthDomain.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlProxy.add((Component)this.lblAuthDomain, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlProxy.add((Component)this.txtAuthDomain, gridBagConstraints);
        this.lblNoProxy.setFont(this.lblNoProxy.getFont().deriveFont(this.lblNoProxy.getFont().getStyle() | 1));
        this.lblNoProxy.setLabelFor(this.txtNoProxy);
        this.lblNoProxy.setText("<html>Keinen Proxyserver f\u00fcr folgende Adressen:<br>(mehrere mit ; trennen)</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 9, 3, 3);
        this.pnlProxy.add((Component)this.lblNoProxy, gridBagConstraints);
        this.lblNoProxyURL.setHorizontalAlignment(4);
        this.lblNoProxyURL.setLabelFor(this.txtNoProxy);
        this.lblNoProxyURL.setText("Adressen:");
        this.lblNoProxyURL.setName("");
        this.lblNoProxyURL.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(6, 3, 6, 3);
        this.pnlProxy.add((Component)this.lblNoProxyURL, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 6, 3);
        this.pnlProxy.add((Component)this.txtNoProxy, gridBagConstraints);
        this.cboForProgram.setText("<html>Einstellungen f\u00fcr alle Programmanwender verwenden (nur als Admin m\u00f6glich)</html>");
        this.cboForProgram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProxyPanel.this.cboForProgramActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 3, 3);
        this.pnlProxy.add((Component)this.cboForProgram, gridBagConstraints);
        this.lblConfigFileWritable.setFont(this.lblConfigFileWritable.getFont().deriveFont(this.lblConfigFileWritable.getFont().getStyle() | 1));
        this.lblConfigFileWritable.setText("Schreibzugriff fehlt. Proxyeinstellungen k\u00f6nnen nicht editiert werden.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlProxy.add((Component)this.lblConfigFileWritable, gridBagConstraints);
        this.lblSystemProxyHint.setText("<html>Hinweis: Der Zugriff auf externe Ressourcen \u00fcber Webbrowser-Anwendungen (z.B. externe WMS-Ebenen im 3D-GIS) erfordert zus\u00e4tzlich die Hinterlegung des Proxyservers im Betriebssystem.</html>");
        this.lblSystemProxyHint.setVerticalAlignment(1);
        this.lblSystemProxyHint.setName("");
        this.lblSystemProxyHint.setPreferredSize(new Dimension(200, 48));
        this.lblSystemProxyHint.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlProxy.add((Component)this.lblSystemProxyHint, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.pnlProxy, gridBagConstraints);
    }

    private void cboForProgramActionPerformed(ActionEvent evt) {
        File appProxyFile = HttpClientProxyConfig.getAppProxyFile();
        File usrProxyFile = HttpClientProxyConfig.getUserProxyFile();
        if (this.cboForProgram.isSelected()) {
            this.configFile = appProxyFile;
            if (!this.configFile.exists() && usrProxyFile.exists()) {
                try {
                    FileUtils.copyFile((File)usrProxyFile, (File)this.configFile);
                }
                catch (Exception e) {
                    LOG.error("Error copying proxy file: " + usrProxyFile + " to " + this.configFile, (Throwable)e);
                }
            }
        } else {
            this.configFile = usrProxyFile;
            if (!this.configFile.exists() && appProxyFile.exists()) {
                try {
                    FileUtils.copyFile((File)usrProxyFile, (File)this.configFile);
                }
                catch (Exception e) {
                    LOG.error("Error copying proxy file: " + appProxyFile + " to " + this.configFile, (Throwable)e);
                }
            }
        }
        if (this.configFile.exists()) {
            this.init();
        }
    }

    private void cboAutodetectActionPerformed(ActionEvent evt) {
        this.updateContols();
    }
}

