/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.http;

import de.riwagis.util.Config;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.http.ProxyPanel;
import de.riwagis.util.i18n.I18N;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;

public class ProxyDialog
extends JDialog {
    private static I18N i18n = new I18N(Config.LOCALE, "de.riwagis.util.http.i18n.i18n");
    private JButton butCancel;
    private JButton butOK;
    private JPanel pnlOkCancel;
    private ProxyPanel pnlProxy;

    public ProxyDialog() {
        this.initComponents();
        this.i18n();
        this.init();
    }

    public ProxyDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.i18n();
        this.init();
    }

    public ProxyDialog(Dialog parent) {
        super(parent, true);
        this.initComponents();
        this.i18n();
        this.init();
    }

    private void i18n() {
        this.setTitle(i18n.get("http.ProxyDialog.title"));
        this.butOK.setText(i18n.get("common.ok"));
        this.butCancel.setText(i18n.get("common.cancel"));
    }

    private void init() {
        if (this.getParent() != null) {
            this.setLocationRelativeTo(this.getParent());
        }
    }

    private void initComponents() {
        this.pnlOkCancel = new JPanel();
        this.butOK = new JButton();
        this.butCancel = new JButton();
        this.pnlProxy = new ProxyPanel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.butOK.setText("OK");
        this.butOK.setPreferredSize(new Dimension(90, 23));
        this.butOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProxyDialog.this.butOK_onActionPerformed(evt);
            }
        });
        this.pnlOkCancel.add(this.butOK);
        this.butCancel.setText("Cancel");
        this.butCancel.setPreferredSize(new Dimension(90, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProxyDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.pnlOkCancel.add(this.butCancel);
        this.getContentPane().add((Component)this.pnlOkCancel, "South");
        this.getContentPane().add((Component)this.pnlProxy, "Center");
        this.pack();
    }

    private void butOK_onActionPerformed(ActionEvent evt) {
        String error = this.pnlProxy.validateInput();
        if (StringUtils.isNotEmpty((CharSequence)error)) {
            GUISupport.msgbox((Component)this, (String)error, (String)i18n.get("common.error"));
            return;
        }
        boolean bolSuccess = this.pnlProxy.okPressed();
        if (bolSuccess) {
            this.setVisible(false);
        }
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

