/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.http;

import de.riwagis.util.http.HttpClientProxyConfig;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientProxyManager {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientProxyManager.class);
    private final HttpClientProxyConfig proxyConfig;

    public HttpClientProxyManager() {
        this(false);
    }

    public HttpClientProxyManager(boolean serverSide) {
        if (serverSide) {
            File serverProxyConfigFile;
            try {
                InitialContext context = new InitialContext();
                Object serverProxyConfigPath = context.lookup("java:comp/env/proxy_config");
                serverProxyConfigFile = new File((String)serverProxyConfigPath);
            }
            catch (NamingException ex) {
                LOG.debug(String.format("proxy_config not found in JNDI-Context: %s", ex.getMessage()));
                serverProxyConfigFile = new File("no_proxy_config.xyz");
            }
            this.proxyConfig = new HttpClientProxyConfig(serverProxyConfigFile);
        } else {
            this.proxyConfig = new HttpClientProxyConfig();
        }
    }

    public HttpClientContext getHttpClientContext(URI uri) {
        HttpClientProxyConfig.Proxy proxy4uri = this.proxyConfig.getProxy(uri);
        HttpClientContext httpContext = HttpClientContext.create();
        if (StringUtils.isNotBlank((CharSequence)proxy4uri.getHost())) {
            HttpHost proxyHost = proxy4uri.getHttpHost();
            Collection<String> authPrefs = proxy4uri.configureProxyAuthentication(httpContext);
            RequestConfig config = RequestConfig.custom().setAuthenticationEnabled(true).setProxy(proxyHost).setProxyPreferredAuthSchemes(authPrefs).build();
            httpContext.setRequestConfig(config);
        }
        return httpContext;
    }
}

