/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.http;

import com.github.markusbernhardt.proxy.ProxySearch;
import com.github.markusbernhardt.proxy.selector.misc.BufferedProxySelector;
import com.github.markusbernhardt.proxy.util.PlatformUtil;
import de.riwagis.service.directory.DirectoryService;
import de.riwagis.util.jdom.JDOMUtils;
import de.riwagis.util.security.encryption.DESCryptUtils;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientProxyConfig {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientProxyConfig.class);
    public static final File APPDATADIR = System.getenv("APPDATA") == null ? new File(System.getProperty("user.home"), ".riwa") : new File(System.getenv("APPDATA"), "Riwa GmbH");
    public static final String PROXYCFG = "proxy";
    public static final String PROXYCFG_AUTODETECT = "autodetect";
    public static final String PROXYCFG_AUTHDOMAIN = "authdomain";
    public static final String PROXYCFG_AUTHHOST = "authhost";
    public static final String PROXYCFG_ENCPWD = "encpwd";
    public static final String PROXYCFG_HOST = "host";
    public static final String PROXYCFG_PORT = "port";
    public static final String PROXYCFG_USERNAME = "username";
    public static final String PROXYCFG_USERPWD = "userpwd";
    public static final String PROXYCFG_NOPROXY = "noproxy";
    private static final byte[] PROXY_ENC_KEY = new byte[]{25, 34, 110, 10, 11, 79, 42, 100};
    public static final Proxy NO_PROXY = new Proxy();
    private final Collection<String> noProxySet = new HashSet<String>();
    private final Proxy defaultProxy;
    private boolean autodetectProxy = false;
    private final Map<String, Proxy> autodetectedProxies = new HashMap<String, Proxy>();
    private ProxySelector autodetectProxySelector;

    public HttpClientProxyConfig() {
        this(null);
    }

    public HttpClientProxyConfig(File proxyConfigFile) {
        this.defaultProxy = new Proxy();
        File confFile = proxyConfigFile != null ? proxyConfigFile : HttpClientProxyConfig.getProxyFile();
        this.noProxySet.add("localhost");
        this.noProxySet.add("127.0.0.1");
        LOG.info(String.format("Reading proxy configuration from: '%s'", confFile.getAbsoluteFile()));
        if (confFile.exists()) {
            try {
                Document doc = JDOMUtils.build((File)confFile);
                Element rElem = doc.getRootElement();
                Namespace ns = rElem.getNamespace();
                Element proxyElem = rElem.getChild(PROXYCFG, ns);
                if (proxyElem != null) {
                    String strNoProxy;
                    this.defaultProxy.setHost(ObjectUtils.toString((Object)proxyElem.getChildTextTrim(PROXYCFG_HOST, ns)));
                    String strPort = ObjectUtils.toString((Object)proxyElem.getChildTextTrim(PROXYCFG_PORT, ns));
                    if (strPort.length() > 0) {
                        this.defaultProxy.setPort(Integer.parseInt(strPort));
                    } else {
                        this.defaultProxy.setPort(-1);
                    }
                    this.defaultProxy.setAuthuser(ObjectUtils.toString((Object)proxyElem.getChildTextTrim(PROXYCFG_USERNAME, ns)));
                    this.defaultProxy.setAuthpwd(ObjectUtils.toString((Object)proxyElem.getChildTextTrim(PROXYCFG_USERPWD, ns)));
                    this.defaultProxy.setAuthhost(ObjectUtils.toString((Object)proxyElem.getChildTextTrim(PROXYCFG_AUTHHOST, ns)));
                    this.defaultProxy.setAuthdomain(ObjectUtils.toString((Object)proxyElem.getChildTextTrim(PROXYCFG_AUTHDOMAIN, ns)));
                    if (proxyElem.getChild(PROXYCFG_ENCPWD, ns) != null) {
                        this.defaultProxy.setEncpwd(true);
                    }
                    if (this.defaultProxy.isEncpwd() && this.defaultProxy.getAuthpwd().length() > 0) {
                        byte[] arrByteEnc = new Base64().decode(this.defaultProxy.getAuthpwd().getBytes());
                        this.defaultProxy.setAuthpwd(DESCryptUtils.decryptToString((byte[])arrByteEnc, (byte[])PROXY_ENC_KEY));
                    }
                    if (StringUtils.isNotBlank((CharSequence)(strNoProxy = ObjectUtils.toString((Object)proxyElem.getChildTextTrim(PROXYCFG_NOPROXY, ns)).toLowerCase()))) {
                        this.noProxySet.addAll(Arrays.asList(strNoProxy.split(";")));
                    }
                    if (proxyElem.getChild(PROXYCFG_AUTODETECT, ns) != null) {
                        this.autodetectProxy = true;
                        ProxySearch ps = new ProxySearch();
                        if (null == PlatformUtil.getCurrentPlattform()) {
                            ps.addStrategy(ProxySearch.Strategy.OS_DEFAULT);
                        } else {
                            switch (PlatformUtil.getCurrentPlattform()) {
                                case WIN: {
                                    ps.addStrategy(ProxySearch.Strategy.IE);
                                    ps.addStrategy(ProxySearch.Strategy.FIREFOX);
                                    ps.addStrategy(ProxySearch.Strategy.JAVA);
                                    break;
                                }
                                case LINUX: {
                                    ps.addStrategy(ProxySearch.Strategy.GNOME);
                                    ps.addStrategy(ProxySearch.Strategy.KDE);
                                    ps.addStrategy(ProxySearch.Strategy.FIREFOX);
                                    break;
                                }
                                default: {
                                    ps.addStrategy(ProxySearch.Strategy.OS_DEFAULT);
                                }
                            }
                        }
                        ps.setPacCacheSettings(32, 300000L, BufferedProxySelector.CacheScope.CACHE_SCOPE_URL);
                        this.autodetectProxySelector = ps.getProxySelector();
                        LOG.debug("Automatic proxy detection.");
                        if (this.autodetectProxySelector == null) {
                            LOG.warn("Could not determine proxy automatically. Using direct connection.");
                        }
                    } else {
                        LOG.debug("Proxy on host/port:   " + this.defaultProxy.getHost() + ":" + this.defaultProxy.getPort());
                    }
                }
            }
            catch (Exception e) {
                LOG.error(String.format("Reading proxy from file %s failed.", confFile.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    public HttpClientProxyConfig(String host, int port, String authdomain, String authhost, String authuser, String authpwd, boolean encpwd, Collection<String> noProxySet) {
        this.defaultProxy = new Proxy(host, port, authdomain, authhost, authuser, authpwd, encpwd);
        this.noProxySet.addAll(noProxySet);
    }

    public boolean useProxyFor(URI uri) {
        boolean proxyForUri = this.useProxyFor(uri.getHost());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Use proxy is true for " + uri.toString());
        }
        return proxyForUri;
    }

    public boolean useProxyFor(String hostname) {
        if (this.noProxySet == null) {
            return true;
        }
        return !this.noProxySet.contains(hostname.toLowerCase());
    }

    public Proxy getDefaultProxy() {
        if (this.autodetectProxy) {
            return NO_PROXY;
        }
        return this.defaultProxy;
    }

    public Proxy getProxy(URI uri) {
        Proxy proxy4uri = this.getProxyInternal(uri);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Proxy4URI: " + ObjectUtils.toString((Object)uri) + "\n" + ObjectUtils.toString((Object)proxy4uri));
        }
        return proxy4uri;
    }

    private synchronized Proxy getProxyInternal(URI uri) {
        if (this.autodetectProxy) {
            if (this.autodetectProxySelector == null) {
                return NO_PROXY;
            }
            if (this.useProxyFor(uri)) {
                if (this.autodetectedProxies.containsKey(uri.getHost())) {
                    return this.autodetectedProxies.get(uri.getHost());
                }
                List<java.net.Proxy> lstNetProxies = this.autodetectProxySelector.select(uri);
                for (java.net.Proxy p : lstNetProxies) {
                    if (p.type() == Proxy.Type.DIRECT) {
                        this.autodetectedProxies.put(uri.getHost(), NO_PROXY);
                        LOG.info("No proxy detected by automatic proxy detection.");
                        return NO_PROXY;
                    }
                    if (!(p.address() instanceof InetSocketAddress)) continue;
                    InetSocketAddress isoc = (InetSocketAddress)p.address();
                    LOG.info(String.format("Proxy detected on host:port %s:%s", isoc.getHostName(), isoc.getPort()));
                    Proxy autoProxy = new Proxy(isoc.getHostName(), isoc.getPort(), null, null, null, null, false);
                    autoProxy.setAuthuser(this.defaultProxy.getAuthuser());
                    autoProxy.setEncpwd(this.defaultProxy.isEncpwd());
                    autoProxy.setAuthpwd(this.defaultProxy.getAuthpwd());
                    autoProxy.setAuthdomain(this.defaultProxy.getAuthdomain());
                    autoProxy.setAuthhost(this.defaultProxy.getAuthhost());
                    this.autodetectedProxies.put(uri.getHost(), autoProxy);
                    return autoProxy;
                }
            }
            return NO_PROXY;
        }
        if (this.useProxyFor(uri)) {
            return this.defaultProxy;
        }
        return NO_PROXY;
    }

    public static File getAppProxyFile() {
        return new File("proxy.xml");
    }

    public static File getUserProxyFile() {
        File proxyDir = DirectoryService.getInstance().getProjectProxyDirectory();
        if (!proxyDir.exists()) {
            proxyDir.mkdir();
        }
        return new File(proxyDir, "proxy.xml");
    }

    public static File getProxyFile() {
        File appProxyFile = HttpClientProxyConfig.getAppProxyFile();
        if (appProxyFile.exists() && HttpClientProxyConfig.isProxyDefined(appProxyFile)) {
            return appProxyFile;
        }
        return HttpClientProxyConfig.getUserProxyFile();
    }

    public static boolean isProxyDefined(File proxyFile) {
        try {
            Document doc = JDOMUtils.build((File)proxyFile);
            Element rElem = doc.getRootElement();
            Namespace ns = rElem.getNamespace();
            Element proxyElem = rElem.getChild(PROXYCFG, ns);
            String strHost = proxyElem.getChildTextTrim(PROXYCFG_HOST, ns);
            String strPort = proxyElem.getChildTextTrim(PROXYCFG_PORT, ns);
            return StringUtils.isNotBlank((CharSequence)strHost) && StringUtils.isNotBlank((CharSequence)strPort);
        }
        catch (Exception e) {
            LOG.error(String.format("error reading proxy config '%s': %s", proxyFile, e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public static final class Proxy {
        private String host;
        private int port;
        private String authdomain;
        private String authhost;
        private String authuser;
        private String authpwd;
        private boolean encpwd;
        private HttpHost cachedHttpHost = null;
        private Collection<String> cachedAuthPrefs = null;
        private Credentials cachedCredentials = null;

        private Proxy() {
        }

        private Proxy(String host, int port, String authdomain, String authhost, String authuser, String authpwd, boolean encpwd) {
            this.host = host;
            this.port = port;
            this.authdomain = authdomain;
            this.authhost = authhost;
            this.authuser = authuser;
            this.authpwd = authpwd;
            this.encpwd = encpwd;
        }

        public String toString() {
            if (StringUtils.isBlank((CharSequence)this.host)) {
                return "NO_PROXY";
            }
            String strProxy = "Proxy: " + this.host + ":" + this.port;
            strProxy = !StringUtils.isBlank((CharSequence)this.authhost) ? strProxy + " NTML Auth: " : strProxy + " Auth: ";
            if (!StringUtils.isBlank((CharSequence)this.authuser)) {
                strProxy = strProxy + this.authuser + "/**pwd**";
            }
            return strProxy;
        }

        private void resetCachedObjectsOnAttributeChange() {
            this.cachedHttpHost = null;
            this.cachedAuthPrefs = new ArrayList<String>();
            this.cachedAuthPrefs.add("NTLM");
            this.cachedAuthPrefs.add("Digest");
            this.cachedAuthPrefs.add("Basic");
            this.cachedCredentials = null;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public synchronized HttpHost getHttpHost() {
            if (this.cachedHttpHost != null) {
                return this.cachedHttpHost;
            }
            if (StringUtils.isNotBlank((CharSequence)this.host)) {
                LOG.debug("Configuring Proxy on Host/Port:   " + this.host + ":" + this.port);
                this.cachedHttpHost = new HttpHost(this.host, this.port);
            }
            return this.cachedHttpHost;
        }

        public synchronized Collection<String> configureProxyAuthentication(HttpClientContext httpContext) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            if (this.cachedCredentials == null) {
                if (StringUtils.isNotBlank((CharSequence)this.getHost()) && StringUtils.isNotBlank((CharSequence)this.getAuthuser())) {
                    if (StringUtils.isNotBlank((CharSequence)this.getAuthhost()) && StringUtils.isNotBlank((CharSequence)this.getAuthdomain())) {
                        this.cachedCredentials = new NTCredentials(this.getAuthuser(), this.getAuthpwd(), this.getAuthhost(), this.getAuthdomain());
                        LOG.debug("Configuring Proxy with NTLM authentication on: Host/Port:   " + this.getHost() + ":" + this.getPort());
                    } else {
                        this.cachedCredentials = new UsernamePasswordCredentials(this.getAuthuser(), this.getAuthpwd());
                        this.cachedAuthPrefs.clear();
                        this.cachedAuthPrefs.add("Digest");
                        this.cachedAuthPrefs.add("Basic");
                        this.cachedAuthPrefs.add("NTLM");
                        LOG.debug("Configuring Proxy with authentication on: Host/Port:   " + this.getHost() + ":" + this.getPort());
                    }
                    AuthScope proxyScope = new AuthScope(this.getHost(), this.getPort(), AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
                    credentialsProvider.setCredentials(proxyScope, this.cachedCredentials);
                }
            } else {
                AuthScope proxyScope = new AuthScope(this.getHost(), this.getPort(), AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
                credentialsProvider.setCredentials(proxyScope, this.cachedCredentials);
            }
            httpContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            return this.cachedAuthPrefs;
        }

        public String getAuthdomain() {
            return this.authdomain;
        }

        public String getAuthhost() {
            return this.authhost;
        }

        public String getAuthuser() {
            return this.authuser;
        }

        public String getAuthpwd() {
            return this.authpwd;
        }

        public boolean isEncpwd() {
            return this.encpwd;
        }

        private void setHost(String host) {
            this.host = host;
            this.resetCachedObjectsOnAttributeChange();
        }

        private void setPort(int port) {
            this.port = port;
            this.resetCachedObjectsOnAttributeChange();
        }

        private void setAuthdomain(String authdomain) {
            this.authdomain = authdomain;
            this.resetCachedObjectsOnAttributeChange();
        }

        private void setAuthhost(String authhost) {
            this.authhost = authhost;
            this.resetCachedObjectsOnAttributeChange();
        }

        private void setAuthuser(String authuser) {
            this.authuser = authuser;
            this.resetCachedObjectsOnAttributeChange();
        }

        private void setAuthpwd(String authpwd) {
            this.authpwd = authpwd;
            this.resetCachedObjectsOnAttributeChange();
        }

        private void setEncpwd(boolean encpwd) {
            this.encpwd = encpwd;
            this.resetCachedObjectsOnAttributeChange();
        }
    }
}

