/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.http;

import java.nio.charset.Charset;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;

public class HttpClientConfig {
    private final Charset charset;
    private final int socketTimeoutInMillis;
    private final int connTimeoutInMillis;
    private final int parallelConnections;
    private final CredentialsProvider credentialsProvider;
    private final boolean validateRootCAs;

    private static CredentialsProvider createDefaultCredentialsProvider() {
        return new BasicCredentialsProvider();
    }

    private static CredentialsProvider $default$credentialsProvider() {
        return HttpClientConfig.createDefaultCredentialsProvider();
    }

    private static boolean $default$validateRootCAs() {
        return true;
    }

    HttpClientConfig(Charset charset, int socketTimeoutInMillis, int connTimeoutInMillis, int parallelConnections, CredentialsProvider credentialsProvider, boolean validateRootCAs) {
        this.charset = charset;
        this.socketTimeoutInMillis = socketTimeoutInMillis;
        this.connTimeoutInMillis = connTimeoutInMillis;
        this.parallelConnections = parallelConnections;
        this.credentialsProvider = credentialsProvider;
        this.validateRootCAs = validateRootCAs;
    }

    public static HttpClientConfigBuilder builder() {
        return new HttpClientConfigBuilder();
    }

    public Charset getCharset() {
        return this.charset;
    }

    public int getSocketTimeoutInMillis() {
        return this.socketTimeoutInMillis;
    }

    public int getConnTimeoutInMillis() {
        return this.connTimeoutInMillis;
    }

    public int getParallelConnections() {
        return this.parallelConnections;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public boolean isValidateRootCAs() {
        return this.validateRootCAs;
    }

    public String toString() {
        return "HttpClientConfig(charset=" + this.getCharset() + ", socketTimeoutInMillis=" + this.getSocketTimeoutInMillis() + ", connTimeoutInMillis=" + this.getConnTimeoutInMillis() + ", parallelConnections=" + this.getParallelConnections() + ", credentialsProvider=" + this.getCredentialsProvider() + ", validateRootCAs=" + this.isValidateRootCAs() + ")";
    }

    public static class HttpClientConfigBuilder {
        private Charset charset;
        private int socketTimeoutInMillis;
        private int connTimeoutInMillis;
        private int parallelConnections;
        private boolean credentialsProvider$set;
        private CredentialsProvider credentialsProvider$value;
        private boolean validateRootCAs$set;
        private boolean validateRootCAs$value;

        HttpClientConfigBuilder() {
        }

        public HttpClientConfigBuilder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public HttpClientConfigBuilder socketTimeoutInMillis(int socketTimeoutInMillis) {
            this.socketTimeoutInMillis = socketTimeoutInMillis;
            return this;
        }

        public HttpClientConfigBuilder connTimeoutInMillis(int connTimeoutInMillis) {
            this.connTimeoutInMillis = connTimeoutInMillis;
            return this;
        }

        public HttpClientConfigBuilder parallelConnections(int parallelConnections) {
            this.parallelConnections = parallelConnections;
            return this;
        }

        public HttpClientConfigBuilder credentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider$value = credentialsProvider;
            this.credentialsProvider$set = true;
            return this;
        }

        public HttpClientConfigBuilder validateRootCAs(boolean validateRootCAs) {
            this.validateRootCAs$value = validateRootCAs;
            this.validateRootCAs$set = true;
            return this;
        }

        public HttpClientConfig build() {
            CredentialsProvider credentialsProvider$value = this.credentialsProvider$value;
            if (!this.credentialsProvider$set) {
                credentialsProvider$value = HttpClientConfig.$default$credentialsProvider();
            }
            boolean validateRootCAs$value = this.validateRootCAs$value;
            if (!this.validateRootCAs$set) {
                validateRootCAs$value = HttpClientConfig.$default$validateRootCAs();
            }
            return new HttpClientConfig(this.charset, this.socketTimeoutInMillis, this.connTimeoutInMillis, this.parallelConnections, credentialsProvider$value, validateRootCAs$value);
        }

        public String toString() {
            return "HttpClientConfig.HttpClientConfigBuilder(charset=" + this.charset + ", socketTimeoutInMillis=" + this.socketTimeoutInMillis + ", connTimeoutInMillis=" + this.connTimeoutInMillis + ", parallelConnections=" + this.parallelConnections + ", credentialsProvider$value=" + this.credentialsProvider$value + ", validateRootCAs$value=" + this.validateRootCAs$value + ")";
        }
    }
}

