/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.http;

import de.riwagis.util.exception.SystemException;
import de.riwagis.util.http.HttpClientConfig;
import de.riwagis.util.http.HttpClientProxyManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPClientSupport {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPClientSupport.class);
    private static final CloseableHttpClient COMMON_HTTP_CLIENT = HTTPClientSupport.generateHttpClient("UTF-8", 3600000, 3600000, 1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int downloadAsFile(CloseableHttpClient client, HttpContext context, String url, File outFile) throws IOException {
        HttpGet httpAccess = new HttpGet(url);
        CloseableHttpResponse response = client.execute((HttpUriRequest)httpAccess, context);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine == null) throw new IOException(String.format("Failed to download file '%s' from '%s'", outFile, url));
        if (statusLine.getStatusCode() == 200) {
            try (InputStream is = response.getEntity().getContent();){
                int n;
                try (FileOutputStream out = new FileOutputStream(outFile);){
                    int ret;
                    n = ret = IOUtils.copy((InputStream)is, (OutputStream)out);
                }
                return n;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        throw new IOException(String.format("Failed to download file '%s' from '%s': Code %d", outFile, url, statusLine.getStatusCode()));
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static String loadPage(CloseableHttpClient client, HttpContext context, String url) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String loadPage(CloseableHttpClient client, HttpClientProxyManager clientProxyManager, String url) throws IOException {
        return HTTPClientSupport.loadPage(client, (HttpContext)HTTPClientSupport.getHttpClientContext(clientProxyManager, url), url);
    }

    private HTTPClientSupport() {
    }

    @Deprecated
    public static CloseableHttpClient generateHttpClient(String charset, int socketTimeoutInMillis, int connTimeoutInMillis, int parallelConnections) {
        return HTTPClientSupport.generateHttpClient(HttpClientConfig.builder().charset(Charset.forName(charset)).socketTimeoutInMillis(socketTimeoutInMillis).connTimeoutInMillis(connTimeoutInMillis).parallelConnections(parallelConnections).build());
    }

    @Deprecated
    public static CloseableHttpClient generateHttpClient(String charset, int socketTimeoutInMillis, int connTimeoutInMillis, int parallelConnections, CredentialsProvider credentialsProvider) {
        return HTTPClientSupport.generateHttpClient(HttpClientConfig.builder().charset(Charset.forName(charset)).socketTimeoutInMillis(socketTimeoutInMillis).connTimeoutInMillis(connTimeoutInMillis).parallelConnections(parallelConnections).credentialsProvider(credentialsProvider).build());
    }

    public static CloseableHttpClient generateHttpClient(HttpClientConfig httpClientConfig) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpClientBuilder.setMaxConnTotal(httpClientConfig.getParallelConnections());
        httpClientBuilder.setMaxConnPerRoute(httpClientConfig.getParallelConnections());
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setSocketTimeout(httpClientConfig.getSocketTimeoutInMillis());
        requestConfigBuilder.setConnectTimeout(httpClientConfig.getConnTimeoutInMillis());
        httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        PlainConnectionSocketFactory sf = PlainConnectionSocketFactory.getSocketFactory();
        SSLContext sslContext = httpClientConfig.isValidateRootCAs() ? SSLContexts.createSystemDefault() : HTTPClientSupport.getSSLContextTrustingEverything();
        SSLConnectionSocketFactory ssl = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry socketRegistry = RegistryBuilder.create().register("http", (Object)sf).register("https", (Object)ssl).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketRegistry);
        connectionManager.setMaxTotal(httpClientConfig.getParallelConnections());
        connectionManager.setDefaultMaxPerRoute(httpClientConfig.getParallelConnections());
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        httpClientBuilder.setDefaultSocketConfig(SocketConfig.custom().setSndBufSize(131072).setRcvBufSize(131072).setSoTimeout(httpClientConfig.getSocketTimeoutInMillis()).build());
        if (httpClientConfig.getCharset() != null) {
            ConnectionConfig connectionConfig = ConnectionConfig.custom().setCharset(httpClientConfig.getCharset()).build();
            httpClientBuilder.setDefaultConnectionConfig(connectionConfig);
        }
        httpClientBuilder.setDefaultCredentialsProvider(httpClientConfig.getCredentialsProvider());
        httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler(3, true){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                boolean retry = super.retryRequest(exception, executionCount, context);
                if (retry) {
                    LOG.warn("request retry " + executionCount + " because " + exception);
                } else {
                    LOG.error("request non-retriable: " + exception);
                }
                return retry;
            }
        });
        CloseableHttpClient httpClient = httpClientBuilder.build();
        return httpClient;
    }

    private static SSLContext getSSLContextTrustingEverything() {
        try {
            return SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustAllStrategy()).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            LOG.error("Could not generate SSL Context.", (Throwable)e);
            return null;
        }
    }

    public static String postMultipart(FormBodyPart[] _parts, String _postURL) throws SystemException {
        StringBuffer responseText = new StringBuffer();
        StringBuffer errorText = new StringBuffer();
        try {
            int status = HTTPClientSupport.postMultipart(_parts, _postURL, responseText, errorText);
            if (status != 200) {
                throw new Exception(errorText.toString());
            }
        }
        catch (Exception e) {
            throw new SystemException(HTTPClientSupport.class, (Throwable)e);
        }
        return responseText.toString();
    }

    public static int postMultipart(CloseableHttpClient client, HttpContext context, FormBodyPart[] _parts, String _postURL, File responseFile, StringBuffer _errorText) throws IOException {
        try (FileOutputStream out = responseFile != null ? new FileOutputStream(responseFile) : null;){
            int n = HTTPClientSupport.postMultipart(client, context, _parts, _postURL, out, _errorText);
            return n;
        }
    }

    public static int postMultipart(CloseableHttpClient client, HttpContext context, FormBodyPart[] _parts, String _postURL, OutputStream responseOutStream, StringBuffer _errorText) throws IOException {
        HttpPost filePost = new HttpPost(_postURL);
        HttpEntity multipartRequestEntity = HTTPClientSupport.buildHttpEntity(_parts);
        filePost.setEntity(multipartRequestEntity);
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)filePost, context);){
            int status = response.getStatusLine().getStatusCode();
            if (responseOutStream != null) {
                try (InputStream is = response.getEntity().getContent();){
                    if (is != null) {
                        IOUtils.copy((InputStream)is, (OutputStream)responseOutStream);
                    }
                }
            }
            if (_errorText != null) {
                _errorText.append(String.format("Error on postMultipart. HttpStatus: %d ('%s', '%s')", status, response.getStatusLine(), response.getStatusLine().getReasonPhrase()));
            }
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            int n = status;
            return n;
        }
    }

    public static int postMultipart(CloseableHttpClient httpClient, HttpClientProxyManager clientProxyManager, FormBodyPart[] bodyParts, String checkFileURL, File filesCheckResultFile, StringBuffer checkFileErrors) throws IOException {
        return HTTPClientSupport.postMultipart(httpClient, (HttpContext)HTTPClientSupport.getHttpClientContext(clientProxyManager, checkFileURL), bodyParts, checkFileURL, filesCheckResultFile, checkFileErrors);
    }

    public static int downloadAsFile(CloseableHttpClient httpClient, HttpClientProxyManager clientProxyManager, String pageURL, File x) throws IOException {
        return HTTPClientSupport.downloadAsFile(httpClient, (HttpContext)HTTPClientSupport.getHttpClientContext(clientProxyManager, pageURL), pageURL, x);
    }

    public static HttpEntity buildHttpEntity(Collection<FormBodyPart> _parts) {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        for (FormBodyPart _part : _parts) {
            multipartEntityBuilder.addPart(_part);
        }
        HttpEntity multipartRequestEntity = multipartEntityBuilder.build();
        return multipartRequestEntity;
    }

    public static HttpEntity buildHttpEntity(FormBodyPart ... _parts) {
        return HTTPClientSupport.buildHttpEntity(Arrays.asList(_parts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int postMultipart(CloseableHttpClient client, HttpContext context, FormBodyPart[] _parts, String _postURL, StringBuffer _responseText, StringBuffer _errorText) throws IOException {
        HttpPost filePost = new HttpPost(_postURL);
        filePost.setEntity(HTTPClientSupport.buildHttpEntity(_parts));
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)filePost, context);){
            int n;
            try {
                int status = response.getStatusLine().getStatusCode();
                if (_responseText != null) {
                    _responseText.append(EntityUtils.toString((HttpEntity)response.getEntity()));
                }
                if (_errorText != null) {
                    _errorText.append(String.format("Error on postMultipart. HttpStatus: %d ('%s', '%s')", status, response.getStatusLine(), response.getStatusLine().getReasonPhrase()));
                }
                n = status;
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                throw throwable;
            }
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int postMultipart(FormBodyPart[] _parts, String _postURL, StringBuffer _responseText, StringBuffer _errorText) throws IOException {
        CloseableHttpClient closeableHttpClient = COMMON_HTTP_CLIENT;
        synchronized (closeableHttpClient) {
            return HTTPClientSupport.postMultipart(COMMON_HTTP_CLIENT, null, _parts, _postURL, _responseText, _errorText);
        }
    }

    public static FormBodyPart createStringBodyPart(String partname, String value) throws UnsupportedEncodingException {
        return FormBodyPartBuilder.create((String)partname, (ContentBody)new StringBody(value, ContentType.TEXT_PLAIN)).build();
    }

    public static FormBodyPart createFileBodyPart(String strName, File file) throws UnsupportedEncodingException {
        return FormBodyPartBuilder.create((String)strName, (ContentBody)new FileBody(file)).build();
    }

    public static URI generateBaseURI(String strURL) throws URISyntaxException {
        URI ur = URI.create(strURL);
        return HTTPClientSupport.generateBaseURI(ur);
    }

    public static URI generateBaseURI(URI ur) throws URISyntaxException {
        URI baseURI = new URI(ur.getScheme(), ur.getHost(), "", "");
        return baseURI;
    }

    public static HttpClientContext getHttpClientContext(HttpClientProxyManager clientProxyManager, String strURL) throws IOException {
        try {
            URI baseURI = HTTPClientSupport.generateBaseURI(strURL);
            return HTTPClientSupport.getHttpClientContext(clientProxyManager, baseURI);
        }
        catch (URISyntaxException ex) {
            throw new IOException(String.format("unable to parse uri '%s': %s", strURL, ex.getMessage()), ex);
        }
    }

    public static HttpClientContext getHttpClientContext(HttpClientProxyManager clientProxyManager, URI baseURI) throws URISyntaxException {
        return clientProxyManager.getHttpClientContext(HTTPClientSupport.generateBaseURI(baseURI));
    }
}

