/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.version.riwajump;

import de.riwagis.riwajump.model.version.JumpDocumentTransformer;
import de.riwagis.util.jdom.JDOMUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryConverter.class);

    private DirectoryConverter() {
    }

    public static void convertDirectory(File fDir, PrintWriter pw, String prgVersion, int jmpVersion) throws IOException {
        File[] arrFiles;
        for (File arrFile : arrFiles = fDir.listFiles(new JmpFileFilter())) {
            if (arrFile.isDirectory()) {
                DirectoryConverter.convertDirectory(arrFile, pw, prgVersion, jmpVersion);
                continue;
            }
            DirectoryConverter.convertFile(arrFile, pw, prgVersion, jmpVersion);
        }
    }

    public static Document retrieveDoc(File fTask) throws JDOMException, IOException {
        try (ZipInputStream zin = new ZipInputStream(new FileInputStream(fTask));){
            Document doc;
            zin.getNextEntry();
            Document document = doc = JDOMUtils.build((Reader)new InputStreamReader((InputStream)zin, StandardCharsets.UTF_8));
            return document;
        }
    }

    public static void convertFile(File fTask, PrintWriter pw, String prgVersion, int jmpVersion) throws IOException {
        try {
            Document doc = DirectoryConverter.retrieveDoc(fTask);
            if (!JumpDocumentTransformer.convertAndAdjustDoc(doc, prgVersion, jmpVersion)) {
                return;
            }
            DirectoryConverter.writeDoc(fTask, doc);
            pw.println(String.format("Task %s converted.<br>", fTask));
            pw.flush();
        }
        catch (IOException | JDOMException e) {
            pw.println(String.format("Task conversion failed for: %s (See servers error log for details.)<br>", fTask));
            LOG.error(String.format("Task conversion failed for: %s", fTask), e);
        }
    }

    private static void writeDoc(File fTask, Document doc) throws FileNotFoundException, IOException {
        try (ZipOutputStream zipout = new ZipOutputStream(new FileOutputStream(fTask));){
            ZipEntry zEntry = new ZipEntry("project.xml");
            zipout.putNextEntry(zEntry);
            JDOMUtils.output((Document)doc, (Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)zipout, StandardCharsets.UTF_8)));
        }
    }

    private static class JmpFileFilter
    implements FileFilter {
        private JmpFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || StringUtils.endsWithIgnoreCase((CharSequence)f.getName(), (CharSequence)"jmp");
        }
    }
}

