/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.version;

import de.riwagis.riwajump.model.version.AbstractVersionDependentAdjuster;
import de.riwagis.riwajump.model.version.BasicStyleElementFix;
import java.util.ArrayList;
import java.util.Collection;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionDependentAdjuster_V21
extends AbstractVersionDependentAdjuster {
    private static final Logger log = LoggerFactory.getLogger(VersionDependentAdjuster_V21.class);
    private Collection<Element> smds = new ArrayList<Element>();
    private BasicStyleElementFix basicStyleElementFix = new BasicStyleElementFix();

    @Override
    public int versionNumberToTarget() {
        return 21;
    }

    @Override
    public boolean needsAdjustmentsOnCrash(Document doc) {
        this.smds = new ArrayList<Element>();
        this.collectFakeSMDBugs(doc);
        return !this.smds.isEmpty();
    }

    @Override
    public void adjustOnCrash(Document doc) {
        if (this.smds.isEmpty()) {
            this.collectFakeSMDBugs(doc);
        }
        for (Element smd : this.smds) {
            smd.removeChildren("com.vividsolutions.jump.workbench.model.RedlineLayer_-1");
        }
    }

    @Override
    public boolean needsAdjustmentsBeforeDeserialization(Document doc) {
        Collection<Element> bugCollection = this.basicStyleElementFix.initializeBasicStyleBugCollection(doc);
        return !bugCollection.isEmpty();
    }

    @Override
    public void adjustBeforeDeserialization(Document doc) {
        Collection<Element> bugCollection = this.basicStyleElementFix.getStyleCollectionWithBasicStyle();
        if (bugCollection.isEmpty()) {
            bugCollection = this.basicStyleElementFix.initializeBasicStyleBugCollection(doc);
        }
        for (Element lstStyleCollection : bugCollection) {
            this.basicStyleElementFix.fixBuggyLstLayerStyleCollection(lstStyleCollection);
        }
    }

    private void collectFakeSMDBugs(Document doc) {
        VersionDependentAdjuster_V21.doOnElement(doc.getRootElement(), elem -> {
            if (elem.getName().equals("com.vividsolutions.jump.workbench.model.RedlineLayer_-1")) {
                this.smds.add(elem.getParentElement());
            }
        }, true);
    }
}

