/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.version;

import de.riwagis.riwajump.model.version.VersionDependentAdjuster_V21;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.jdom2.Document;

public interface VersionDependentAdjuster {
    public static final List<VersionDependentAdjuster> ADJUSTERS = List.of(new VersionDependentAdjuster_V21());

    public boolean needsAdjustmentsBeforeDeserialization(Document var1);

    public boolean needsAdjustmentsOnCrash(Document var1);

    public int versionNumberToTarget();

    public void adjustOnCrash(Document var1);

    public void adjustBeforeDeserialization(Document var1);

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum AdjusterType {
        ON_CRASH{

            @Override
            public boolean adjustIfNecessary(Document doc, int currentProjectVersion) {
                return AdjusterType.findAndAdjust(currentProjectVersion, doc, VersionDependentAdjuster::needsAdjustmentsOnCrash, VersionDependentAdjuster::adjustOnCrash);
            }
        }
        ,
        BEFORE_DESERIALIZATION{

            @Override
            public boolean adjustIfNecessary(Document doc, int currentProjectVersion) {
                return AdjusterType.findAndAdjust(currentProjectVersion, doc, VersionDependentAdjuster::needsAdjustmentsBeforeDeserialization, VersionDependentAdjuster::adjustBeforeDeserialization);
            }
        };


        public abstract boolean adjustIfNecessary(Document var1, int var2);

        private static boolean findAndAdjust(int currentProjectVersion, Document doc, BiPredicate<VersionDependentAdjuster, Document> needsAdjustment, BiConsumer<VersionDependentAdjuster, Document> adjustAction) {
            for (VersionDependentAdjuster adjuster : ADJUSTERS) {
                if (!Objects.equals(currentProjectVersion, adjuster.versionNumberToTarget()) || !needsAdjustment.test(adjuster, doc)) continue;
                adjustAction.accept(adjuster, doc);
                return true;
            }
            return false;
        }
    }
}

