/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.version;

import de.riwagis.riwajump.model.search.WildcardSearchEnum;
import de.riwagis.riwajump.model.version.AbstractVersionConverter;
import de.riwagis.riwajump.model.version.BasicStyleElementFix;
import java.util.ArrayList;
import java.util.Collection;
import org.jdom2.Document;
import org.jdom2.Element;

public class VConv_Prj_V21_V22
extends AbstractVersionConverter {
    public static final String WILDCARD = "wildcard";
    public static final String FIELDINPUT = "fieldinput";

    @Override
    public boolean needsConversion(Document doc) {
        int intPrjVersion = AbstractVersionConverter.getProjectVersion(doc);
        return intPrjVersion < this.newVersionNumber();
    }

    @Override
    public void convert(Document doc) {
        ArrayList<Element> smds = new ArrayList<Element>();
        VConv_Prj_V21_V22.doOnElement(doc.getRootElement(), elem -> {
            if (this.isFieldinput((Element)elem)) {
                VConv_Prj_V21_V22.addElementIfNotPresent(elem, WILDCARD, WildcardSearchEnum.WILDCARD_TRAILING.getValue());
            }
            if (elem.getName().equals("com.vividsolutions.jump.workbench.model.RedlineLayer_-1")) {
                smds.add(elem.getParentElement());
            }
        }, true);
        VConv_Prj_V21_V22.fixFakeSmdRedline(smds);
        VConv_Prj_V21_V22.fixWrongBasicStyles(doc);
    }

    @Override
    public void unconvert(Document doc) {
        VConv_Prj_V21_V22.doOnElement(doc.getRootElement(), elem -> {
            if (this.isFieldinput((Element)elem)) {
                elem.removeChild(WILDCARD);
            }
        }, true);
    }

    @Override
    public boolean supportsUnconvert() {
        return true;
    }

    @Override
    public int oldVersionNumber() {
        return 21;
    }

    @Override
    public int newVersionNumber() {
        return 22;
    }

    @Override
    public String oldVersionName() {
        return this.oldVersionNumber() + " Client 2.9.x";
    }

    private boolean isFieldinput(Element elem) {
        return elem.getName().equals(FIELDINPUT);
    }

    private static void fixFakeSmdRedline(Collection<Element> smds) {
        for (Element smd : smds) {
            smd.removeChildren("com.vividsolutions.jump.workbench.model.RedlineLayer_-1");
        }
    }

    private static void fixWrongBasicStyles(Document doc) {
        BasicStyleElementFix basicStyleElementFix = new BasicStyleElementFix();
        Collection<Element> bugCollection = basicStyleElementFix.initializeBasicStyleBugCollection(doc);
        for (Element lstStyleCollection : bugCollection) {
            basicStyleElementFix.fixBuggyLstLayerStyleCollection(lstStyleCollection);
        }
    }
}

