/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.version;

import de.riwagis.riwajump.model.version.AbstractVersionConverter;
import java.util.ArrayList;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class VConv_Prj_V20_V21
extends AbstractVersionConverter {
    public static final String CHILD_FMD = "fmd";
    public static final String CHILD_ATTRIBUTE_TABLE = "attributeTable";
    public static final String FAKE_SMD_REDLINE_BUG = "com.vividsolutions.jump.workbench.model.RedlineLayer_-1";
    public static final String ATTS = "atts";
    public static final String ATTRIBUTE_PROPERTIES = "attributeProperties";
    public static final String PROPERTY = "property";
    public static final String NAME = "name";
    public static final String ALIAS = "alias";
    public static final String VISIBLE = "visible";

    @Override
    public boolean needsConversion(Document doc) {
        int intPrjVersion = AbstractVersionConverter.getProjectVersion(doc);
        return intPrjVersion < 21;
    }

    @Override
    public void convert(Document doc) {
        ArrayList layers = new ArrayList();
        ArrayList smds = new ArrayList();
        VConv_Prj_V20_V21.doOnElement(doc.getRootElement(), elem -> {
            if (this.isFeatureStore((Element)elem)) {
                layers.add(elem.getParentElement());
            } else if (this.isFakeSMDBug((Element)elem)) {
                smds.add(elem.getParentElement());
            }
        }, true);
        for (Element layer : layers) {
            this.createAttributeTable(layer);
        }
        for (Element smd : smds) {
            smd.removeChildren(FAKE_SMD_REDLINE_BUG);
        }
    }

    private void createAttributeTable(Element elemLayer) {
        ArrayList<Element> tableAttributes = new ArrayList<Element>();
        Element fmd = elemLayer.getChild(CHILD_FMD);
        Element attributes = fmd.getChild(ATTS);
        if (attributes == null) {
            attributes = new Element(ATTS);
            fmd.addContent((Content)attributes);
        }
        for (Element child : attributes.getChildren()) {
            Element tableAttribute = new Element(PROPERTY);
            VConv_Prj_V20_V21.addElementIfNotPresent(tableAttribute, NAME, child.getValue());
            VConv_Prj_V20_V21.addElementIfNotPresent(tableAttribute, ALIAS, "");
            VConv_Prj_V20_V21.addElementIfNotPresent(tableAttribute, VISIBLE, "true");
            tableAttributes.add(tableAttribute);
        }
        Element attributeTable = new Element(CHILD_ATTRIBUTE_TABLE);
        Element attributeProperties = new Element(ATTRIBUTE_PROPERTIES);
        attributeProperties.addContent(tableAttributes);
        attributeTable.addContent((Content)attributeProperties);
        elemLayer.addContent((Content)attributeTable);
    }

    @Override
    public void unconvert(Document doc) {
        ArrayList layers = new ArrayList();
        VConv_Prj_V20_V21.doOnElement(doc.getRootElement(), elem -> {
            if (this.isAttributeTable((Element)elem)) {
                layers.add(elem.getParentElement());
            }
        }, true);
        for (Element layer : layers) {
            layer.removeChild(CHILD_ATTRIBUTE_TABLE);
        }
    }

    @Override
    public boolean supportsUnconvert() {
        return true;
    }

    @Override
    public int oldVersionNumber() {
        return 20;
    }

    @Override
    public int newVersionNumber() {
        return 21;
    }

    @Override
    public String oldVersionName() {
        return this.oldVersionNumber() + " Client 2.8.x";
    }

    private boolean isFeatureStore(Element elem) {
        return elem.getName().equals(CHILD_FMD);
    }

    private boolean isAttributeTable(Element elem) {
        return elem.getName().equals(CHILD_ATTRIBUTE_TABLE);
    }

    private boolean isFakeSMDBug(Element elem) {
        return elem.getName().equals(FAKE_SMD_REDLINE_BUG);
    }
}

