/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.version;

import de.riwagis.riwajump.model.version.AbstractVersionConverter;
import de.riwagis.util.Config;
import de.riwagis.util.i18n.I18N;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class VConv_Prj_V19_V20
extends AbstractVersionConverter {
    private final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.riwajump.model.i18n");
    private static final String V19_NO_INSERT = "noInsert";
    private static final String V20_INSERT_ALLOWED = "insertAllowed";
    private static final String V20_DELETE_ALLOWED = "deleteAllowed";
    private static final String CRS_TO = "crsTo";
    private static final String CRS_FROM = "crsFrom";
    private static final String SRS_XY = "xy";
    private static final String THEME_CLASS = "class";
    private static final String THEME_USE_RANGE = "useRange";
    private static final String THEME_SOURCE = "themeSource";

    @Override
    public boolean needsConversion(Document doc) {
        int intPrjVersion = AbstractVersionConverter.getProjectVersion(doc);
        return intPrjVersion < 20;
    }

    @Override
    public void convert(Document doc) {
        VConv_Prj_V19_V20.doOnElement(doc.getRootElement(), elem -> {
            if (this.isWmtsStyle((Element)elem)) {
                this.introduceTileSetThreshold((Element)elem);
            } else if (this.isFeatureStore((Element)elem)) {
                this.replaceNoInsertWithNewDeleteAndInsertFlags((Element)elem);
                this.removeCrsIfIdenticalForAutoProjection((Element)elem);
                this.removeUselessFormatters((Element)elem);
            } else if (this.isThemingStyle((Element)elem)) {
                this.moveStaticThemeSettingsToNewSource((Element)elem);
            }
        }, true);
    }

    private void introduceTileSetThreshold(Element elem) {
        Element thresholdElement = new Element("tileSetThreshold", elem.getNamespace());
        thresholdElement.setText("0.66");
        elem.addContent((Content)thresholdElement);
    }

    private void replaceNoInsertWithNewDeleteAndInsertFlags(Element elem) {
        Element noInsert = elem.getChild(V19_NO_INSERT, elem.getNamespace());
        boolean wasInsertAllowed = noInsert == null || !"true".equals(noInsert.getText());
        elem.removeChild(V19_NO_INSERT);
        Element insertAllowed = new Element(V20_INSERT_ALLOWED);
        Element deleteAllowed = new Element(V20_DELETE_ALLOWED);
        insertAllowed.setText(Boolean.toString(wasInsertAllowed));
        deleteAllowed.setText(Boolean.toString(wasInsertAllowed));
        elem.addContent((Content)insertAllowed);
        elem.addContent((Content)deleteAllowed);
    }

    private void removeCrsIfIdenticalForAutoProjection(Element elem) {
        Element fromCrs = elem.getChild(CRS_FROM);
        Element toCrs = elem.getChild(CRS_TO);
        if (fromCrs != null && toCrs != null && fromCrs.getText().equals(toCrs.getText())) {
            elem.removeChild(CRS_FROM);
            elem.removeChild(CRS_TO);
        }
    }

    @Override
    public void unconvert(Document doc) {
        VConv_Prj_V19_V20.doOnElement(doc.getRootElement(), elem -> {
            if (this.isWmtsStyle((Element)elem)) {
                this.removeTileSetThreshold((Element)elem);
            } else if (this.isFeatureStore((Element)elem)) {
                this.replaceNewDeleteAndInsertFlagsWithOldNoInsert((Element)elem);
                this.addCrsIfIdenticalForOldFormat((Element)elem);
            } else if (this.isThemingStyle((Element)elem)) {
                this.removeThemeSourceAndConvertDynamicToStaticTheme((Element)elem);
            }
        }, true);
    }

    private void moveStaticThemeSettingsToNewSource(Element themeStyle) {
        Element useRange = themeStyle.getChild(THEME_USE_RANGE);
        themeStyle.removeChild(THEME_USE_RANGE);
        Set<String> elementsToKeep = Set.of("enabled", "attributeName", "useElseFilter");
        ArrayList<Element> elementsOfSource = new ArrayList<Element>();
        for (Element child : themeStyle.getChildren()) {
            if (elementsToKeep.contains(child.getName())) continue;
            elementsOfSource.add(child);
        }
        Element themeSource = new Element(THEME_SOURCE, themeStyle.getNamespace());
        themeStyle.addContent((Content)themeSource);
        if (useRange != null && "true".equals(useRange.getValue())) {
            themeSource.setAttribute(THEME_CLASS, "staticRangeThemeSource");
        } else {
            themeSource.setAttribute(THEME_CLASS, "staticDiscreteThemeSource");
        }
        for (Element sourceElement : elementsOfSource) {
            themeStyle.removeContent((Content)sourceElement);
            themeSource.addContent((Content)sourceElement);
        }
    }

    private void removeTileSetThreshold(Element elem) {
        elem.removeChild("tileSetThreshold");
    }

    private void replaceNewDeleteAndInsertFlagsWithOldNoInsert(Element elem) {
        Element insertAllowedElement = elem.getChild(V20_INSERT_ALLOWED);
        Element deleteAllowedElement = elem.getChild(V20_DELETE_ALLOWED);
        boolean insertAllowed = "true".equals(insertAllowedElement.getText());
        boolean deleteAllowed = "true".equals(deleteAllowedElement.getText());
        elem.removeChild(V20_INSERT_ALLOWED);
        elem.removeChild(V20_DELETE_ALLOWED);
        Element noInsert = new Element(V19_NO_INSERT, elem.getNamespace());
        noInsert.setText(Boolean.toString(!insertAllowed && !deleteAllowed));
        elem.addContent((Content)noInsert);
    }

    private void addCrsIfIdenticalForOldFormat(Element elem) {
        Element fromCrs = elem.getChild(CRS_FROM);
        Element toCrs = elem.getChild(CRS_TO);
        if (fromCrs == null || toCrs == null || StringUtils.isBlank((CharSequence)fromCrs.getText()) || StringUtils.isBlank((CharSequence)toCrs.getText())) {
            Element newCrsFrom = new Element(CRS_FROM, elem.getNamespace());
            newCrsFrom.setText(SRS_XY);
            elem.addContent((Content)newCrsFrom);
            Element newCrsTo = new Element(CRS_TO, elem.getNamespace());
            newCrsTo.setText(SRS_XY);
            elem.addContent((Content)newCrsTo);
        }
    }

    private void removeThemeSourceAndConvertDynamicToStaticTheme(Element themeStyle) {
        String sourceClass;
        Element themeSource = themeStyle.getChild(THEME_SOURCE);
        switch (sourceClass = themeSource.getAttribute(THEME_CLASS).getValue()) {
            case "staticRangeThemeSource": {
                this.pullStaticThemeSourceMembersUp(themeStyle, themeSource, true);
                break;
            }
            case "staticDiscreteThemeSource": {
                this.pullStaticThemeSourceMembersUp(themeStyle, themeSource, false);
                break;
            }
            case "dynamicThemeSource": {
                this.convertDynamicToStaticTheme(themeStyle, themeSource);
                break;
            }
            default: {
                throw new IllegalStateException("Theme Source Type " + sourceClass + " is unknown.");
            }
        }
    }

    private void pullStaticThemeSourceMembersUp(Element themeStyle, Element themeSource, boolean useRange) {
        this.addRangeElement(themeStyle, useRange);
        themeStyle.removeContent((Content)themeSource);
        ArrayList<Element> sourceElements = new ArrayList<Element>();
        for (Element child : themeSource.getChildren()) {
            sourceElements.add(child);
        }
        for (Element sourceElement : sourceElements) {
            themeSource.removeContent((Content)sourceElement);
            themeStyle.addContent((Content)sourceElement);
        }
    }

    private void convertDynamicToStaticTheme(Element themeStyle, Element themeSource) {
        themeStyle.removeContent((Content)themeSource);
        this.addRangeElement(themeStyle, false);
        Element newDefaultStyle = themeSource.getChild("templateStyle");
        themeSource.removeContent((Content)newDefaultStyle);
        newDefaultStyle.setName("defaultStyle");
        Element styleEnabled = newDefaultStyle.getChild("enabled");
        styleEnabled.setText("true");
        themeStyle.addContent((Content)newDefaultStyle);
        Element useElseFilter = themeStyle.getChild("useElseFilter");
        useElseFilter.setText("true");
        Element defaultLabel = new Element("defaultLabel", themeStyle.getNamespace());
        defaultLabel.setText(this.i18n.get("version.convert-v19-v20.dynamic-theme-not-supported"));
        themeStyle.addContent((Content)defaultLabel);
        Element emptyThemeList = new Element("themes", themeStyle.getNamespace());
        themeStyle.addContent((Content)emptyThemeList);
    }

    private void addRangeElement(Element themeStyle, boolean useRange) {
        Element useRangeElement = new Element(THEME_USE_RANGE, themeStyle.getNamespace());
        useRangeElement.setText(BooleanUtils.toStringTrueFalse((boolean)useRange));
        themeStyle.addContent((Content)useRangeElement);
    }

    @Override
    public boolean supportsUnconvert() {
        return true;
    }

    @Override
    public int oldVersionNumber() {
        return 19;
    }

    @Override
    public int newVersionNumber() {
        return 20;
    }

    @Override
    public String oldVersionName() {
        return this.oldVersionNumber() + " Client 2.7.x";
    }

    private boolean isWmtsStyle(Element elem) {
        return elem.getName().equals("wmtsStyle");
    }

    private boolean isFeatureStore(Element elem) {
        return elem.getName().equals("fmd");
    }

    private boolean isThemingStyle(Element elem) {
        return elem.getName().equals("themingStyle");
    }

    private void removeUselessFormatters(Element elem) {
        Namespace ns = elem.getNamespace();
        elem.removeChild("filterTime", ns);
        elem.removeChild("filterDate", ns);
    }
}

