/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.version;

import de.riwagis.riwajump.model.version.AbstractVersionConverter;
import de.riwagis.riwajump.model.version.VConv_Prj_V16_V17;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.filter.Filters;
import org.jdom2.util.IteratorIterable;

public class VConv_Prj_V17_V18
extends AbstractVersionConverter {
    private static final String OLD_JTS_PACKAGE = "com.vividsolutions.jts.";
    private static final String NEW_JTS_PACKAGE = "org.locationtech.jts.";
    private static final String OLD_JTS_ENVELOPE = "com.vividsolutions.jts.geom.Envelope";
    private static final String NEW_JTS_ENVELOPE = "org.locationtech.jts.geom.Envelope";
    private static final String URL_PARAMETER = "url";
    private static final String TAG_PARAMETER = "params";
    private static final String FMD_ALLOW_GRAPHIC_DRAFTS = "allowGraphicDrafts";
    private static final String GK4_BAYERN = "99999001";
    private static final String GK3_BW = "99999002";
    private static final String GK4 = "31468";
    private static final String GK3 = "31467";
    private Filter<Element> colorFilter;

    @Override
    public boolean needsConversion(Document doc) {
        int intPrjVersion = AbstractVersionConverter.getProjectVersion(doc);
        return intPrjVersion < 18;
    }

    @Override
    public void convert(Document doc) {
        final Namespace ns = doc.getRootElement().getNamespace();
        this.colorFilter = new ElementFilter(ns){

            public Element filter(Object content) {
                Element candidate;
                if (super.filter(content) != null && !(candidate = (Element)content).getName().equals("colorOpaque") && candidate.getChild("red", ns) != null && candidate.getChild("green") != null && candidate.getChild("blue") != null && candidate.getChild("alpha") != null) {
                    return candidate;
                }
                return null;
            }
        };
        this.convertElement(doc.getRootElement());
    }

    static boolean isBasicStyle(Element elem) {
        return elem.getName().equals("basicStyle") || elem.getName().equals("redlineBasicStyle") || elem.getName().equals("defaultStyle") && elem.getParentElement().getName().equals("themingStyle") || elem.getName().equals("style") && elem.getParentElement().getName().equals("theme");
    }

    static boolean isJavaClassReference(Element elem) {
        return elem.getName().equals("java-class") && elem.getParentElement().getName().equals("geomTypes");
    }

    static boolean isSymbolStore(Element elem) {
        return elem.getName().equals("smd");
    }

    static boolean isFeatureStore(Element elem) {
        return elem.getName().equals("fmd");
    }

    static boolean isEnvelope(Element elem) {
        return elem.getName().equals(OLD_JTS_ENVELOPE) || elem.getName().equals(NEW_JTS_ENVELOPE);
    }

    static boolean isBlackBoard(Element elem) {
        return elem.getName().equals("bb");
    }

    private void convertElement(Element elem) {
        block12: {
            Element elemProperties;
            block15: {
                Element crsToChild;
                block16: {
                    block14: {
                        block13: {
                            block11: {
                                if (VConv_Prj_V17_V18.isBasicStyle(elem)) {
                                    String featureColor;
                                    String useFeatureColor = elem.getChildTextTrim("bolUseFeatColor", elem.getNamespace());
                                    if (StringUtils.equals((CharSequence)useFeatureColor, (CharSequence)"true") && StringUtils.isNotBlank((CharSequence)(featureColor = elem.getChildTextTrim("strFeatColor", elem.getNamespace())))) {
                                        IteratorIterable colorElemsIter = elem.getDescendants(this.colorFilter);
                                        List colorElems = IteratorUtils.toList((Iterator)colorElemsIter);
                                        for (Element colorElem : colorElems) {
                                            Element bshElem = new Element("bsh", elem.getNamespace());
                                            bshElem.setText(featureColor);
                                            colorElem.addContent((Content)bshElem);
                                        }
                                    }
                                    elem.removeContent(Filters.element((String)"bolUseFeatColor", (Namespace)elem.getNamespace()));
                                    elem.removeContent(Filters.element((String)"strFeatColor", (Namespace)elem.getNamespace()));
                                    return;
                                }
                                if (!VConv_Prj_V17_V18.isJavaClassReference(elem)) break block11;
                                elem.setText(elem.getText().replace(OLD_JTS_PACKAGE, NEW_JTS_PACKAGE));
                                break block12;
                            }
                            if (!VConv_Prj_V17_V18.isEnvelope(elem)) break block13;
                            elem.setName(NEW_JTS_ENVELOPE);
                            break block12;
                        }
                        if (!VConv_Prj_V17_V18.isSymbolStore(elem)) break block14;
                        String url = elem.getChild(URL_PARAMETER).getText();
                        Element params = new Element(TAG_PARAMETER);
                        elem.addContent((Content)params);
                        elem.removeChild(URL_PARAMETER);
                        VConv_Prj_V16_V17.addParamEntry(params, URL_PARAMETER, url, "string");
                        break block12;
                    }
                    if (!VConv_Prj_V17_V18.isFeatureStore(elem)) break block15;
                    Element crsFromChild = elem.getChild("crsFrom");
                    crsToChild = elem.getChild("crsTo");
                    if (StringUtils.equals((CharSequence)crsFromChild.getText(), (CharSequence)GK4_BAYERN)) {
                        crsFromChild.setText(GK4);
                    } else if (StringUtils.equals((CharSequence)crsFromChild.getText(), (CharSequence)GK3_BW)) {
                        crsFromChild.setText(GK3);
                    }
                    if (!StringUtils.equals((CharSequence)crsToChild.getText(), (CharSequence)GK4_BAYERN)) break block16;
                    crsToChild.setText(GK4);
                    break block12;
                }
                if (!StringUtils.equals((CharSequence)crsToChild.getText(), (CharSequence)GK3_BW)) break block12;
                crsToChild.setText(GK3);
                break block12;
            }
            if (VConv_Prj_V17_V18.isBlackBoard(elem) && (elemProperties = elem.getChild("properties")) != null) {
                List entries = elemProperties.getChildren("entry");
                block1: for (Element entry : entries) {
                    for (Element child : entry.getChildren()) {
                        if (StringUtils.equals((CharSequence)child.getValue(), (CharSequence)GK4_BAYERN)) {
                            child.setText(GK4);
                            continue block1;
                        }
                        if (!StringUtils.equals((CharSequence)child.getValue(), (CharSequence)GK3_BW)) continue;
                        child.setText(GK3);
                        continue block1;
                    }
                }
            }
        }
        List lstChilds = elem.getChildren();
        for (Element currElem : lstChilds) {
            this.convertElement(currElem);
        }
    }

    @Override
    public void unconvert(Document doc) {
        final Namespace ns = doc.getRootElement().getNamespace();
        this.colorFilter = new ElementFilter(ns){

            public Element filter(Object content) {
                Element candidate;
                if (super.filter(content) != null && !(candidate = (Element)content).getName().equals("colorOpaque") && candidate.getChild("red", ns) != null && candidate.getChild("green") != null && candidate.getChild("blue") != null && candidate.getChild("alpha") != null) {
                    return candidate;
                }
                return null;
            }
        };
        this.unconvertElement(doc.getRootElement());
    }

    private void unconvertElement(Element elem) {
        if (VConv_Prj_V17_V18.isBasicStyle(elem)) {
            Namespace ns = elem.getNamespace();
            Element useFeatColor = new Element("bolUseFeatColor", ns);
            useFeatColor.setText("false");
            elem.addContent((Content)useFeatColor);
            boolean isColorConvertable = true;
            String featColor = null;
            IteratorIterable colorElemsIter = elem.getDescendants(this.colorFilter);
            List colorElems = IteratorUtils.toList((Iterator)colorElemsIter);
            for (Element colorElem : colorElems) {
                Element bshChild = colorElem.getChild("bsh", elem.getNamespace());
                if (bshChild == null) {
                    isColorConvertable = false;
                    continue;
                }
                if (featColor == null) {
                    featColor = bshChild.getTextTrim();
                } else if (!featColor.equals(bshChild.getTextTrim())) {
                    isColorConvertable = false;
                }
                colorElem.removeChild(bshChild.getName(), elem.getNamespace());
            }
            if (featColor != null && isColorConvertable) {
                elem.getChild("bolUseFeatColor", ns).setText("true");
                Element strFeatColor = new Element("strFeatColor", ns);
                strFeatColor.setText(featColor);
                elem.addContent((Content)strFeatColor);
            }
            IteratorIterable it = elem.getDescendants((Filter)new ElementFilter(ns){

                public Element filter(Object content) {
                    Element candidate;
                    if (super.filter(content) != null && (candidate = (Element)content).getName().equals("bsh")) {
                        return candidate;
                    }
                    return null;
                }
            });
            while (it.hasNext()) {
                Element e = (Element)it.next();
                it.remove();
            }
            return;
        }
        if (VConv_Prj_V17_V18.isJavaClassReference(elem)) {
            elem.setText(elem.getText().replace(NEW_JTS_PACKAGE, OLD_JTS_PACKAGE));
        } else if (VConv_Prj_V17_V18.isEnvelope(elem)) {
            elem.setName(OLD_JTS_ENVELOPE);
        } else if (VConv_Prj_V17_V18.isSymbolStore(elem)) {
            Element params = elem.getChild(TAG_PARAMETER);
            String url = "";
            for (Element entry : params.getChildren("entry")) {
                List kv = entry.getChildren();
                if (kv.size() != 2 || !URL_PARAMETER.equals(((Element)kv.get(0)).getText())) continue;
                url = ((Element)kv.get(1)).getText();
            }
            Element urlTag = new Element(URL_PARAMETER);
            urlTag.setText(url);
            elem.removeChild(TAG_PARAMETER);
            elem.addContent((Content)urlTag);
        } else if (VConv_Prj_V17_V18.isFeatureStore(elem)) {
            elem.removeChild(FMD_ALLOW_GRAPHIC_DRAFTS);
        }
        List lstChilds = elem.getChildren();
        for (Element currElem : lstChilds) {
            this.unconvertElement(currElem);
        }
    }

    @Override
    public boolean supportsUnconvert() {
        return true;
    }

    @Override
    public int oldVersionNumber() {
        return 17;
    }

    @Override
    public int newVersionNumber() {
        return 18;
    }

    @Override
    public String oldVersionName() {
        return this.oldVersionNumber() + " Client 2.3.x - 2.4.x";
    }
}

