/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.version;

import de.riwagis.riwajump.model.version.AbstractVersionConverter;
import de.riwagis.riwajump.model.version.VersionConverterUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class VConv_Prj_V16_V17
extends AbstractVersionConverter {
    @Override
    public boolean needsConversion(Document doc) throws IOException {
        int intPrjVersion = AbstractVersionConverter.getProjectVersion(doc);
        return intPrjVersion < 17;
    }

    @Override
    public void convert(Document doc) {
        this.convertElement(doc.getRootElement());
    }

    private void convertElement(Element elem) {
        String elemName = elem.getName();
        if (VersionConverterUtils.isOneOf(elemName, "themingStyle")) {
            elem.addContent((Content)VersionConverterUtils.createTextElement("useElseFilter", "true"));
        }
        if (StringUtils.equals((CharSequence)elemName, (CharSequence)"dmd") && elem.getChild("datname").getText().equals("SpatiaLite")) {
            Element paramsEntry = elem.getChild("params");
            List entries = paramsEntry.getChildren("entry");
            for (Element entry : entries) {
                List stringEntries = entry.getChildren("string");
                if (stringEntries.size() != 2 || !StringUtils.equals((CharSequence)((Element)stringEntries.get(0)).getText(), (CharSequence)"spatialite_lib") || !StringUtils.equals((CharSequence)((Element)stringEntries.get(1)).getText(), (CharSequence)"libspatialite")) continue;
                ((Element)stringEntries.get(1)).setText("mod_spatialite");
            }
            Element entryElement = new Element("entry");
            Element keyElement = new Element("string");
            keyElement.setText("version");
            entryElement.addContent((Content)keyElement);
            Element valueElement = new Element("int");
            valueElement.setText("4");
            entryElement.addContent((Content)valueElement);
            paramsEntry.addContent((Content)entryElement);
            return;
        }
        if (StringUtils.equals((CharSequence)elemName, (CharSequence)"dmd") && elem.getChild("datname").getText().equals("MySQL")) {
            Element paramsEntry = elem.getChild("params");
            List entries = paramsEntry.getChildren("entry");
            HashMap<String, String> dmdParams = new HashMap<String, String>();
            for (Element entry : entries) {
                List lstChildren = entry.getChildren();
                if (lstChildren.size() != 2) continue;
                dmdParams.put(((Element)lstChildren.get(0)).getText(), ((Element)lstChildren.get(1)).getText());
            }
            elem.getChild("datname").setText("RiwaDataTable");
            elem.removeChild("params");
            Element newParams = new Element("params");
            elem.addContent((Content)newParams);
            VConv_Prj_V16_V17.addParamEntry(newParams, "dbtype", "DB_MySql", "string");
            VConv_Prj_V16_V17.addParamEntry(newParams, "host", (String)dmdParams.get("host"), "string");
            VConv_Prj_V16_V17.addParamEntry(newParams, "database", (String)dmdParams.get("database"), "string");
            VConv_Prj_V16_V17.addParamEntry(newParams, "schema", (String)dmdParams.get("database"), "string");
            VConv_Prj_V16_V17.addParamEntry(newParams, "port", (String)dmdParams.get("port"), "int");
            VConv_Prj_V16_V17.addParamEntry(newParams, "user", (String)dmdParams.get("user"), "string");
            VConv_Prj_V16_V17.addParamEntry(newParams, "passwd", (String)dmdParams.get("passwd"), "string");
            VConv_Prj_V16_V17.addParamEntry(newParams, "Evictor run periodicity", "300", "int");
            VConv_Prj_V16_V17.addParamEntry(newParams, "validate connections", (String)dmdParams.get("validate connections"), "boolean");
            VConv_Prj_V16_V17.addParamEntry(newParams, "Connection timeout", "20", "int");
            VConv_Prj_V16_V17.addParamEntry(newParams, "lowercase_when_oracle", "false", "boolean");
            VConv_Prj_V16_V17.addParamEntry(newParams, "srid", "31468", "int");
            VConv_Prj_V16_V17.addParamEntry(newParams, "min connections", (String)dmdParams.get("min connections"), "int");
            VConv_Prj_V16_V17.addParamEntry(newParams, "max connections", (String)dmdParams.get("max connections"), "int");
            VConv_Prj_V16_V17.addParamEntry(newParams, "Max connection idle time", "300", "int");
            VConv_Prj_V16_V17.addParamEntry(newParams, "Evictor tests per run", "3", "int");
            VConv_Prj_V16_V17.addParamEntry(newParams, "Test while idle", "true", "boolean");
            return;
        }
        if (StringUtils.equals((CharSequence)elemName, (CharSequence)"dmd") && elem.getChild("datname").getText().equals("Oracle")) {
            Element paramsEntry = elem.getChild("params");
            List entries = paramsEntry.getChildren("entry");
            HashMap<String, String> dmdParams = new HashMap<String, String>();
            for (Element entry : entries) {
                List lstChildren = entry.getChildren();
                if (lstChildren.size() != 2) continue;
                dmdParams.put(((Element)lstChildren.get(0)).getText(), ((Element)lstChildren.get(1)).getText());
            }
            elem.getChild("datname").setText("RiwaDataTable");
            elem.removeChild("params");
            Element newParams = new Element("params");
            elem.addContent((Content)newParams);
            VConv_Prj_V16_V17.addParamEntry(newParams, "dbtype", "DB_Oracle", "string");
            VConv_Prj_V16_V17.addParamEntry(newParams, "host", (String)dmdParams.get("host"), "string");
            VConv_Prj_V16_V17.addParamEntry(newParams, "database", (String)dmdParams.get("instance"), "string");
            VConv_Prj_V16_V17.addParamEntry(newParams, "schema", (String)dmdParams.get("schema"), "string");
            VConv_Prj_V16_V17.addParamEntry(newParams, "port", (String)dmdParams.get("port"), "int");
            VConv_Prj_V16_V17.addParamEntry(newParams, "user", (String)dmdParams.get("user"), "string");
            VConv_Prj_V16_V17.addParamEntry(newParams, "passwd", (String)dmdParams.get("passwd"), "string");
            VConv_Prj_V16_V17.addParamEntry(newParams, "Evictor run periodicity", "300", "int");
            VConv_Prj_V16_V17.addParamEntry(newParams, "validate connections", (String)dmdParams.get("validate connections"), "boolean");
            VConv_Prj_V16_V17.addParamEntry(newParams, "Connection timeout", "20", "int");
            VConv_Prj_V16_V17.addParamEntry(newParams, "lowercase_when_oracle", "false", "boolean");
            VConv_Prj_V16_V17.addParamEntry(newParams, "srid", "31468", "int");
            VConv_Prj_V16_V17.addParamEntry(newParams, "min connections", (String)dmdParams.get("min connections"), "int");
            VConv_Prj_V16_V17.addParamEntry(newParams, "max connections", (String)dmdParams.get("max connections"), "int");
            VConv_Prj_V16_V17.addParamEntry(newParams, "Max connection idle time", "300", "int");
            VConv_Prj_V16_V17.addParamEntry(newParams, "Evictor tests per run", "3", "int");
            VConv_Prj_V16_V17.addParamEntry(newParams, "Test while idle", "true", "boolean");
            return;
        }
        if (elemName.equals("layer")) {
            elem.addContent((Content)VersionConverterUtils.createTextElement("labelLayerKey", null));
        }
        if (VersionConverterUtils.isOneOf(elemName, "labelLayer")) {
            elem.addContent((Content)VersionConverterUtils.createTextElement("exportable", "true"));
        }
        if (VersionConverterUtils.isOneOf(elemName, "wmsStyle")) {
            elem.addContent((Content)VersionConverterUtils.createTextElement("ignoreFeatureInfo", "false"));
        }
        List lstChilds = elem.getChildren();
        for (Element currElem : lstChilds) {
            this.convertElement(currElem);
        }
    }

    public static void addParamEntry(Element newParams, String key, String value, String type) {
        Element elemEntry = new Element("entry");
        newParams.addContent((Content)elemEntry);
        Element elemKey = new Element("string");
        elemKey.setText(key);
        elemEntry.addContent((Content)elemKey);
        if (value == null) {
            Element elemValue = new Element("null");
            elemEntry.addContent((Content)elemValue);
        } else if (StringUtils.isBlank((CharSequence)value) && (StringUtils.equals((CharSequence)type, (CharSequence)"int") || StringUtils.equals((CharSequence)type, (CharSequence)"boolean"))) {
            Element elemValue = new Element("null");
            elemEntry.addContent((Content)elemValue);
        } else {
            Element elemValue = new Element(type);
            elemValue.setText(value);
            elemEntry.addContent((Content)elemValue);
        }
    }

    @Override
    public void unconvert(Document doc) {
        this.unconvertElement(doc.getRootElement());
    }

    private void unconvertElement(Element elem) {
        Element elemProperties;
        Object entries;
        String elemName = elem.getName();
        if (elemName.equals("fmd")) {
            elem.removeChild("key__att__view", elem.getNamespace());
            elem.removeChild("textTransInOri", elem.getNamespace());
        }
        if (elemName.equals("themingStyle")) {
            elem.removeChild("useElseFilter", elem.getNamespace());
        }
        if (StringUtils.equals((CharSequence)elemName, (CharSequence)"dmd") && elem.getChild("datname").getText().equals("RiwaDataTable")) {
            Element newParams;
            Element paramsEntry = elem.getChild("params");
            entries = paramsEntry.getChildren("entry");
            HashMap<String, String> dmdParams = new HashMap<String, String>();
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Element entry = (Element)iterator.next();
                List lstChildren = entry.getChildren();
                if (lstChildren.size() != 2) continue;
                dmdParams.put(((Element)lstChildren.get(0)).getText(), ((Element)lstChildren.get(1)).getText());
            }
            if (((String)dmdParams.get("dbtype")).equalsIgnoreCase("DB_MySql")) {
                elem.getChild("datname").setText("MySQL");
                elem.removeChild("params");
                newParams = new Element("params");
                elem.addContent((Content)newParams);
                VConv_Prj_V16_V17.addParamEntry(newParams, "dbtype", "mysql", "string");
                VConv_Prj_V16_V17.addParamEntry(newParams, "host", (String)dmdParams.get("host"), "string");
                VConv_Prj_V16_V17.addParamEntry(newParams, "database", (String)dmdParams.get("database"), "string");
                VConv_Prj_V16_V17.addParamEntry(newParams, "port", (String)dmdParams.get("port"), "int");
                VConv_Prj_V16_V17.addParamEntry(newParams, "user", (String)dmdParams.get("user"), "string");
                VConv_Prj_V16_V17.addParamEntry(newParams, "passwd", (String)dmdParams.get("passwd"), "string");
                VConv_Prj_V16_V17.addParamEntry(newParams, "validate connections", (String)dmdParams.get("validate connections"), "boolean");
                VConv_Prj_V16_V17.addParamEntry(newParams, "min connections", (String)dmdParams.get("min connections"), "int");
                VConv_Prj_V16_V17.addParamEntry(newParams, "max connections", (String)dmdParams.get("max connections"), "int");
                VConv_Prj_V16_V17.addParamEntry(newParams, "namespace", null, "string");
            }
            if (((String)dmdParams.get("dbtype")).equalsIgnoreCase("DB_Oracle")) {
                elem.getChild("datname").setText("Oracle");
                elem.removeChild("params");
                newParams = new Element("params");
                elem.addContent((Content)newParams);
                VConv_Prj_V16_V17.addParamEntry(newParams, "dbtype", "oracle", "string");
                VConv_Prj_V16_V17.addParamEntry(newParams, "host", (String)dmdParams.get("host"), "string");
                VConv_Prj_V16_V17.addParamEntry(newParams, "instance", (String)dmdParams.get("database"), "string");
                VConv_Prj_V16_V17.addParamEntry(newParams, "schema", (String)dmdParams.get("schema"), "string");
                VConv_Prj_V16_V17.addParamEntry(newParams, "port", (String)dmdParams.get("port"), "int");
                VConv_Prj_V16_V17.addParamEntry(newParams, "user", (String)dmdParams.get("user"), "string");
                VConv_Prj_V16_V17.addParamEntry(newParams, "passwd", (String)dmdParams.get("passwd"), "string");
                VConv_Prj_V16_V17.addParamEntry(newParams, "validate connections", (String)dmdParams.get("validate connections"), "boolean");
                VConv_Prj_V16_V17.addParamEntry(newParams, "min connections", (String)dmdParams.get("min connections"), "int");
                VConv_Prj_V16_V17.addParamEntry(newParams, "max connections", (String)dmdParams.get("max connections"), "int");
                VConv_Prj_V16_V17.addParamEntry(newParams, "namespace", null, "string");
            }
        }
        if (StringUtils.equals((CharSequence)elemName, (CharSequence)"dmd") && elem.getChild("datname").getText().equals("SpatiaLite")) {
            List entries2 = elem.getChild("params").getChildren("entry");
            for (Object entry : entries2) {
                List stringEntries = entry.getChildren("string");
                if (stringEntries.size() != 2 || !StringUtils.equals((CharSequence)((Element)stringEntries.get(0)).getText(), (CharSequence)"spatialite_lib") || !StringUtils.equals((CharSequence)((Element)stringEntries.get(1)).getText(), (CharSequence)"mod_spatialite")) continue;
                ((Element)stringEntries.get(1)).setText("libspatialite");
            }
        }
        if (elemName.equals("layer") || elemName.equals("labelLayer")) {
            elem.removeChild("labelLayerKey", elem.getNamespace());
        }
        if (elemName.equals("labelLayer")) {
            elem.setName("layer");
            elem.removeChild("labelTextEditable", elem.getNamespace());
        }
        if (elemName.equals("wmsStyle")) {
            elem.removeChild("ignoreFeatureInfo", elem.getNamespace());
            if (elem.getChild("strVersion").getText().equals("1.0.0")) {
                elem.getChild("strVersion").setText("1.1.0");
            }
        }
        if (elemName.equals("layerables")) {
            elem.removeChildren("wmtsLayer", elem.getNamespace());
        }
        if (elemName.equals("bb") && (elemProperties = elem.getChild("properties")) != null) {
            Object entry;
            entries = elemProperties.getChildren("entry");
            entry = entries.iterator();
            while (entry.hasNext()) {
                Element entry2 = (Element)entry.next();
                if (!StringUtils.equals((CharSequence)entry2.getChildText("string"), (CharSequence)"DEM")) continue;
                elemProperties.removeContent((Content)entry2);
                break;
            }
        }
        List lstChilds = elem.getChildren();
        for (Element currElem : lstChilds) {
            this.unconvertElement(currElem);
        }
    }

    @Override
    public boolean supportsUnconvert() {
        return true;
    }

    @Override
    public int oldVersionNumber() {
        return 16;
    }

    @Override
    public int newVersionNumber() {
        return 17;
    }

    @Override
    public String oldVersionName() {
        return this.oldVersionNumber() + " Client 2.2.x";
    }
}

