/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.version;

import de.riwagis.riwajump.model.version.AbstractVersionConverter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class VConv_Prj_V14_V15
extends AbstractVersionConverter {
    @Override
    public boolean needsConversion(Document doc) throws IOException {
        int intPrjVersion = AbstractVersionConverter.getProjectVersion(doc);
        return intPrjVersion < 15;
    }

    @Override
    public void convert(Document doc) {
        this.convertElement(doc.getRootElement());
    }

    private void convertElement(Element elem) {
        Namespace ns;
        Element elemSCol;
        if (elem.getName().equals("redlineLayer") && (elemSCol = elem.getChild("lstStyleCollections", ns = elem.getNamespace())) != null) {
            elemSCol.removeChild("layerSCol", ns);
        }
        if (elem.getName().equals("fontText") || elem.getName().equals("fontDimText")) {
            String family = null;
            String posture = null;
            String weight = null;
            Namespace ns2 = elem.getNamespace();
            Element atts = elem.getChild("attributes", ns2);
            if (atts != null) {
                List entryList = atts.getChildren("entry", ns2);
                for (Element entry : entryList) {
                    String awtAttrText = entry.getChildText("awt-text-attribute", ns2);
                    if ("family".equals(awtAttrText)) {
                        family = entry.getChildText("string", ns2);
                        continue;
                    }
                    if ("posture".equals(awtAttrText)) {
                        posture = entry.getChildText("float", ns2);
                        continue;
                    }
                    if (!"weight".equals(awtAttrText)) continue;
                    weight = entry.getChildText("float", ns2);
                }
            }
            String name = family != null ? family : "";
            int size = 10;
            int style = 0;
            boolean bold = "2.0".equals(weight);
            boolean italic = "0.2".equals(posture);
            if (bold && italic) {
                style = 3;
            } else if (bold) {
                style = 1;
            } else if (italic) {
                style = 2;
            }
            elem.removeContent();
            Element elName = new Element("name", ns2);
            elName.setText(name);
            elem.addContent((Content)elName);
            Element elStyle = new Element("style", ns2);
            elStyle.setText(String.valueOf(style));
            elem.addContent((Content)elStyle);
            Element elSize = new Element("size", ns2);
            elSize.setText(String.valueOf(size));
            elem.addContent((Content)elSize);
        }
        if (elem.getName().equals("de.riwagis.geotools.search.model.ListInput")) {
            elem.setName("listinput");
        }
        if (elem.getName().equals("de.riwagis.geotools.search.model.FieldInput")) {
            elem.setName("fieldinput");
        }
        List lstChilds = elem.getChildren();
        Iterator i = lstChilds.iterator();
        while (i.hasNext()) {
            this.convertElement((Element)i.next());
        }
    }

    @Override
    public void unconvert(Document doc) {
        this.unconvertElement(doc.getRootElement());
    }

    private void unconvertElement(Element elem) {
        Namespace ns;
        Element elemSCol;
        if (elem.getName().equals("redlineLayer") && (elemSCol = elem.getChild("lstStyleCollections", ns = elem.getNamespace())) != null) {
            Element elemLayerSCol = new Element("layerSCol", ns);
            elemSCol.addContent((Content)elemLayerSCol);
            Element elemBolDefault = new Element("bolDefault", ns);
            elemBolDefault.setText("true");
            elemLayerSCol.addContent((Content)elemBolDefault);
            Element elemStyles = new Element("lstStyles", ns);
            elemLayerSCol.addContent((Content)elemStyles);
        }
        if (elem.getName().equals("fontText") || elem.getName().equals("fontDimText")) {
            Element elemNull;
            String[] notRestorable;
            Element elName = elem.getChild("name");
            String textName = elName.getText();
            Element elStyle = elem.getChild("style");
            String oldTextStyle = elStyle.getText();
            elem.removeContent();
            Namespace namsp = elem.getNamespace();
            Element elemAttributes = new Element("attributes", namsp);
            elem.addContent((Content)elemAttributes);
            String nameEntry = "entry";
            String nameAwtTextAttr = "awt-text-attribute";
            String nameNull = "null";
            for (String notRestorableAttribText : notRestorable = new String[]{"width", "superscript", "size", "tracking", "transform"}) {
                Element elemEntry = new Element("entry", namsp);
                Element elemAwt2 = new Element("awt-text-attribute", namsp);
                elemAwt2.setText(notRestorableAttribText);
                elemEntry.addContent((Content)elemAwt2);
                elemNull = new Element("null", namsp);
                elemEntry.addContent((Content)elemNull);
                elemAttributes.addContent((Content)elemEntry);
            }
            Element elemEntry = new Element("entry", namsp);
            Element elemAwt = new Element("awt-text-attribute", namsp);
            elemAwt.setText("family");
            elemEntry.addContent((Content)elemAwt);
            if (textName != null && textName.length() > 0) {
                Element elemString = new Element("string", namsp);
                elemString.setText(textName);
                elemEntry.addContent((Content)elemString);
            } else {
                Element elemNull2 = new Element("null", namsp);
                elemEntry.addContent((Content)elemNull2);
            }
            elemAttributes.addContent((Content)elemEntry);
            String textPosture = null;
            String textWeight = null;
            int oldStyle = -1;
            if (oldTextStyle != null && oldTextStyle.length() > 0) {
                try {
                    oldStyle = Integer.parseInt(oldTextStyle);
                }
                catch (NumberFormatException elemAwt2) {
                    // empty catch block
                }
            }
            if (oldStyle == 1) {
                textWeight = "2.0";
            } else if (oldStyle == 3) {
                textWeight = "2.0";
                textPosture = "0.2";
            } else if (oldStyle == 2) {
                textPosture = "0.2";
            }
            Element elemPostureEntry = new Element("entry", namsp);
            elemAwt = new Element("awt-text-attribute", namsp);
            elemAwt.setText("posture");
            elemPostureEntry.addContent((Content)elemAwt);
            if (textPosture == null) {
                elemNull = new Element("null", namsp);
                elemPostureEntry.addContent((Content)elemNull);
            } else {
                Element elemFloat = new Element("float", namsp);
                elemFloat.setText(textPosture);
                elemPostureEntry.addContent((Content)elemFloat);
            }
            elemAttributes.addContent((Content)elemPostureEntry);
            Element elemWeightEntry = new Element("entry", namsp);
            elemAwt = new Element("awt-text-attribute", namsp);
            elemAwt.setText("weight");
            elemWeightEntry.addContent((Content)elemAwt);
            if (textWeight == null) {
                Element elemNull3 = new Element("null", namsp);
                elemWeightEntry.addContent((Content)elemNull3);
            } else {
                Element elemFloat = new Element("float", namsp);
                elemFloat.setText(textWeight);
                elemWeightEntry.addContent((Content)elemFloat);
            }
            elemAttributes.addContent((Content)elemWeightEntry);
        }
        if (elem.getName().equals("listinput")) {
            elem.setName("de.riwagis.geotools.search.model.ListInput");
        }
        if (elem.getName().equals("fieldinput")) {
            elem.setName("de.riwagis.geotools.search.model.FieldInput");
        }
        List lstChilds = elem.getChildren();
        Iterator i = lstChilds.iterator();
        while (i.hasNext()) {
            this.unconvertElement((Element)i.next());
        }
    }

    @Override
    public boolean supportsUnconvert() {
        return true;
    }

    @Override
    public int oldVersionNumber() {
        return 14;
    }

    @Override
    public int newVersionNumber() {
        return 15;
    }

    @Override
    public String oldVersionName() {
        return this.oldVersionNumber() + " Client 2.0.9, 2.1.0";
    }
}

