/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.version;

import de.riwagis.riwajump.model.version.AbstractVersionConverter;
import de.riwagis.util.StringSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VConv_Prj_V12_V13
extends AbstractVersionConverter {
    private static final Logger LOG = LoggerFactory.getLogger(VConv_Prj_V12_V13.class);
    public static final int LEFT_TOP = 1;
    public static final int CENTER_TOP = 2;
    public static final int RIGHT_TOP = 3;
    public static final int LEFT_CENTER = 4;
    public static final int CENTER_CENTER = 5;
    public static final int RIGHT_CENTER = 6;
    public static final int LEFT_BOTTOM = 7;
    public static final int CENTER_BOTTOM = 8;
    public static final int RIGHT_BOTTOM = 9;

    @Override
    public boolean needsConversion(Document doc) throws IOException {
        int intPrjVersion = AbstractVersionConverter.getProjectVersion(doc);
        return intPrjVersion < 13;
    }

    @Override
    public void convert(Document doc) {
        this.convertElement(doc.getRootElement());
    }

    private void convertElement(Element elem) {
        elem.removeChildren("rasterLayer", elem.getNamespace());
        if (elem.getName().equals("themingStyle")) {
            Namespace ns = elem.getNamespace();
            String strUseRange = elem.getChildTextTrim("useRange", elem.getNamespace());
            boolean bolUseRange = Boolean.parseBoolean(strUseRange);
            Element elemBS = elem.getChild("attributeValueToBasicStyleMap", elem.getNamespace());
            Element elemLbl = elem.getChild("attributeValueToLabelMap", elem.getNamespace());
            Element elemThemes = bolUseRange ? this.getThemes4Range(elemBS, elemLbl) : this.getThemes4SingleValue(elemBS, elemLbl);
            elem.removeChild("attributeValueToBasicStyleMap", ns);
            elem.removeChild("attributeValueToLabelMap", ns);
            elem.addContent((Content)elemThemes);
        }
        if (elem.getName().equals("textStyle") || elem.getName().equals("txtStyle") || elem.getName().equals("tooltipStyle")) {
            Element eIP = elem.getChild("intInsertPoint", elem.getNamespace());
            Element eIL = elem.getChild("intInsertLine", elem.getNamespace());
            Element eIA = elem.getChild("intInsertArea", elem.getNamespace());
            Element eAP = new Element("alignPoint", elem.getNamespace());
            Element eAL = new Element("alignLine", elem.getNamespace());
            Element eAA = new Element("alignArea", elem.getNamespace());
            eAP.setText(eIP.getText());
            eAL.setText(eIL.getText());
            eAA.setText(eIA.getText());
            elem.removeChild("intInsertPoint", elem.getNamespace());
            elem.removeChild("intInsertLine", elem.getNamespace());
            elem.removeChild("intInsertArea", elem.getNamespace());
            elem.addContent((Content)eAP);
            elem.addContent((Content)eAL);
            elem.addContent((Content)eAA);
        }
        List lstChilds = elem.getChildren();
        Iterator i = lstChilds.iterator();
        while (i.hasNext()) {
            this.convertElement((Element)i.next());
        }
    }

    @Override
    public void unconvert(Document doc) {
        this.unconvertElement(doc.getRootElement());
    }

    private void unconvertElement(Element elem) {
        elem.removeChildren("rasterLayer", elem.getNamespace());
        if (elem.getName().equals("wmsStyle")) {
            elem.removeChild("hideWmsLayers", elem.getNamespace());
            return;
        }
        if (elem.getName().equals("fmd")) {
            elem.removeChild("order_att", elem.getNamespace());
            return;
        }
        if (elem.getName().equals("themingStyle")) {
            Namespace ns = elem.getNamespace();
            String strUseRange = elem.getChildTextTrim("useRange", elem.getNamespace());
            boolean bolUseRange = Boolean.parseBoolean(strUseRange);
            Element elemThemes = elem.getChild("themes", ns);
            ArrayList lstThemes = new ArrayList(elemThemes.getChildren());
            elem.removeContent((Content)elemThemes);
            Element elemBS = new Element("attributeValueToBasicStyleMap", ns);
            Element elemLbl = new Element("attributeValueToLabelMap", ns);
            if (bolUseRange) {
                elemBS.setAttribute("class", "com.vividsolutions.jump.util.Range$RangeTreeMap", ns);
                elemBS.setAttribute("serialization", "custom", ns);
                elemLbl.setAttribute("class", "com.vividsolutions.jump.util.Range$RangeTreeMap", ns);
                elemLbl.setAttribute("serialization", "custom", ns);
                elemBS.addContent((Content)new Element("unserializable-parents", ns));
                elemLbl.addContent((Content)new Element("unserializable-parents", ns));
                Element elemBSTreeMap = new Element("tree-map", ns);
                elemBS.addContent((Content)elemBSTreeMap);
                Element elemBSTMDefault = new Element("default", ns);
                elemBSTreeMap.addContent((Content)elemBSTMDefault);
                Element elemBSTMDefaultComp = new Element("comparator", ns);
                elemBSTMDefaultComp.setAttribute("class", "com.vividsolutions.jump.util.Range$2");
                elemBSTMDefault.addContent((Content)elemBSTMDefaultComp);
                Element elemBSTreeMapInt = new Element("int", ns);
                elemBSTreeMapInt.setText("" + lstThemes.size());
                elemBSTreeMap.addContent((Content)elemBSTreeMapInt);
                Element elemLblTreeMap = new Element("tree-map", ns);
                elemLbl.addContent((Content)elemLblTreeMap);
                Element elemLblTMDefault = new Element("default", ns);
                elemLblTreeMap.addContent((Content)elemLblTMDefault);
                Element elemLblTMDefaultComp = new Element("comparator", ns);
                elemLblTMDefaultComp.setAttribute("class", "com.vividsolutions.jump.util.Range$2");
                elemLblTMDefault.addContent((Content)elemLblTMDefaultComp);
                Element elemLblTreeMapInt = new Element("int", ns);
                elemLblTreeMapInt.setText("" + lstThemes.size());
                elemLblTreeMap.addContent((Content)elemLblTreeMapInt);
                for (Element elemTheme : lstThemes) {
                    Element elemRange = elemTheme.getChild("key", ns);
                    this.unconvertRange(elemRange);
                    elemRange.getParent().removeContent((Content)elemRange);
                    elemBSTreeMap.addContent((Content)elemRange);
                    Element elemStyle = elemTheme.getChild("style", ns);
                    elemStyle.setName("basicStyle");
                    elemStyle.getParent().removeContent((Content)elemStyle);
                    elemBSTreeMap.addContent((Content)elemStyle);
                    List lstContent = elemRange.cloneContent();
                    Element elemLblRange = new Element("com.vividsolutions.jump.util.Range", ns);
                    elemLblRange.addContent((Collection)lstContent);
                    elemLblTreeMap.addContent((Content)elemLblRange);
                    Element elemLabel = elemTheme.getChild("label", ns);
                    elemLabel.setName("string");
                    elemLabel.getParent().removeContent((Content)elemLabel);
                    elemLblTreeMap.addContent((Content)elemLabel);
                }
            } else {
                elemBS.setAttribute("class", "tree-map", ns);
                elemLbl.setAttribute("class", "tree-map", ns);
                elemBS.addContent((Content)new Element("no-comparator", ns));
                elemLbl.addContent((Content)new Element("no-comparator", ns));
                for (Element elemTheme : lstThemes) {
                    Element elemBSEntry = new Element("entry", ns);
                    elemBS.addContent((Content)elemBSEntry);
                    Element elemBSKey = new Element("string", ns);
                    elemBSKey.setText(elemTheme.getChildText("key", ns));
                    elemBSEntry.addContent((Content)elemBSKey);
                    Element elemStyle = elemTheme.getChild("style", ns);
                    elemStyle.setName("basicStyle");
                    elemStyle.getParent().removeContent((Content)elemStyle);
                    elemBSEntry.addContent((Content)elemStyle);
                    Element elemLblEntry = new Element("entry", ns);
                    elemLbl.addContent((Content)elemLblEntry);
                    Element elemLblKey = new Element("string", ns);
                    elemLblKey.setText(elemTheme.getChildText("key", ns));
                    elemLblEntry.addContent((Content)elemLblKey);
                    Element elemLblValue = new Element("string", ns);
                    elemLblValue.setText(elemTheme.getChildText("label", ns));
                    elemLblEntry.addContent((Content)elemLblValue);
                }
            }
            elem.addContent((Content)elemBS);
            elem.addContent((Content)elemLbl);
        }
        if (elem.getName().equals("basicStyle") || elem.getName().equals("defaultStyle") || elem.getName().equals("redlineBasicStyle")) {
            elem.removeChild("selectPolygonAsLine", elem.getNamespace());
        }
        if (elem.getName().equals("textStyle") || elem.getName().equals("txtStyle") || elem.getName().equals("tooltipStyle")) {
            Element eAP = elem.getChild("alignPoint", elem.getNamespace());
            Element eAL = elem.getChild("alignLine", elem.getNamespace());
            Element eAA = elem.getChild("alignArea", elem.getNamespace());
            Element eIP = new Element("intInsertPoint", elem.getNamespace());
            Element eIL = new Element("intInsertLine", elem.getNamespace());
            Element eIA = new Element("intInsertArea", elem.getNamespace());
            if (StringSupport.isNumeric((String)eAP.getText())) {
                int intValue = Integer.parseInt(eAP.getText());
                eIP.setText("" + intValue);
            } else {
                eIP.setText("7");
            }
            if (StringSupport.isNumeric((String)eAL.getText())) {
                int intValue = Integer.parseInt(eAL.getText());
                eIL.setText("" + intValue);
            } else {
                eIL.setText("7");
            }
            if (StringSupport.isNumeric((String)eAA.getText())) {
                int intValue = Integer.parseInt(eAA.getText());
                eIA.setText("" + intValue);
            } else {
                eIA.setText("7");
            }
            elem.removeChild("alignPoint", elem.getNamespace());
            elem.removeChild("alignLine", elem.getNamespace());
            elem.removeChild("alignArea", elem.getNamespace());
            elem.addContent((Content)eIP);
            elem.addContent((Content)eIL);
            elem.addContent((Content)eIA);
        }
        List lstChilds = elem.getChildren();
        Iterator i = lstChilds.iterator();
        while (i.hasNext()) {
            this.unconvertElement((Element)i.next());
        }
    }

    @Override
    public boolean supportsUnconvert() {
        return false;
    }

    @Override
    public int oldVersionNumber() {
        return 12;
    }

    @Override
    public int newVersionNumber() {
        return 13;
    }

    @Override
    public String oldVersionName() {
        return "";
    }

    private Element getThemes4SingleValue(Element elemBS, Element elemLbl) {
        Namespace ns = elemBS.getNamespace();
        Element elemThemes = new Element("themes", ns);
        List lstBSEntries = elemBS.getChildren("entry", ns);
        List lstLblEntries = elemLbl.getChildren("entry", ns);
        for (Element bsEntry : lstBSEntries) {
            Element elemTheme = new Element("theme", ns);
            Element elemKey = new Element("key", ns);
            elemKey.setAttribute("class", "string");
            String strKey = bsEntry.getChildText("string", ns);
            elemKey.setText(strKey);
            elemTheme.addContent((Content)elemKey);
            Element elemLabel = new Element("label", ns);
            boolean labelFound = false;
            for (Element lblEntry : lstLblEntries) {
                String strLblKey = ((Element)lblEntry.getChildren().get(0)).getText();
                if (!strKey.equals(strLblKey)) continue;
                String strLabel = ((Element)lblEntry.getChildren().get(1)).getText();
                elemLabel.setText(strLabel);
                labelFound = true;
                break;
            }
            if (!labelFound) {
                LOG.warn("Error converting colorThemingStyle: No label found for key: " + strKey);
                elemLabel.setText(strKey);
            }
            elemTheme.addContent((Content)elemLabel);
            Element elemStyle = bsEntry.getChild("basicStyle", ns);
            elemStyle.setName("style");
            elemStyle.getParent().removeContent((Content)elemStyle);
            elemTheme.addContent((Content)elemStyle);
            elemThemes.addContent((Content)elemTheme);
        }
        return elemThemes;
    }

    private Element getThemes4Range(Element elemBS, Element elemLbl) {
        Namespace ns = elemBS.getNamespace();
        Element elemThemes = new Element("themes", ns);
        ArrayList lstBSEntries = elemBS.getChild("tree-map", ns).getChildren();
        ArrayList lstLblEntries = elemLbl.getChild("tree-map", ns).getChildren();
        int size = lstBSEntries.size();
        lstBSEntries = new ArrayList(lstBSEntries);
        lstLblEntries = new ArrayList(lstLblEntries);
        for (int i = 2; i < size; i += 2) {
            Element elemTheme = new Element("theme", ns);
            Element elemKey = (Element)lstBSEntries.get(i);
            this.convertRange(elemKey);
            elemKey.getParent().removeContent((Content)elemKey);
            elemTheme.addContent((Content)elemKey);
            Element elemStyle = (Element)lstBSEntries.get(i + 1);
            elemStyle.setName("style");
            elemStyle.getParent().removeContent((Content)elemStyle);
            elemTheme.addContent((Content)elemStyle);
            Element elemLabel = (Element)lstLblEntries.get(i + 1);
            elemLabel.setName("label");
            elemLabel.getParent().removeContent((Content)elemLabel);
            elemTheme.addContent((Content)elemLabel);
            elemThemes.addContent((Content)elemTheme);
        }
        return elemThemes;
    }

    private void convertRange(Element elemRange) {
        Namespace ns = elemRange.getNamespace();
        elemRange.setName("key");
        elemRange.setAttribute("class", "range");
        Element elemMax = elemRange.getChild("max", ns);
        Element elemMin = elemRange.getChild("min", ns);
        if (elemMax.getAttribute("class", ns).getValue().equals("com.vividsolutions.jump.util.Range$PositiveInfinity")) {
            elemMax.removeAttribute("class", ns);
            elemMax.setAttribute("class", "rangePositiveInfinity");
        }
        if (elemMin.getAttribute("class", ns).getValue().equals("com.vividsolutions.jump.util.Range$PositiveInfinity")) {
            elemMin.removeAttribute("class", ns);
            elemMin.setAttribute("class", "rangePositiveInfinity");
        }
        if (elemMax.getAttribute("class", ns).getValue().equals("com.vividsolutions.jump.util.Range$NegativeInfinity")) {
            elemMax.removeAttribute("class", ns);
            elemMax.setAttribute("class", "rangeNegativeInfinity");
        }
        if (elemMin.getAttribute("class", ns).getValue().equals("com.vividsolutions.jump.util.Range$NegativeInfinity")) {
            elemMin.removeAttribute("class", ns);
            elemMin.setAttribute("class", "rangeNegativeInfinity");
        }
    }

    private void unconvertRange(Element elemRange) {
        Namespace ns = elemRange.getNamespace();
        elemRange.setName("com.vividsolutions.jump.util.Range");
        elemRange.removeAttribute("class", ns);
        Element elemMax = elemRange.getChild("max", ns);
        Element elemMin = elemRange.getChild("min", ns);
        if (elemMax.getAttribute("class", ns).getValue().equals("rangePositiveInfinity")) {
            elemMax.removeAttribute("class", ns);
            elemMax.setAttribute("class", "com.vividsolutions.jump.util.Range$PositiveInfinity");
        }
        if (elemMin.getAttribute("class", ns).getValue().equals("rangePositiveInfinity")) {
            elemMin.removeAttribute("class", ns);
            elemMin.setAttribute("class", "com.vividsolutions.jump.util.Range$PositiveInfinity");
        }
        if (elemMax.getAttribute("class", ns).getValue().equals("rangeNegativeInfinity")) {
            elemMax.removeAttribute("class", ns);
            elemMax.setAttribute("class", "com.vividsolutions.jump.util.Range$NegativeInfinity");
        }
        if (elemMin.getAttribute("class", ns).getValue().equals("rangeNegativeInfinity")) {
            elemMin.removeAttribute("class", ns);
            elemMin.setAttribute("class", "com.vividsolutions.jump.util.Range$NegativeInfinity");
        }
    }
}

