/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.version;

import de.riwagis.riwajump.model.version.AbstractVersionConverter;
import de.riwagis.riwajump.model.version.VersionConverter;
import de.riwagis.riwajump.model.version.VersionDependentAdjuster;
import java.io.IOException;
import java.util.function.Consumer;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JumpDocumentTransformer {
    private static final Logger LOG = LoggerFactory.getLogger(JumpDocumentTransformer.class);

    public static String getJavaVersion(Document doc) {
        return JumpDocumentTransformer.readString(doc, "javaversion");
    }

    public static String getProgrammVersion(Document doc) {
        return JumpDocumentTransformer.readString(doc, "version");
    }

    public static int getProjectVersion(Document doc) {
        return JumpDocumentTransformer.readInt(doc, "prjversion");
    }

    public static final Integer readInt(Document document, String childElementName) {
        return JumpDocumentTransformer.readInt(document.getRootElement(), childElementName);
    }

    public static final Integer readInt(Element element, String childElementName) {
        int intPrjVersion;
        try {
            intPrjVersion = Integer.parseInt(element.getChildTextTrim(childElementName));
        }
        catch (Exception e) {
            LOG.warn("unable to get prjversion");
            return 0;
        }
        return intPrjVersion;
    }

    public static final String readString(Document document, String childElementName) {
        return JumpDocumentTransformer.readString(document.getRootElement(), childElementName);
    }

    public static final String readString(Element element, String childElementName) {
        String strPrgVersion;
        try {
            strPrgVersion = element.getChildTextTrim(childElementName);
        }
        catch (Exception e) {
            LOG.warn(String.format("unable to get element '%s' from element '%s': %s", childElementName, element.getName(), e.getMessage()), (Throwable)e);
            return null;
        }
        return strPrgVersion;
    }

    public static Element addElementIfNotPresent(Element parentElement, String subElementName, String subElementText) {
        Namespace ns = parentElement.getNamespace();
        Element existantElement = parentElement.getChild(subElementName, ns);
        if (existantElement != null) {
            return existantElement;
        }
        Element elementToAdd = new Element(subElementName, ns);
        elementToAdd.setText(subElementText);
        parentElement.addContent((Content)elementToAdd);
        return elementToAdd;
    }

    public static void doOnElement(Element elementToWorkOn, Consumer<Element> execute, boolean recurseChildren) {
        execute.accept(elementToWorkOn);
        if (recurseChildren) {
            for (Element currChildElement : elementToWorkOn.getChildren()) {
                JumpDocumentTransformer.doOnElement(currChildElement, execute, recurseChildren);
            }
        }
    }

    public static boolean convertAndAdjustDoc(Document doc, String clientVersion, int prjVersion) throws IOException {
        return JumpDocumentTransformer.convertAndAdjustDoc(doc, clientVersion, prjVersion, false);
    }

    public static boolean convertAndAdjustDoc(Document doc, String clientVersion, int prjVersion, boolean skipConversion) throws IOException {
        boolean bolConversion = false;
        if (!skipConversion) {
            for (VersionConverter currConverter : VersionConverter.CONVERTERS) {
                if (currConverter.newVersionNumber() > prjVersion) break;
                if (!currConverter.needsConversion(doc)) continue;
                currConverter.convert(doc);
                bolConversion = true;
            }
        }
        Integer docVersionAfterConversion = bolConversion ? prjVersion : JumpDocumentTransformer.getProjectVersion(doc);
        boolean bolAdjustedOnDeserialization = VersionDependentAdjuster.ADJUSTERS.stream().filter(adj -> adj.versionNumberToTarget() == docVersionAfterConversion.intValue() && adj.needsAdjustmentsBeforeDeserialization(doc)).findFirst().map(adj -> {
            adj.adjustBeforeDeserialization(doc);
            return true;
        }).orElse(false);
        boolean bolAdjustedOnCrash = VersionDependentAdjuster.ADJUSTERS.stream().filter(adj -> adj.versionNumberToTarget() == docVersionAfterConversion.intValue() && adj.needsAdjustmentsOnCrash(doc)).findFirst().map(adj -> {
            adj.adjustOnCrash(doc);
            return true;
        }).orElse(false);
        if (bolConversion || bolAdjustedOnDeserialization || bolAdjustedOnCrash) {
            JumpDocumentTransformer.setVersion(doc, clientVersion, prjVersion);
        }
        return bolConversion || bolAdjustedOnDeserialization || bolAdjustedOnCrash;
    }

    public static boolean unconvertDoc(Document doc, String prg_version, int prj_version) throws IOException {
        boolean bolConversion = false;
        int serverDocumentVersion = AbstractVersionConverter.getProjectVersion(doc);
        for (int i = VersionConverter.CONVERTERS.length - 1; i >= 0; --i) {
            VersionConverter currConverter = VersionConverter.CONVERTERS[i];
            if (currConverter.newVersionNumber() > serverDocumentVersion) continue;
            if (currConverter.supportsUnconvert()) {
                if (currConverter.oldVersionNumber() < prj_version) break;
                currConverter.unconvert(doc);
                bolConversion = true;
                if (currConverter.oldVersionNumber() != prj_version) continue;
                break;
            }
            throw new IOException(String.format("Unconversion of project files is not supported for given client version %s.", prj_version));
        }
        if (bolConversion) {
            JumpDocumentTransformer.setVersion(doc, prg_version, prj_version);
        }
        return bolConversion;
    }

    private static void setVersion(Document doc, String version, int prjversion) {
        String javaversion = System.getProperty("java.version");
        doc.getRootElement().getChild("version").setText(version);
        doc.getRootElement().getChild("javaversion").setText(javaversion);
        doc.getRootElement().getChild("prjversion").setText("" + prjversion);
    }
}

