/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.version;

import de.riwagis.riwajump.model.version.JumpDocumentTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicStyleElementFix {
    private static final Logger log = LoggerFactory.getLogger(BasicStyleElementFix.class);
    private Collection<Element> lstStyleCollectionsWithBasicStyles = new ArrayList<Element>();
    public static final String BASIC_STYLE_NAME = "basicStyle";

    public void fixBuggyLstLayerStyleCollection(Element lstStyleCollection) {
        Element defaultScol;
        Element fixedLayerStyle = this.retrieveFixedLayerStyle(lstStyleCollection);
        if (fixedLayerStyle != null && (defaultScol = this.getDefaultSColFromList(lstStyleCollection)) != null) {
            defaultScol.getChild("lstStyles").removeChild(BASIC_STYLE_NAME);
            defaultScol.getChild("lstStyles").addContent((Content)fixedLayerStyle);
            if (!Objects.equals(fixedLayerStyle.getName(), "CadStyle") && !Objects.equals(fixedLayerStyle.getName(), "dimStyle")) {
                defaultScol.setName("simpleSCol");
            }
        }
    }

    public Collection<Element> initializeBasicStyleBugCollection(Document doc) {
        this.lstStyleCollectionsWithBasicStyles = new ArrayList<Element>();
        try {
            JumpDocumentTransformer.doOnElement(doc.getRootElement(), elem -> {
                if (elem.getName().equals(BASIC_STYLE_NAME) && this.isScaleDependentRenderingEnabled((Element)elem) && this.basicStyleElementIsBuggy((Element)elem)) {
                    this.lstStyleCollectionsWithBasicStyles.add(elem.getParentElement().getParentElement().getParentElement());
                }
            }, true);
        }
        catch (Exception e) {
            log.debug("An error occured while scanning the document for basicStyles inside CadLayer: {}", (Object)e.getMessage());
        }
        return this.lstStyleCollectionsWithBasicStyles;
    }

    public Collection<Element> getStyleCollectionWithBasicStyle() {
        return this.lstStyleCollectionsWithBasicStyles;
    }

    private boolean isScaleDependentRenderingEnabled(Element elem) {
        String scaleEnabled = elem.getParentElement().getParentElement().getParentElement().getParentElement().getChild("scaleDependentRenderingEnabled").getValue();
        return Objects.equals(scaleEnabled, "true");
    }

    private boolean basicStyleElementIsBuggy(Element elem) {
        boolean isDefault = Objects.equals(elem.getParentElement().getParentElement().getChild("bolDefault").getValue(), "true");
        boolean parentIsCad = Objects.equals(this.getParentLayerName(elem, 4), "CadLayer");
        boolean parentIsWMS = Objects.equals(this.getParentLayerName(elem, 4), "wmsLayer");
        boolean parentIsWMTS = Objects.equals(this.getParentLayerName(elem, 4), "wmtsLayer");
        boolean parentIsRaster = Objects.equals(this.getParentLayerName(elem, 4), "rasterLayer");
        boolean parentIsDim = Objects.equals(this.getParentLayerName(elem, 4), "DimLayer");
        return isDefault && (parentIsCad || parentIsWMS || parentIsWMTS || parentIsRaster || parentIsDim);
    }

    private Element retrieveFixedLayerStyle(Element elem) {
        if (Objects.equals(this.getParentLayerName(elem, 1), "CadLayer")) {
            return this.getDefaultCadStyle();
        }
        if (Objects.equals(this.getParentLayerName(elem, 1), "wmsLayer")) {
            return this.getDefaultWMSStyle();
        }
        if (Objects.equals(this.getParentLayerName(elem, 1), "wmtsLayer")) {
            return this.getDefaultWMTSStyle();
        }
        if (Objects.equals(this.getParentLayerName(elem, 1), "rasterLayer")) {
            return this.getDefaultRasterStyle();
        }
        if (Objects.equals(this.getParentLayerName(elem, 1), "DimLayer")) {
            return this.getDefaultDimStyleElement();
        }
        return null;
    }

    private String getParentLayerName(Element style, int searchDepth) {
        Element parent = style;
        for (int i = 0; i < searchDepth; ++i) {
            parent = parent.getParentElement();
        }
        return parent.getName();
    }

    private Element getDefaultSColFromList(Element lstStyleCollection) {
        for (Element child : lstStyleCollection.getChildren()) {
            if (child.getChild("bolDefault") == null || !Objects.equals(child.getChild("bolDefault").getValue(), "true")) continue;
            return child;
        }
        return null;
    }

    private Element getDefaultCadStyle() {
        Element cadStyle = new Element("CadStyle");
        cadStyle.addContent((Content)new Element("enabled").setText("true"));
        cadStyle.addContent((Content)new Element("showTooltips").setText("true"));
        cadStyle.addContent((Content)new Element("useOrderBy").setText("false"));
        cadStyle.addContent((Content)new Element("strSymStore").setText("_buildIn"));
        cadStyle.addContent((Content)new Element("intUnitLength").setText("1"));
        cadStyle.addContent((Content)new Element("intUnitOri").setText("0"));
        cadStyle.addContent((Content)new Element("mapLayerVisi"));
        cadStyle.addContent((Content)new Element("mapLayerID").setAttribute("class", "linked-hash-map"));
        cadStyle.addContent((Content)new Element("useFiltering").setText("false"));
        cadStyle.addContent((Content)new Element("loadAllLayers").setText("false"));
        return cadStyle;
    }

    private Element getDefaultRasterStyle() {
        Element rasterStyle = new Element("rasterStyle");
        rasterStyle.addContent((Content)new Element("enabled").setText("true"));
        rasterStyle.addContent((Content)new Element("alpha").setText("255"));
        Element clearColor = new Element("clearColor");
        clearColor.addContent((Content)new Element("red").setText("0"));
        clearColor.addContent((Content)new Element("green").setText("0"));
        clearColor.addContent((Content)new Element("blue").setText("255"));
        clearColor.addContent((Content)new Element("alpha").setText("255"));
        rasterStyle.addContent((Content)clearColor);
        rasterStyle.addContent((Content)new Element("useClearColor").setText("false"));
        return rasterStyle;
    }

    private Element getDefaultWMSStyle() {
        Element wmsStyle = new Element("wmsStyle");
        wmsStyle.addContent((Content)new Element("enabled").setText("true"));
        wmsStyle.addContent((Content)new Element("alpha").setText("255"));
        wmsStyle.addContent((Content)new Element("strServerURL"));
        wmsStyle.addContent((Content)new Element("strVersion").setText("1.1.1"));
        wmsStyle.addContent((Content)new Element("strFormat"));
        wmsStyle.addContent((Content)new Element("lstLayerNames"));
        wmsStyle.addContent((Content)new Element("lstLayerInvisible"));
        wmsStyle.addContent((Content)new Element("strSRS"));
        Element clearColor = new Element("clearColor");
        clearColor.addContent((Content)new Element("red").setText("222"));
        clearColor.addContent((Content)new Element("green").setText("22"));
        clearColor.addContent((Content)new Element("blue").setText("222"));
        clearColor.addContent((Content)new Element("alpha").setText("0"));
        wmsStyle.addContent((Content)clearColor);
        wmsStyle.addContent((Content)new Element("bolUseClearColor").setText("false"));
        wmsStyle.addContent((Content)new Element("serverNeedsLogin").setText("false"));
        wmsStyle.addContent((Content)new Element("hideWmsLayers").setText("false"));
        wmsStyle.addContent((Content)new Element("ignoreFeatureInfo").setText("false"));
        return wmsStyle;
    }

    private Element getDefaultWMTSStyle() {
        Element wmtsStyle = new Element("wmtsStyle");
        wmtsStyle.addContent((Content)new Element("enabled").setText("true"));
        wmtsStyle.addContent((Content)new Element("alpha").setText("255"));
        wmtsStyle.addContent((Content)new Element("serverURL"));
        wmtsStyle.addContent((Content)new Element("version").setText("1.0.0"));
        wmtsStyle.addContent((Content)new Element("format"));
        wmtsStyle.addContent((Content)new Element("layerName"));
        wmtsStyle.addContent((Content)new Element("tileMatrixSet"));
        wmtsStyle.addContent((Content)new Element("style"));
        Element clearColor = new Element("clearColor");
        clearColor.addContent((Content)new Element("red").setText("222"));
        clearColor.addContent((Content)new Element("green").setText("22"));
        clearColor.addContent((Content)new Element("blue").setText("222"));
        clearColor.addContent((Content)new Element("alpha").setText("0"));
        wmtsStyle.addContent((Content)clearColor);
        wmtsStyle.addContent((Content)new Element("useClearColor").setText("false"));
        wmtsStyle.addContent((Content)new Element("serverNeedsLogin").setText("false"));
        wmtsStyle.addContent((Content)new Element("tileSetThreshold").setText("0.66"));
        wmtsStyle.addContent((Content)new Element("ignoreFeatureInfo").setText("false"));
        return wmtsStyle;
    }

    private Element getDefaultDimStyleElement() {
        Element dimStyle = new Element("dimStyle");
        dimStyle.addContent((Content)new Element("enabled").setText("true"));
        dimStyle.addContent((Content)new Element("lengthUnit").setText("1"));
        dimStyle.addContent((Content)new Element("oriUnit").setText("0"));
        dimStyle.addContent((Content)new Element("intAlpha").setText("255"));
        dimStyle.addContent((Content)new Element("bolRefLine").setText("true"));
        dimStyle.addContent((Content)new Element("bolRefLinePattern").setText("false"));
        dimStyle.addContent((Content)new Element("fltRefLineWidth").setText("1.0"));
        dimStyle.addContent((Content)new Element("fltRefLineOverDim").setText("0.0"));
        Element colorRefLine = new Element("colorRefLine");
        colorRefLine.addContent((Content)new Element("red").setText("0"));
        colorRefLine.addContent((Content)new Element("green").setText("0"));
        colorRefLine.addContent((Content)new Element("blue").setText("0"));
        colorRefLine.addContent((Content)new Element("alpha").setText("255"));
        dimStyle.addContent((Content)colorRefLine);
        dimStyle.addContent((Content)new Element("bolDimLine").setText("true"));
        dimStyle.addContent((Content)new Element("bolDimLinePattern").setText("false"));
        dimStyle.addContent((Content)new Element("fltDimLineWidth").setText("1.0"));
        Element colorDimLine = new Element("colorDimLine");
        colorDimLine.addContent((Content)new Element("red").setText("0"));
        colorDimLine.addContent((Content)new Element("green").setText("0"));
        colorDimLine.addContent((Content)new Element("blue").setText("0"));
        colorDimLine.addContent((Content)new Element("alpha").setText("255"));
        dimStyle.addContent((Content)colorDimLine);
        dimStyle.addContent((Content)new Element("bolDimText").setText("true"));
        dimStyle.addContent((Content)new Element("fltDimTextHeight").setText("10.0"));
        dimStyle.addContent((Content)new Element("bolDimTextOpaque").setText("false"));
        dimStyle.addContent((Content)new Element("intDimTextDecPlaces").setText("2"));
        Element fontDimText = new Element("fontDimText");
        fontDimText.addContent((Content)new Element("name").setText("Liberation Sans"));
        fontDimText.addContent((Content)new Element("style").setText("0"));
        fontDimText.addContent((Content)new Element("size").setText("12"));
        dimStyle.addContent((Content)fontDimText);
        Element colorDimText = new Element("colorDimText");
        colorDimText.addContent((Content)new Element("red").setText("0"));
        colorDimText.addContent((Content)new Element("green").setText("0"));
        colorDimText.addContent((Content)new Element("blue").setText("0"));
        colorDimText.addContent((Content)new Element("alpha").setText("255"));
        dimStyle.addContent((Content)colorDimText);
        Element colorDimTextOpaque = new Element("colorDimTextOpaque");
        colorDimTextOpaque.addContent((Content)new Element("red").setText("0"));
        colorDimTextOpaque.addContent((Content)new Element("green").setText("0"));
        colorDimTextOpaque.addContent((Content)new Element("blue").setText("0"));
        colorDimTextOpaque.addContent((Content)new Element("alpha").setText("255"));
        dimStyle.addContent((Content)colorDimTextOpaque);
        dimStyle.addContent((Content)new Element("showTooltips").setText("false"));
        dimStyle.addContent((Content)new Element("bolShowSymbol").setText("true"));
        dimStyle.addContent((Content)new Element("intSymbolType").setText("0"));
        dimStyle.addContent((Content)new Element("fltSymbolSize").setText("10.0"));
        return dimStyle;
    }
}

