/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.style.theme;

import de.riwagis.riwajump.model.JumpModel;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.FontModel;
import de.riwagis.riwajump.model.style.LineStyleModel;
import de.riwagis.riwajump.model.style.SymbolStyleModel;
import de.riwagis.riwajump.model.style.TextStyleModel;
import de.riwagis.riwajump.model.style.theme.DynamicThemeModificatorArgumentType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicThemeModificators {
    private static final Logger log = LoggerFactory.getLogger(DynamicThemeModificators.class);
    private final Map<String, BiConsumer<BasicStyleModel, Object>> styleAppliers = new HashMap<String, BiConsumer<BasicStyleModel, Object>>();
    private final Map<String, DynamicThemeModificatorArgumentType> applierTypes = new HashMap<String, DynamicThemeModificatorArgumentType>();
    private static DynamicThemeModificators instance;

    public static DynamicThemeModificators getInstance() {
        if (instance == null) {
            instance = new DynamicThemeModificators();
        }
        return instance;
    }

    private DynamicThemeModificators() {
        this.registerApplier("area.color", DynamicThemeModificatorArgumentType.COLOR, BasicStyleModel::setFillColor);
        this.registerApplier("area.enabled", DynamicThemeModificatorArgumentType.BOOLEAN, BasicStyleModel::setRenderingFill);
        this.registerApplier("area.pattern.enabled", DynamicThemeModificatorArgumentType.BOOLEAN, BasicStyleModel::setRenderingFillPattern);
        this.registerApplier("area.pattern.symbol", DynamicThemeModificatorArgumentType.BEANSHELL, BasicStyleModel::setStrFillSymName);
        this.registerApplier("area.pattern.width", DynamicThemeModificatorArgumentType.BEANSHELL, BasicStyleModel::setFillSymWidth);
        this.registerApplier("area.pattern.color-overwrite", DynamicThemeModificatorArgumentType.BOOLEAN, BasicStyleModel::setBolFillSymColorOverwrite);
        this.registerApplierForLine("line.foreground", BasicStyleModel::getLineForeground);
        this.registerApplierForLine("line.base", BasicStyleModel::getLineBase);
        this.registerApplierForLine("line.background", BasicStyleModel::getLineBackground);
        this.registerApplier("label.enabled", DynamicThemeModificatorArgumentType.BOOLEAN, BasicStyleModel::setRenderingText);
        this.registerApplierForText("label", BasicStyleModel::getTextStyle);
        this.registerApplier("symbol.enabled", DynamicThemeModificatorArgumentType.BOOLEAN, BasicStyleModel::setRenderingSymbol);
        this.registerApplierForSymbol("symbol", BasicStyleModel::getSymStyle);
    }

    public BiConsumer<BasicStyleModel, Object> getStyleApplier(String property) {
        BiConsumer<BasicStyleModel, Object> applier = this.styleAppliers.get(property);
        if (applier == null) {
            throw new IllegalModificatorException(property);
        }
        return applier;
    }

    public DynamicThemeModificatorArgumentType getApplierType(String property) {
        DynamicThemeModificatorArgumentType type = this.applierTypes.get(property);
        if (type == null) {
            throw new IllegalModificatorException(property);
        }
        return type;
    }

    public void ensureValidProperty(String property) {
        if (!this.styleAppliers.containsKey(property)) {
            throw new IllegalModificatorException(property);
        }
    }

    public Set<String> getStyleApplierNames() {
        return this.styleAppliers.keySet();
    }

    private void registerApplierForSymbol(String name, Function<BasicStyleModel, SymbolStyleModel> symbolSupplier) {
        this.registerApplierOnSubModel(name + ".enabled-for-lines-and-areas", DynamicThemeModificatorArgumentType.BOOLEAN, SymbolStyleModel::setBolRenderLineAreaPoints, symbolSupplier);
        this.registerApplierOnSubModel(name + ".point.symbol", DynamicThemeModificatorArgumentType.BEANSHELL, SymbolStyleModel::setStrPtSymbol, symbolSupplier);
        this.registerApplierOnSubModel(name + ".point.keep-ratio", DynamicThemeModificatorArgumentType.BOOLEAN, SymbolStyleModel::setBolPtRatio, symbolSupplier);
        this.registerApplierOnSubModel(name + ".point.width", DynamicThemeModificatorArgumentType.BEANSHELL, SymbolStyleModel::setStrPtWidth, symbolSupplier);
        this.registerApplierOnSubModel(name + ".point.height", DynamicThemeModificatorArgumentType.BEANSHELL, SymbolStyleModel::setStrPtHeight, symbolSupplier);
        this.registerApplierOnSubModel(name + ".point.orientation", DynamicThemeModificatorArgumentType.BEANSHELL, SymbolStyleModel::setStrPtOri, symbolSupplier);
        this.registerApplierOnSubModel(name + ".point.shift.left", DynamicThemeModificatorArgumentType.BEANSHELL, SymbolStyleModel::setStrPtShiftLeft, symbolSupplier);
        this.registerApplierOnSubModel(name + ".point.shift.top", DynamicThemeModificatorArgumentType.BEANSHELL, SymbolStyleModel::setStrPtShiftTop, symbolSupplier);
        this.registerApplierOnSubModel(name + ".point.shift.in-orientation", DynamicThemeModificatorArgumentType.BOOLEAN, SymbolStyleModel::setBolPtShiftInOri, symbolSupplier);
        this.registerApplierOnSubModel(name + ".line-start.symbol", DynamicThemeModificatorArgumentType.BEANSHELL, SymbolStyleModel::setStrStartSymbol, symbolSupplier);
        this.registerApplierOnSubModel(name + ".line-start.keep-ratio", DynamicThemeModificatorArgumentType.BOOLEAN, SymbolStyleModel::setBolStartRatio, symbolSupplier);
        this.registerApplierOnSubModel(name + ".line-start.width", DynamicThemeModificatorArgumentType.BEANSHELL, SymbolStyleModel::setStrStartWidth, symbolSupplier);
        this.registerApplierOnSubModel(name + ".line-start.height", DynamicThemeModificatorArgumentType.BEANSHELL, SymbolStyleModel::setStrStartHeight, symbolSupplier);
        this.registerApplierOnSubModel(name + ".line-start.orientation", DynamicThemeModificatorArgumentType.BEANSHELL, SymbolStyleModel::setStrStartOri, symbolSupplier);
        this.registerApplierOnSubModel(name + ".line-end.symbol", DynamicThemeModificatorArgumentType.BEANSHELL, SymbolStyleModel::setStrEndSymbol, symbolSupplier);
        this.registerApplierOnSubModel(name + ".line-end.keep-ratio", DynamicThemeModificatorArgumentType.BOOLEAN, SymbolStyleModel::setBolEndRatio, symbolSupplier);
        this.registerApplierOnSubModel(name + ".line-end.width", DynamicThemeModificatorArgumentType.BEANSHELL, SymbolStyleModel::setStrEndWidth, symbolSupplier);
        this.registerApplierOnSubModel(name + ".line-end.height", DynamicThemeModificatorArgumentType.BEANSHELL, SymbolStyleModel::setStrEndHeight, symbolSupplier);
        this.registerApplierOnSubModel(name + ".line-end.orientation", DynamicThemeModificatorArgumentType.BEANSHELL, SymbolStyleModel::setStrEndOri, symbolSupplier);
        this.registerApplierOnSubModel(name + ".area.symbol", DynamicThemeModificatorArgumentType.BEANSHELL, SymbolStyleModel::setStrAreaSymbol, symbolSupplier);
        this.registerApplierOnSubModel(name + ".area.keep-ratio", DynamicThemeModificatorArgumentType.BOOLEAN, SymbolStyleModel::setBolAreaRatio, symbolSupplier);
        this.registerApplierOnSubModel(name + ".area.width", DynamicThemeModificatorArgumentType.BEANSHELL, SymbolStyleModel::setStrAreaWidth, symbolSupplier);
        this.registerApplierOnSubModel(name + ".area.height", DynamicThemeModificatorArgumentType.BEANSHELL, SymbolStyleModel::setStrAreaHeight, symbolSupplier);
        this.registerApplierOnSubModel(name + ".area.orientation", DynamicThemeModificatorArgumentType.BEANSHELL, SymbolStyleModel::setStrAreaOri, symbolSupplier);
        this.registerApplierOnSubModel(name + ".area.shift.left", DynamicThemeModificatorArgumentType.BEANSHELL, SymbolStyleModel::setStrAreaShiftLeft, symbolSupplier);
        this.registerApplierOnSubModel(name + ".area.shift.top", DynamicThemeModificatorArgumentType.BEANSHELL, SymbolStyleModel::setStrAreaShiftTop, symbolSupplier);
        this.registerApplierOnSubModel(name + ".area.shift.in-orientation", DynamicThemeModificatorArgumentType.BOOLEAN, SymbolStyleModel::setBolAreaShiftInOri, symbolSupplier);
        this.registerApplierOnSubModel(name + ".area.shift.position", DynamicThemeModificatorArgumentType.INTEGER, SymbolStyleModel::setIntAreaPos, symbolSupplier);
        this.registerApplierOnSubModel(name + ".overwrite-line-color", DynamicThemeModificatorArgumentType.BOOLEAN, SymbolStyleModel::setBolOverwriteLineColor, symbolSupplier);
        this.registerApplierOnSubModel(name + ".line-color", DynamicThemeModificatorArgumentType.COLOR, SymbolStyleModel::setLineColor, symbolSupplier);
        this.registerApplierOnSubModel(name + ".overwrite-fill-color", DynamicThemeModificatorArgumentType.BOOLEAN, SymbolStyleModel::setBolOverwriteAreaColor, symbolSupplier);
        this.registerApplierOnSubModel(name + ".fill-color", DynamicThemeModificatorArgumentType.COLOR, SymbolStyleModel::setFillColor, symbolSupplier);
    }

    private void registerApplierForText(String name, Function<BasicStyleModel, TextStyleModel> textSupplier) {
        this.registerApplierOnSubModel(name + ".text", DynamicThemeModificatorArgumentType.BEANSHELL, TextStyleModel::setStrText, textSupplier);
        this.registerApplierOnSubModel(name + ".orientation", DynamicThemeModificatorArgumentType.BEANSHELL, TextStyleModel::setStrOrient, textSupplier);
        this.registerApplierOnSubModel(name + ".height", DynamicThemeModificatorArgumentType.BEANSHELL, TextStyleModel::setStrHeight, textSupplier);
        this.registerApplierOnSubModel(name + ".shift.in-orientation", DynamicThemeModificatorArgumentType.BOOLEAN, TextStyleModel::setBolTransInOri, textSupplier);
        this.registerApplierOnSubModel(name + ".shift.left", DynamicThemeModificatorArgumentType.BEANSHELL, TextStyleModel::setStrTransLeft, textSupplier);
        this.registerApplierOnSubModel(name + ".shift.top", DynamicThemeModificatorArgumentType.BEANSHELL, TextStyleModel::setStrTransTop, textSupplier);
        this.registerApplierOnSubModel(name + ".opaque", DynamicThemeModificatorArgumentType.BOOLEAN, TextStyleModel::setBolOpaque, textSupplier);
        this.registerApplierOnSubModel(name + ".color.text", DynamicThemeModificatorArgumentType.COLOR, TextStyleModel::setColorText, textSupplier);
        this.registerApplierOnSubModel(name + ".color.background", DynamicThemeModificatorArgumentType.COLOR, TextStyleModel::setColorOpaque, textSupplier);
        this.registerApplierForFont(name + ".font", m -> ((TextStyleModel)textSupplier.apply((BasicStyleModel)m)).getFontText());
        this.registerApplierOnSubModel(name + ".point.enabled", DynamicThemeModificatorArgumentType.BOOLEAN, TextStyleModel::setBolShowPoint, textSupplier);
        this.registerApplierOnSubModel(name + ".point.alignment", DynamicThemeModificatorArgumentType.BEANSHELL, TextStyleModel::setAlignPoint, textSupplier);
        this.registerApplierOnSubModel(name + ".point.first-only", DynamicThemeModificatorArgumentType.BOOLEAN, TextStyleModel::setBolOnlyLabelFirstPoint, textSupplier);
        this.registerApplierOnSubModel(name + ".line.enabled", DynamicThemeModificatorArgumentType.BOOLEAN, TextStyleModel::setBolShowLine, textSupplier);
        this.registerApplierOnSubModel(name + ".line.alignment", DynamicThemeModificatorArgumentType.BEANSHELL, TextStyleModel::setAlignLine, textSupplier);
        this.registerApplierOnSubModel(name + ".line.alignment-single", DynamicThemeModificatorArgumentType.INTEGER, TextStyleModel::setIntPosLine, textSupplier);
        this.registerApplierOnSubModel(name + ".line.alignment-multi", DynamicThemeModificatorArgumentType.INTEGER, TextStyleModel::setIntMultiLine, textSupplier);
        this.registerApplierOnSubModel(name + ".area.enabled", DynamicThemeModificatorArgumentType.BOOLEAN, TextStyleModel::setBolShowArea, textSupplier);
        this.registerApplierOnSubModel(name + ".area.alignment", DynamicThemeModificatorArgumentType.BEANSHELL, TextStyleModel::setAlignArea, textSupplier);
        this.registerApplierOnSubModel(name + ".area.alignment-single", DynamicThemeModificatorArgumentType.INTEGER, TextStyleModel::setIntPosArea, textSupplier);
        this.registerApplierOnSubModel(name + ".area.alignment-multi", DynamicThemeModificatorArgumentType.INTEGER, TextStyleModel::setIntMultiPolygon, textSupplier);
    }

    private void registerApplierForFont(String name, Function<BasicStyleModel, FontModel> fontSupplier) {
        this.registerApplierOnSubModel(name + ".name", DynamicThemeModificatorArgumentType.STRING, FontModel::setName, fontSupplier);
        this.registerApplierOnSubModel(name + ".style", DynamicThemeModificatorArgumentType.INTEGER, FontModel::setStyle, fontSupplier);
        this.registerApplierOnSubModel(name + ".size", DynamicThemeModificatorArgumentType.INTEGER, FontModel::setSize, fontSupplier);
    }

    private void registerApplierForLine(String name, Function<BasicStyleModel, LineStyleModel> lineSupplier) {
        this.registerApplierOnSubModel(name + ".enabled", DynamicThemeModificatorArgumentType.BOOLEAN, LineStyleModel::setEnabled, lineSupplier);
        this.registerApplierOnSubModel(name + ".color", DynamicThemeModificatorArgumentType.COLOR, LineStyleModel::setLineColor, lineSupplier);
        this.registerApplierOnSubModel(name + ".width", DynamicThemeModificatorArgumentType.BEANSHELL, LineStyleModel::setLineWidth, lineSupplier);
        this.registerApplierOnSubModel(name + ".pattern.definition", DynamicThemeModificatorArgumentType.BEANSHELL, LineStyleModel::setLinePattern, lineSupplier);
        this.registerApplierOnSubModel(name + ".pattern.enabled", DynamicThemeModificatorArgumentType.BOOLEAN, LineStyleModel::setRenderingLinePattern, lineSupplier);
    }

    private <T, S extends JumpModel> void registerApplierOnSubModel(String name, DynamicThemeModificatorArgumentType type, BiConsumer<S, T> styleApplier, Function<BasicStyleModel, S> subModelSupplier) {
        this.registerApplier(name, type, (style, value) -> {
            JumpModel subModel = (JumpModel)subModelSupplier.apply((BasicStyleModel)style);
            if (subModel == null) {
                log.warn("Trying to set an attribute on a missing style model.");
                return;
            }
            styleApplier.accept(subModel, value);
        });
    }

    private <T> void registerApplier(String name, DynamicThemeModificatorArgumentType type, BiConsumer<BasicStyleModel, T> styleApplier) {
        if (this.styleAppliers.containsKey(name) || this.applierTypes.containsKey(name)) {
            throw new AssertionError((Object)("Duplicated modificator key " + name));
        }
        this.styleAppliers.put(name, styleApplier);
        this.applierTypes.put(name, type);
    }

    public static class IllegalModificatorException
    extends IllegalStateException {
        public IllegalModificatorException(String property) {
            super("Style property '" + property + "' is unknown");
        }
    }
}

