/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.style.theme;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.converters.extended.ToAttributedValueConverter;
import de.riwagis.riwajump.model.JumpModel;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.theme.DynamicThemeModificatorArgumentType;
import de.riwagis.riwajump.model.style.theme.DynamicThemeModificators;
import java.util.function.BiConsumer;

@XStreamAlias(value="modificator")
@XStreamConverter(value=ToAttributedValueConverter.class, strings={"bsh"})
public class DynamicThemeModificatorModel
extends JumpModel {
    private String property;
    private String bsh;
    @XStreamAlias(value="result-is-bsh")
    private boolean resultIsBeanShell = false;

    public DynamicThemeModificatorModel() {
    }

    public DynamicThemeModificatorModel(DynamicThemeModificatorModel toCopy) {
        this(toCopy.getProperty(), toCopy.getBsh(), toCopy.isResultBeanShell());
    }

    public DynamicThemeModificatorModel(String property, String bsh) {
        this(property, bsh, false);
    }

    public DynamicThemeModificatorModel(String property, String bsh, boolean resultIsBeanShell) {
        DynamicThemeModificators.getInstance().ensureValidProperty(property);
        this.property = property;
        this.bsh = bsh;
        this.resultIsBeanShell = resultIsBeanShell;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        DynamicThemeModificators.getInstance().ensureValidProperty(property);
        DynamicThemeModificatorArgumentType type = DynamicThemeModificators.getInstance().getApplierType(property);
        if (!type.canBeBeanShell()) {
            this.resultIsBeanShell = false;
        }
        this.property = property;
    }

    public String getBsh() {
        return this.bsh;
    }

    public void setBsh(String bsh) {
        this.bsh = bsh;
    }

    public boolean isResultBeanShell() {
        return this.resultIsBeanShell;
    }

    public void setResultIsBeanShell(boolean resultIsBeanShell) {
        this.resultIsBeanShell = resultIsBeanShell;
    }

    public BiConsumer<BasicStyleModel, Object> getStyleApplier() {
        return DynamicThemeModificators.getInstance().getStyleApplier(this.property);
    }

    public DynamicThemeModificatorArgumentType getApplierType() {
        return DynamicThemeModificators.getInstance().getApplierType(this.property);
    }
}

