/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.style.theme;

import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.theme.ThemeModel;
import de.riwagis.riwajump.model.style.theme.ThemeSourceModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class BasicStaticThemeSourceModel<V>
extends ThemeSourceModel
implements Serializable {
    private List<ThemeModel> themes = new ArrayList<ThemeModel>();
    private BasicStyleModel defaultStyle;
    private String defaultLabel;
    private transient Map<V, ThemeModel> mapValue = null;
    private transient Map<Object, BasicStyleModel> mapStyle = null;
    private transient Map<Object, String> mapLabel = null;

    BasicStaticThemeSourceModel() {
    }

    BasicStaticThemeSourceModel(Map<Object, BasicStyleModel> attributeValueToBasicStyleMap, Map<Object, Object> attributeValueToLabelMap, BasicStyleModel defaultStyle) {
        for (Object key : attributeValueToBasicStyleMap.keySet()) {
            BasicStyleModel bSty = attributeValueToBasicStyleMap.get(key);
            String strLbl = Objects.toString(attributeValueToLabelMap.get(key), "");
            this.themes.add(new ThemeModel(key, strLbl, bSty));
        }
        this.setDefaultStyle(defaultStyle);
    }

    @Override
    public BasicStaticThemeSourceModel clone() throws CloneNotSupportedException {
        BasicStaticThemeSourceModel ctsClone = (BasicStaticThemeSourceModel)super.clone();
        if (this.defaultStyle != null) {
            ctsClone.setDefaultStyle(this.defaultStyle.clone());
        }
        if (this.themes != null) {
            ArrayList<ThemeModel> newThemes = new ArrayList<ThemeModel>();
            for (ThemeModel theme : this.themes) {
                newThemes.add(theme.clone());
            }
            ctsClone.themes = new ArrayList<ThemeModel>();
            ctsClone.clearCachedMaps();
            ctsClone.setThemes(newThemes);
        }
        return ctsClone;
    }

    public List<ThemeModel> getThemes() {
        return this.themes;
    }

    public void setThemes(List<ThemeModel> themes) {
        this.themes = new ArrayList<ThemeModel>(themes);
        this.clearCachedMaps();
        this.fireModelChanged("themes", this.getThemes());
    }

    @Override
    public BasicStyleModel getDefaultStyle() {
        return this.defaultStyle;
    }

    @Override
    public void setDefaultStyle(BasicStyleModel defaultStyle) {
        this.defaultStyle = defaultStyle;
        this.fireModelChanged("defaultStyle", defaultStyle);
    }

    @Override
    public String getDefaultLabel() {
        return this.defaultLabel;
    }

    @Override
    public void setDefaultLabel(String defaultLabel) {
        this.defaultLabel = defaultLabel;
        this.fireModelChanged("defaultLabel", defaultLabel);
    }

    public void clearCachedMaps() {
        this.mapValue = null;
        this.mapStyle = null;
        this.mapLabel = null;
    }

    public boolean addTheme(ThemeModel theme) {
        if (this.themes == null) {
            this.themes = new ArrayList<ThemeModel>();
        }
        if (this.themes.add(theme)) {
            this.fireModelChanged("themes_add", theme);
            return true;
        }
        return false;
    }

    public boolean removeTheme(ThemeModel theme) {
        if (this.themes == null) {
            this.themes = new ArrayList<ThemeModel>();
        }
        if (this.themes.remove(theme)) {
            this.fireModelChanged("themes_remove", theme);
            return true;
        }
        return false;
    }

    public void clearThemes() {
        if (this.themes != null) {
            this.themes.clear();
            this.fireModelChanged("themes_clear", null);
        }
    }

    @Override
    public void cleanUp() {
        if (this.getDefaultStyle() != null) {
            this.getDefaultStyle().cleanUp();
        }
        for (ThemeModel th : this.themes) {
            th.getStyle().cleanUp();
        }
    }

    public Map<Object, BasicStyleModel> getAttributeValueToBasicStyleMap() {
        if (this.mapStyle == null) {
            this.mapStyle = this.createMap();
            for (ThemeModel th : this.getThemes()) {
                this.mapStyle.put(th.getKey(), th.getStyle());
            }
        }
        return this.mapStyle;
    }

    public Map<Object, String> getAttributeValueToLabelMap() {
        if (this.mapLabel == null) {
            this.mapLabel = this.createMap();
            for (ThemeModel th : this.getThemes()) {
                this.mapLabel.put(th.getKey(), th.getLabel());
            }
        }
        return this.mapLabel;
    }

    protected Map<V, ThemeModel> getValueToThemeModelMap() {
        if (this.mapValue == null) {
            this.mapValue = this.createMap();
            for (ThemeModel th : this.getThemes()) {
                this.mapValue.put((ThemeModel)th.getKey(), th);
            }
        }
        return this.mapValue;
    }

    protected abstract <T, U> Map<T, U> createMap();

    public abstract ThemeModel getTheme4Object(Object var1);
}

