/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.style;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import de.riwagis.riwajump.model.style.ColorModel;
import de.riwagis.riwajump.model.style.StyleModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@XStreamAlias(value="wmsStyle")
public class WMSStyleModel
extends StyleModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ColorModel INITIAL_CLEAR_COLOR = new ColorModel(222, 22, 222, 0);
    private boolean enabled = true;
    private int alpha = 255;
    private String strServerURL = "";
    private String strVersion = "1.1.1";
    private String strFormat = "";
    private List<String> lstLayerNames = new ArrayList<String>();
    private List<String> lstLayerInvisible = new ArrayList<String>();
    private String strSRS = "";
    private ColorModel clearColor = INITIAL_CLEAR_COLOR;
    private boolean bolUseClearColor = false;
    private boolean serverNeedsLogin = false;
    private boolean hideWmsLayers = false;
    private String serverLoginName;
    private String serverLoginPwd;
    private String strFeatureInfoRegExp = null;
    private String strDefaultFeatureInfoCharset = null;
    private boolean ignoreFeatureInfo = false;

    private Object readResolve() {
        if (this.lstLayerInvisible == null) {
            this.lstLayerInvisible = new ArrayList<String>();
        }
        return this;
    }

    private void checkInvisibleLayernames() {
        ArrayList<String> lstLayer2Remove = new ArrayList<String>();
        for (String strLy : this.lstLayerInvisible) {
            if (this.lstLayerNames.contains(strLy)) continue;
            lstLayer2Remove.add(strLy);
        }
        for (String strLy : lstLayer2Remove) {
            this.lstLayerInvisible.remove(strLy);
        }
    }

    public List<String> getVisibleLayerNames() {
        ArrayList<String> visibleLayers = new ArrayList<String>();
        for (String layerName : this.getLstLayerNames()) {
            if (this.lstLayerInvisible != null && this.lstLayerInvisible.contains(layerName)) continue;
            visibleLayers.add(layerName);
        }
        return visibleLayers;
    }

    public List<String> getLstLayerNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.lstLayerNames));
    }

    public void setLayerNames(List<String> _lstLayerNames) {
        this.lstLayerNames.clear();
        this.lstLayerNames.addAll(_lstLayerNames);
        this.checkInvisibleLayernames();
        this.fireModelChanged("layernames", new ArrayList<String>(this.lstLayerNames));
    }

    public void addLayerName(String strLayerName) {
        if (!this.lstLayerNames.contains(strLayerName)) {
            this.lstLayerNames.add(strLayerName);
            this.fireModelChanged("layernames_add", strLayerName);
        }
    }

    public void addLayerInvisiblility(String strLayerName) {
        if (!this.lstLayerInvisible.contains(strLayerName) && this.lstLayerNames.contains(strLayerName)) {
            this.lstLayerInvisible.add(strLayerName);
            this.fireModelChanged("layersInvisible_add", strLayerName);
        }
    }

    public void removeLayerName(String strLayerName) {
        if (this.lstLayerNames.contains(strLayerName)) {
            this.lstLayerNames.remove(strLayerName);
            this.fireModelChanged("layernames_remove", strLayerName);
        }
    }

    public void removeLayerInvisiblility(String strLayerName) {
        if (this.lstLayerInvisible.contains(strLayerName)) {
            this.lstLayerInvisible.remove(strLayerName);
            this.fireModelChanged("layersInvisible_remove", strLayerName);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.fireModelChanged("enabled", enabled);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        this.fireModelChanged("alpha", alpha);
    }

    public String getServerURL() {
        return this.strServerURL;
    }

    public void setServerURL(String strServerURL) {
        this.strServerURL = strServerURL;
        this.fireModelChanged("serverURL", strServerURL);
    }

    public String getVersion() {
        return this.strVersion;
    }

    public void setVersion(String strVersion) {
        this.strVersion = strVersion;
        this.fireModelChanged("version", strVersion);
    }

    public String getFormat() {
        return this.strFormat;
    }

    public void setFormat(String strFormat) {
        this.strFormat = strFormat;
        this.fireModelChanged("format", strFormat);
    }

    public List<String> getLstLayerInvisible() {
        return Collections.unmodifiableList(this.lstLayerInvisible);
    }

    public void setLstLayerInvisible(List<String> lstLayerInvisible) {
        this.lstLayerInvisible = new ArrayList<String>(lstLayerInvisible);
        this.checkInvisibleLayernames();
        this.fireModelChanged("layersInvisible", Collections.unmodifiableList(this.lstLayerInvisible));
    }

    public String getSRS() {
        return this.strSRS;
    }

    public void setSRS(String strSRS) {
        this.strSRS = strSRS;
        this.fireModelChanged("srs", strSRS);
    }

    public ColorModel getClearColor() {
        return this.clearColor;
    }

    public void setClearColor(ColorModel clearColor) {
        this.clearColor = clearColor;
        this.fireModelChanged("clearColor", clearColor);
    }

    public boolean isUseClearColor() {
        return this.bolUseClearColor;
    }

    public void setUseClearColor(boolean bolUseClearColor) {
        this.bolUseClearColor = bolUseClearColor;
        this.fireModelChanged("bolUseClearColor", bolUseClearColor);
    }

    public boolean isServerNeedsLogin() {
        return this.serverNeedsLogin;
    }

    public void setServerNeedsLogin(boolean serverNeedsLogin) {
        this.serverNeedsLogin = serverNeedsLogin;
        this.fireModelChanged("serverNeedsLogin", serverNeedsLogin);
    }

    public boolean isHideWmsLayers() {
        return this.hideWmsLayers;
    }

    public void setHideWmsLayers(boolean hideWmsLayers) {
        this.hideWmsLayers = hideWmsLayers;
        this.fireModelChanged("hideWmsLayers", hideWmsLayers);
    }

    public String getServerLoginName() {
        return this.serverLoginName;
    }

    public void setServerLoginName(String serverLoginName) {
        this.serverLoginName = serverLoginName;
        this.fireModelChanged("serverLoginName", serverLoginName);
    }

    public String getServerLoginPwd() {
        return this.serverLoginPwd;
    }

    public void setServerLoginPwd(String serverLoginPwd) {
        this.serverLoginPwd = serverLoginPwd;
        this.fireModelChanged("serverLoginPwd", serverLoginPwd);
    }

    public String getFeatureInfoRegExp() {
        return this.strFeatureInfoRegExp;
    }

    public void setFeatureInfoRegExp(String strFeatureInfoRegExp) {
        this.strFeatureInfoRegExp = strFeatureInfoRegExp;
        this.fireModelChanged("strFeatureInfoRegExp", strFeatureInfoRegExp);
    }

    public String getDefaultFeatureInfoCharset() {
        return this.strDefaultFeatureInfoCharset;
    }

    public void setDefaultFeatureInfoCharset(String strDefaultFeatureInfoCharset) {
        this.strDefaultFeatureInfoCharset = strDefaultFeatureInfoCharset;
        this.fireModelChanged("strDefaultFeatureInfoCharset", strDefaultFeatureInfoCharset);
    }

    public boolean isIgnoreFeatureInfo() {
        return this.ignoreFeatureInfo;
    }

    public void setIgnoreFeatureInfo(boolean ignoreFeatureInfo) {
        this.ignoreFeatureInfo = ignoreFeatureInfo;
        this.fireModelChanged("ignoreFeatureInfo", ignoreFeatureInfo);
    }

    @Override
    public WMSStyleModel clone() throws CloneNotSupportedException {
        WMSStyleModel clonedModel = (WMSStyleModel)super.clone();
        clonedModel.lstLayerNames = new ArrayList<String>(this.lstLayerNames);
        ArrayList<String> newLayerInvisible = new ArrayList<String>();
        if (this.lstLayerInvisible != null && this.lstLayerInvisible.size() > 0) {
            newLayerInvisible.addAll(this.lstLayerInvisible);
        }
        clonedModel.setLstLayerInvisible(newLayerInvisible);
        return clonedModel;
    }

    @Override
    public void cleanUp() {
    }
}

