/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.style;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import de.riwagis.riwajump.model.JumpModel;
import de.riwagis.riwajump.model.layerable.AbstractLayerableModel;
import de.riwagis.riwajump.model.style.StyleModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@XStreamAlias(value="simpleSCol")
public class SimpleStyleCollectionModel
extends JumpModel
implements Serializable,
Comparable<SimpleStyleCollectionModel> {
    private static final long serialVersionUID = 1L;
    private List<StyleModel> lstStyles = new ArrayList<StyleModel>();
    private Double minScale = null;
    private Double maxScale = null;
    private boolean bolDefault = true;
    private transient AbstractLayerableModel layerable;

    public SimpleStyleCollectionModel() {
    }

    public SimpleStyleCollectionModel(boolean _bolDefault) {
        this.bolDefault = _bolDefault;
    }

    public AbstractLayerableModel getLayerable() {
        return this.layerable;
    }

    public void setLayerable(AbstractLayerableModel layerable) {
        this.layerable = layerable;
        this.fireModelChanged("layerable", layerable);
    }

    @Override
    public SimpleStyleCollectionModel clone() throws CloneNotSupportedException {
        SimpleStyleCollectionModel clon = (SimpleStyleCollectionModel)super.clone();
        ArrayList<StyleModel> clonLstStyles = new ArrayList<StyleModel>();
        if (this.lstStyles != null) {
            for (StyleModel style : this.lstStyles) {
                StyleModel clonedStyle = (StyleModel)style.clone();
                clonLstStyles.add(clonedStyle);
            }
        }
        clon.lstStyles = clonLstStyles;
        return clon;
    }

    public List<StyleModel> getLstStyles() {
        return Collections.unmodifiableList(this.lstStyles);
    }

    public StyleModel getStyle(Class<? extends StyleModel> styleClass) {
        for (StyleModel p : this.lstStyles) {
            if (!styleClass.isInstance(p)) continue;
            return p;
        }
        return null;
    }

    public boolean addStyle(StyleModel styleModel) {
        if (this.lstStyles.add(styleModel)) {
            this.fireModelChanged("styles_add", styleModel);
            return true;
        }
        return false;
    }

    public boolean removeStyle(StyleModel styleModel) {
        if (this.lstStyles.remove(styleModel)) {
            this.fireModelChanged("styles_remove", styleModel);
            return true;
        }
        return false;
    }

    public Double getMinScale() {
        return this.minScale;
    }

    public void setMinScale(Double minScale) {
        this.minScale = minScale;
        this.fireModelChanged("minScale", minScale);
    }

    public Double getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(Double maxScale) {
        this.maxScale = maxScale;
        this.fireModelChanged("maxScale", maxScale);
    }

    public boolean isBolDefault() {
        return this.bolDefault;
    }

    public void setBolDefault(boolean bolDefault) {
        this.bolDefault = bolDefault;
        this.fireModelChanged("bolDefault", bolDefault);
    }

    @Override
    public int compareTo(SimpleStyleCollectionModel _sCol) throws ClassCastException {
        if (!(_sCol instanceof SimpleStyleCollectionModel)) {
            throw new ClassCastException("SimpleStyleCollectionModel object expected.");
        }
        SimpleStyleCollectionModel sCol = _sCol;
        int scaleToCompare = 0;
        if (sCol.getMaxScale() != null) {
            scaleToCompare = (int)sCol.getMaxScale().doubleValue();
        }
        int scale = 0;
        if (this.getMaxScale() != null) {
            scale = (int)this.maxScale.doubleValue();
        }
        return scale - scaleToCompare;
    }
}

