/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.style;

import de.riwagis.riwajump.model.style.ColorModel;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.riwajump.model.util.ColorHelper;
import java.io.Serializable;

public class LineStyleModel
extends StyleModel
implements Serializable {
    private int intAlpha = 255;
    private boolean enabled = true;
    private boolean renderingLinePattern = false;
    private String lineWidth = "1";
    private ColorModel lineColor = ColorModel.RED;
    private String linePattern = null;
    private int lengthUnit = 0;

    @Override
    public LineStyleModel clone() throws CloneNotSupportedException {
        return (LineStyleModel)super.clone();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setIntAlpha(int intAlpha) {
        this.intAlpha = intAlpha;
        this.setLineColor(this.lineColor);
        this.fireModelChanged("intAlpha", intAlpha);
    }

    public int getIntAlpha() {
        return this.intAlpha;
    }

    public boolean isRenderingLinePattern() {
        return this.renderingLinePattern;
    }

    public void setRenderingLinePattern(boolean renderingLinePattern) {
        this.renderingLinePattern = renderingLinePattern;
        if (this.linePattern == null && renderingLinePattern) {
            this.setLinePattern("3");
        }
        this.fireModelChanged("renderingLinePattern", renderingLinePattern);
    }

    public String getLineWidth() {
        return this.lineWidth;
    }

    public float getLineWidthFloat() {
        try {
            return Float.parseFloat(this.lineWidth);
        }
        catch (Exception e) {
            return 1.0f;
        }
    }

    public final void setLineWidth(String lineWidth) {
        this.lineWidth = lineWidth;
        this.fireModelChanged("lineWidth", lineWidth);
    }

    public void setLineWidthFloat(float fltLineWidth) {
        this.setLineWidth("" + fltLineWidth);
    }

    public ColorModel getLineColor() {
        return ColorHelper.getAlphaColorModel(this.lineColor, 255);
    }

    public ColorModel getLineColorWithAlpha() {
        return this.lineColor;
    }

    public void setLineColor(ColorModel lineColor) {
        if (lineColor == null) {
            lineColor = ColorModel.RED;
        }
        this.lineColor = ColorHelper.getAlphaColorModel(lineColor, this.intAlpha);
        this.fireModelChanged("lineColor", lineColor);
    }

    public String getLinePattern() {
        return this.linePattern;
    }

    public LineStyleModel setLinePattern(String linePattern) {
        this.linePattern = linePattern;
        this.fireModelChanged("linePattern", linePattern);
        return this;
    }

    public int getLengthUnit() {
        return this.lengthUnit;
    }

    public void setLengthUnit(int lengthUnit) {
        this.lengthUnit = lengthUnit;
        this.fireModelChanged("lengthUnit", lengthUnit);
    }

    @Override
    public void cleanUp() {
        if (!this.renderingLinePattern) {
            this.linePattern = null;
        }
    }
}

