/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.style;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import de.riwagis.riwajump.model.style.ColorModel;
import de.riwagis.riwajump.model.style.FontModel;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.riwajump.model.style.TextStyleModel;
import de.riwagis.riwajump.model.util.ColorHelper;
import java.io.Serializable;

@XStreamAlias(value="dimStyle")
public class DimStyleModel
extends StyleModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int SYMBOL_ARROW = 0;
    public static final int SYMBOL_LINE = 1;
    public static final int SYMBOL_NONE = 2;
    public static final int UNIT_PIXEL = 0;
    public static final int UNIT_DRAWING_UNITS = 1;
    public static final int UNIT_DEGREE = 0;
    public static final int UNIT_GON = 1;
    public static final int DIM_RANGE = 0;
    public static final int DIM_ORDINATE = 1;
    public static final int DIM_ABSCISSA = 2;
    public static final int DIM_CHAINAGE = 3;
    private boolean enabled = true;
    private int lengthUnit = 1;
    private int oriUnit = 0;
    private int intAlpha = 255;
    private boolean bolRefLine = true;
    private boolean bolRefLinePattern = false;
    private String strRefLinePattern = null;
    private float fltRefLineWidth = 1.0f;
    private float fltRefLineOverDim = 0.0f;
    private ColorModel colorRefLine = new ColorModel(0, 0, 0, 255);
    private boolean bolDimLine = true;
    private boolean bolDimLinePattern = false;
    private String strDimLinePattern = null;
    private float fltDimLineWidth = 1.0f;
    private ColorModel colorDimLine = new ColorModel(0, 0, 0, 255);
    private boolean bolDimText = true;
    private float fltDimTextHeight = 10.0f;
    private boolean bolDimTextOpaque = false;
    private int intDimTextDecPlaces = 2;
    private FontModel fontDimText = new FontModel("Liberation Sans", 0, 12);
    private ColorModel colorDimText = new ColorModel(0, 0, 0, 255);
    private ColorModel colorDimTextOpaque = new ColorModel(0, 0, 0, 255);
    private boolean showTooltips = false;
    private TextStyleModel tooltipStyle = new TextStyleModel();
    private boolean bolShowSymbol = true;
    private int intSymbolType = 0;
    private float fltSymbolSize = 10.0f;

    private Object readResolve() {
        if (this.tooltipStyle == null) {
            this.tooltipStyle = new TextStyleModel();
        }
        return this;
    }

    @Override
    public DimStyleModel clone() throws CloneNotSupportedException {
        DimStyleModel clonedModel = (DimStyleModel)super.clone();
        if (this.fontDimText != null) {
            FontModel clonedFont = new FontModel(this.fontDimText.getName(), this.fontDimText.getStyle(), this.fontDimText.getSize());
            clonedModel.setFontDimText(clonedFont);
        }
        if (this.tooltipStyle != null) {
            clonedModel.setTooltipStyle(this.tooltipStyle.clone());
        }
        return clonedModel;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.fireModelChanged("enabled", enabled);
    }

    public int getLengthUnit() {
        return this.lengthUnit;
    }

    public void setLengthUnit(int lengthUnit) {
        this.lengthUnit = lengthUnit;
        this.fireModelChanged("lengthUnit", lengthUnit);
    }

    public int getOriUnit() {
        return this.oriUnit;
    }

    public void setOriUnit(int oriUnit) {
        this.oriUnit = oriUnit;
        this.fireModelChanged("oriUnit", oriUnit);
    }

    public int getIntAlpha() {
        return this.intAlpha;
    }

    public void setIntAlpha(int intAlpha) {
        this.intAlpha = intAlpha;
        if (this.colorDimLine != null) {
            this.colorDimLine = ColorHelper.getAlphaColorModel(this.colorDimLine, intAlpha);
        }
        if (this.colorRefLine != null) {
            this.colorRefLine = ColorHelper.getAlphaColorModel(this.colorRefLine, intAlpha);
        }
        if (this.colorDimText != null) {
            this.colorDimText = ColorHelper.getAlphaColorModel(this.colorDimText, intAlpha);
        }
        if (this.colorDimTextOpaque != null) {
            this.colorDimTextOpaque = ColorHelper.getAlphaColorModel(this.colorDimTextOpaque, intAlpha);
        }
        this.fireModelChanged("intAlpha", intAlpha);
    }

    public boolean isBolRefLine() {
        return this.bolRefLine;
    }

    public void setBolRefLine(boolean bolRefLine) {
        this.bolRefLine = bolRefLine;
        this.fireModelChanged("bolRefLine", bolRefLine);
    }

    public boolean isBolRefLinePattern() {
        return this.bolRefLinePattern;
    }

    public void setBolRefLinePattern(boolean bolRefLinePattern) {
        this.bolRefLinePattern = bolRefLinePattern;
        this.fireModelChanged("bolRefLinePattern", bolRefLinePattern);
    }

    public String getStrRefLinePattern() {
        return this.strRefLinePattern;
    }

    public void setStrRefLinePattern(String strRefLinePattern) {
        this.strRefLinePattern = strRefLinePattern;
        this.fireModelChanged("strRefLinePattern", strRefLinePattern);
    }

    public float getFltRefLineWidth() {
        return this.fltRefLineWidth;
    }

    public void setFltRefLineWidth(float fltRefLineWidth) {
        if (this.fltRefLineWidth != fltRefLineWidth) {
            this.fltRefLineWidth = fltRefLineWidth;
            this.fireModelChanged("fltRefLineWidth", Float.valueOf(fltRefLineWidth));
        }
    }

    public float getFltRefLineOverDim() {
        return this.fltRefLineOverDim;
    }

    public void setFltRefLineOverDim(float fltRefLineOverDim) {
        this.fltRefLineOverDim = fltRefLineOverDim;
        this.fireModelChanged("fltRefLineOverDim", Float.valueOf(fltRefLineOverDim));
    }

    public ColorModel getColorRefLine() {
        return this.colorRefLine;
    }

    public void setColorRefLine(ColorModel colorRefLine) {
        this.colorRefLine = ColorHelper.getAlphaColorModel(colorRefLine, this.intAlpha);
        this.fireModelChanged("colorRefLine", colorRefLine);
    }

    public boolean isBolDimLine() {
        return this.bolDimLine;
    }

    public void setBolDimLine(boolean bolDimLine) {
        this.bolDimLine = bolDimLine;
        this.fireModelChanged("bolDimLine", bolDimLine);
    }

    public boolean isBolDimLinePattern() {
        return this.bolDimLinePattern;
    }

    public void setBolDimLinePattern(boolean bolDimLinePattern) {
        this.bolDimLinePattern = bolDimLinePattern;
        this.fireModelChanged("bolDimLinePattern", bolDimLinePattern);
    }

    public String getStrDimLinePattern() {
        return this.strDimLinePattern;
    }

    public void setStrDimLinePattern(String strDimLinePattern) {
        this.strDimLinePattern = strDimLinePattern;
        this.fireModelChanged("strDimLinePattern", strDimLinePattern);
    }

    public float getFltDimLineWidth() {
        return this.fltDimLineWidth;
    }

    public void setFltDimLineWidth(float fltDimLineWidth) {
        if (this.fltDimLineWidth != fltDimLineWidth) {
            this.fltDimLineWidth = fltDimLineWidth;
            this.fireModelChanged("fltDimLineWidth", Float.valueOf(fltDimLineWidth));
        }
    }

    public ColorModel getColorDimLine() {
        return this.colorDimLine;
    }

    public void setColorDimLine(ColorModel colorDimLine) {
        this.colorDimLine = ColorHelper.getAlphaColorModel(colorDimLine, this.intAlpha);
        this.fireModelChanged("colorDimLine", colorDimLine);
    }

    public boolean isBolDimText() {
        return this.bolDimText;
    }

    public void setBolDimText(boolean bolDimText) {
        this.bolDimText = bolDimText;
        this.fireModelChanged("bolDimText", bolDimText);
    }

    public float getFltDimTextHeight() {
        return this.fltDimTextHeight;
    }

    public void setFltDimTextHeight(float fltDimTextHeight) {
        this.fltDimTextHeight = fltDimTextHeight;
        this.fireModelChanged("fltDimTextHeight", Float.valueOf(fltDimTextHeight));
    }

    public boolean isBolDimTextOpaque() {
        return this.bolDimTextOpaque;
    }

    public void setBolDimTextOpaque(boolean bolDimTextOpaque) {
        this.bolDimTextOpaque = bolDimTextOpaque;
        this.fireModelChanged("bolDimTextOpaque", bolDimTextOpaque);
    }

    public int getIntDimTextDecPlaces() {
        return this.intDimTextDecPlaces;
    }

    public void setIntDimTextDecPlaces(int intDimTextDecPlaces) {
        this.intDimTextDecPlaces = intDimTextDecPlaces;
        this.fireModelChanged("intDimTextDecPlaces", intDimTextDecPlaces);
    }

    public FontModel getFontDimText() {
        return this.fontDimText;
    }

    public void setFontDimText(FontModel fontDimText) {
        this.fontDimText = fontDimText;
        this.fireModelChanged("fontDimText", fontDimText);
    }

    public ColorModel getColorDimText() {
        return this.colorDimText;
    }

    public void setColorDimText(ColorModel colorDimText) {
        this.colorDimText = ColorHelper.getAlphaColorModel(colorDimText, this.intAlpha);
        this.fireModelChanged("colorDimText", colorDimText);
    }

    public ColorModel getColorDimTextOpaque() {
        return this.colorDimTextOpaque;
    }

    public void setColorDimTextOpaque(ColorModel colorDimTextOpaque) {
        this.colorDimTextOpaque = ColorHelper.getAlphaColorModel(colorDimTextOpaque, this.intAlpha);
        this.fireModelChanged("colorDimTextOpaque", colorDimTextOpaque);
    }

    public boolean isShowTooltips() {
        return this.showTooltips;
    }

    public void setShowTooltips(boolean showTooltips) {
        this.showTooltips = showTooltips;
        if (this.tooltipStyle == null && showTooltips) {
            this.tooltipStyle = new TextStyleModel();
        }
        this.fireModelChanged("showTooltips", showTooltips);
    }

    public TextStyleModel getTooltipStyle() {
        return this.tooltipStyle;
    }

    public void setTooltipStyle(TextStyleModel tooltipStyle) {
        this.tooltipStyle = tooltipStyle;
        this.fireModelChanged("tooltipStyle", tooltipStyle);
    }

    public boolean isBolShowSymbol() {
        return this.bolShowSymbol;
    }

    public void setBolShowSymbol(boolean bolShowSymbol) {
        this.bolShowSymbol = bolShowSymbol;
        this.fireModelChanged("bolShowSymbol", bolShowSymbol);
    }

    public int getIntSymbolType() {
        return this.intSymbolType;
    }

    public void setIntSymbolType(int intSymbolType) {
        this.intSymbolType = intSymbolType;
        this.fireModelChanged("intSymbolType", intSymbolType);
    }

    public float getFltSymbolSize() {
        return this.fltSymbolSize;
    }

    public void setFltSymbolSize(float fltSymbolSize) {
        this.fltSymbolSize = fltSymbolSize;
        this.fireModelChanged("fltSymbolSize", Float.valueOf(fltSymbolSize));
    }

    @Override
    public void cleanUp() {
        if (!this.showTooltips) {
            this.tooltipStyle = null;
        }
        if (this.tooltipStyle != null) {
            this.tooltipStyle.cleanUp();
        }
    }
}

