/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.style;

import de.riwagis.riwajump.model.JumpModel;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public final class ColorModel
extends JumpModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ColorModel BLACK = new ColorModel(0, 0, 0, 255);
    public static final ColorModel WHITE = new ColorModel(255, 255, 255, 255);
    public static final ColorModel BLUE = new ColorModel(0, 0, 255, 255);
    public static final ColorModel GREEN = new ColorModel(0, 255, 0, 255);
    public static final ColorModel RED = new ColorModel(255, 0, 0, 255);
    private final int red;
    private final int green;
    private final int blue;
    private final int alpha;
    private final String bsh;

    public ColorModel() {
        this(0, 0, 0, 255);
    }

    public ColorModel(int red, int green, int blue) {
        this(red, green, blue, 255);
    }

    public ColorModel(int red, int green, int blue, int alpha, String bsh) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        this.bsh = bsh;
    }

    public ColorModel(int red, int green, int blue, int alpha) {
        this(red, green, blue, alpha, null);
    }

    public ColorModel(String bsh) {
        this(0, 0, 0, 255, bsh);
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public String getBsh() {
        return this.bsh;
    }

    public boolean isBshColor() {
        return StringUtils.isNotBlank((CharSequence)this.bsh);
    }

    @Override
    public ColorModel clone() throws CloneNotSupportedException {
        return (ColorModel)super.clone();
    }
}

