/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.style;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import de.riwagis.riwajump.model.style.ColorModel;
import de.riwagis.riwajump.model.style.LineStyleModel;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.riwajump.model.style.SymbolStyleModel;
import de.riwagis.riwajump.model.style.TextStyleModel;
import de.riwagis.riwajump.model.util.ColorHelper;
import java.io.Serializable;

@XStreamAlias(value="basicStyle")
public class BasicStyleModel
extends StyleModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean renderingFill = true;
    private boolean renderingFillPattern = false;
    private boolean selectPolygonAsLine = false;
    private String strFillSymStore = null;
    private String strFillSymName = null;
    private String strFillSymWidth = "10";
    private boolean bolFillSymColorOverwrite = true;
    private boolean bolUseAlphaArea = true;
    private boolean bolUseAlphaLine = true;
    private boolean bolUseAlphaText = false;
    private boolean bolUseAlphaSymbol = false;
    private int intAlpha = 255;
    private ColorModel fillColor = new ColorModel(0, 0, 0, 255);
    private boolean enabled = true;
    private LineStyleModel lineForeground = null;
    private LineStyleModel lineBase = new LineStyleModel();
    private LineStyleModel lineBackground = null;
    private int lengthUnit = 0;
    private int oriUnit = 0;
    private boolean showTooltips = false;
    private TextStyleModel tooltipStyle = null;
    private boolean renderingText = false;
    private TextStyleModel textStyle = null;
    private boolean renderingSymbol = false;
    private SymbolStyleModel symStyle = null;
    private boolean bolUseUrl = false;
    private String strUrl = null;

    public BasicStyleModel() {
    }

    public BasicStyleModel(ColorModel fillColor) {
        this.setFillColor(fillColor);
        this.lineBase.setLineColor(fillColor);
        this.lineBase.setLineWidth("1");
    }

    private SymbolStyleModel createSymStyle() {
        SymbolStyleModel sSty = new SymbolStyleModel();
        sSty.setIntUnitSize(this.lengthUnit);
        sSty.setIntUnitSizeSymbol(this.lengthUnit);
        sSty.setIntUnitAngle(this.oriUnit);
        return sSty;
    }

    private TextStyleModel createTextStyle() {
        TextStyleModel tSty = new TextStyleModel();
        tSty.setIntUnitLength(this.lengthUnit);
        tSty.setIntUnitOrient(this.oriUnit);
        return tSty;
    }

    public boolean isRenderingFill() {
        return this.renderingFill;
    }

    public void setRenderingFill(boolean renderingFill) {
        this.renderingFill = renderingFill;
        this.fireModelChanged("renderingFill", renderingFill);
    }

    public boolean isRenderingFillPattern() {
        return this.renderingFillPattern;
    }

    public BasicStyleModel setRenderingFillPattern(boolean renderingFillPattern) {
        this.renderingFillPattern = renderingFillPattern;
        this.fireModelChanged("renderingFillPattern", renderingFillPattern);
        return this;
    }

    public boolean isSelectPolygonAsLine() {
        return this.selectPolygonAsLine;
    }

    public void setSelectPolygonAsLine(boolean selectPolygonAsLine) {
        this.selectPolygonAsLine = selectPolygonAsLine;
        this.fireModelChanged("selectPolygonAsLine", selectPolygonAsLine);
    }

    public String getStrFillSymStore() {
        return this.strFillSymStore;
    }

    public void setStrFillSymStore(String strFillSymStore) {
        this.strFillSymStore = strFillSymStore;
        this.fireModelChanged("strFillSymStore", strFillSymStore);
    }

    public String getStrFillSymName() {
        return this.strFillSymName;
    }

    public void setStrFillSymName(String strFillSymName) {
        this.strFillSymName = strFillSymName;
        this.fireModelChanged("strFillSymName", strFillSymName);
    }

    public String getFillSymWidth() {
        return this.strFillSymWidth;
    }

    public void setFillSymWidth(String strFillSymWidth) {
        this.strFillSymWidth = strFillSymWidth;
        this.fireModelChanged("strFillSymWidth", strFillSymWidth);
    }

    public boolean isBolFillSymColorOverwrite() {
        return this.bolFillSymColorOverwrite;
    }

    public void setBolFillSymColorOverwrite(boolean bolFillSymColorOverwrite) {
        this.bolFillSymColorOverwrite = bolFillSymColorOverwrite;
        this.fireModelChanged("bolFillSymColorOverwrite", bolFillSymColorOverwrite);
    }

    public boolean isBolUseAlphaArea() {
        return this.bolUseAlphaArea;
    }

    public void setBolUseAlphaArea(boolean bolUseAlphaArea) {
        this.bolUseAlphaArea = bolUseAlphaArea;
        this.setIntAlpha(this.intAlpha);
        this.fireModelChanged("bolUseAlphaArea", bolUseAlphaArea);
    }

    public boolean isBolUseAlphaLine() {
        return this.bolUseAlphaLine;
    }

    public void setBolUseAlphaLine(boolean bolUseAlphaLine) {
        this.bolUseAlphaLine = bolUseAlphaLine;
        this.setIntAlpha(this.intAlpha);
        this.fireModelChanged("bolUseAlphaLine", bolUseAlphaLine);
    }

    public boolean isBolUseAlphaText() {
        return this.bolUseAlphaText;
    }

    public void setBolUseAlphaText(boolean bolUseAlphaText) {
        this.bolUseAlphaText = bolUseAlphaText;
        this.setTextColor();
        this.fireModelChanged("bolUseAlphaText", bolUseAlphaText);
    }

    public boolean isBolUseAlphaSymbol() {
        return this.bolUseAlphaSymbol;
    }

    public void setBolUseAlphaSymbol(boolean bolUseAlphaSymbol) {
        this.bolUseAlphaSymbol = bolUseAlphaSymbol;
        this.setSymbolColor();
        this.fireModelChanged("bolUseAlphaSymbol", bolUseAlphaSymbol);
    }

    public int getIntAlpha() {
        return this.intAlpha;
    }

    public void setIntAlpha(int alpha, boolean bolArea, boolean bolLine, boolean bolText, boolean bolSymbol) {
        this.setIntAlpha(alpha);
        this.setBolUseAlphaArea(bolArea);
        this.setBolUseAlphaLine(bolLine);
        this.setBolUseAlphaText(bolText);
        this.setBolUseAlphaSymbol(bolSymbol);
    }

    public void setIntAlpha(int intAlpha) {
        int intLineAlpha;
        this.intAlpha = intAlpha;
        this.setFillColor(this.fillColor);
        int n = intLineAlpha = this.isBolUseAlphaLine() ? intAlpha : 255;
        if (this.lineBackground != null) {
            this.lineBackground.setIntAlpha(intLineAlpha);
        }
        if (this.lineBase != null) {
            this.lineBase.setIntAlpha(intLineAlpha);
        }
        if (this.lineForeground != null) {
            this.lineForeground.setIntAlpha(intLineAlpha);
        }
        this.setTextColor();
        this.setSymbolColor();
        this.fireModelChanged("intAlpha", intAlpha);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.fireModelChanged("enabled", enabled);
    }

    public int getLengthUnit() {
        return this.lengthUnit;
    }

    public void setLengthUnit(int lengthUnit) {
        this.lengthUnit = lengthUnit;
        if (this.lineForeground != null) {
            this.lineForeground.setLengthUnit(lengthUnit);
        }
        if (this.lineBase != null) {
            this.lineBase.setLengthUnit(lengthUnit);
        }
        if (this.lineBackground != null) {
            this.lineBackground.setLengthUnit(lengthUnit);
        }
        this.fireModelChanged("lengthUnit", lengthUnit);
    }

    public int getOriUnit() {
        return this.oriUnit;
    }

    public void setOriUnit(int oriUnit) {
        this.oriUnit = oriUnit;
        this.fireModelChanged("oriUnit", oriUnit);
    }

    public boolean isShowTooltips() {
        return this.showTooltips;
    }

    public void setShowTooltips(boolean showTooltips) {
        this.showTooltips = showTooltips;
        if (this.tooltipStyle == null && showTooltips) {
            this.setTooltipStyle(new TextStyleModel());
        }
        this.fireModelChanged("showTooltips", showTooltips);
    }

    public boolean isRenderingText() {
        return this.renderingText;
    }

    public void setRenderingText(boolean renderingText) {
        this.renderingText = renderingText;
        if (this.textStyle == null && renderingText) {
            this.textStyle = this.createTextStyle();
        }
        this.setTextColor();
        this.fireModelChanged("renderingText", renderingText);
    }

    public boolean isRenderingSymbol() {
        return this.renderingSymbol;
    }

    public void setRenderingSymbol(boolean renderingSymbol) {
        this.renderingSymbol = renderingSymbol;
        if (this.symStyle == null && renderingSymbol) {
            this.symStyle = this.createSymStyle();
        }
        this.setSymbolColor();
        this.fireModelChanged("renderingSymbol", renderingSymbol);
    }

    public boolean isUseUrl() {
        return this.bolUseUrl;
    }

    public void setUseUrl(boolean bolUseUrl) {
        this.bolUseUrl = bolUseUrl;
        this.fireModelChanged("useUrl", bolUseUrl);
    }

    public String getUrl() {
        return this.strUrl;
    }

    public void setUrl(String strUrl) {
        this.strUrl = strUrl;
        this.fireModelChanged("url", strUrl);
    }

    public boolean doesRenderLine() {
        return this.lineBase != null || this.lineBackground != null || this.lineForeground != null;
    }

    public LineStyleModel retrieveLeadingLineStyle() {
        if (this.lineBase != null) {
            return this.lineBase;
        }
        if (this.lineForeground != null) {
            return this.lineForeground;
        }
        return this.lineBackground;
    }

    public LineStyleModel getLineForeground() {
        return this.lineForeground;
    }

    public void setLineForeground(LineStyleModel _lineForeground) {
        if (_lineForeground != null) {
            this.lineForeground = (LineStyleModel)_lineForeground.cloneModel();
            this.lineForeground.setLengthUnit(this.lengthUnit);
            this.lineForeground.setIntAlpha(this.isBolUseAlphaLine() ? this.intAlpha : 255);
        } else {
            this.lineForeground = null;
        }
        this.fireModelChanged("lineForeground", this.lineForeground);
    }

    public LineStyleModel getLineBase() {
        return this.lineBase;
    }

    public void setLineBase(LineStyleModel _lineBase) {
        if (_lineBase != null) {
            this.lineBase = (LineStyleModel)_lineBase.cloneModel();
            this.lineBase.setLengthUnit(this.lengthUnit);
            this.lineBase.setIntAlpha(this.isBolUseAlphaLine() ? this.intAlpha : 255);
        } else {
            this.lineBase = null;
        }
        this.fireModelChanged("lineBase", this.lineBase);
    }

    public LineStyleModel getLineBackground() {
        return this.lineBackground;
    }

    public void setLineBackground(LineStyleModel _lineBackground) {
        if (_lineBackground != null) {
            this.lineBackground = _lineBackground;
            this.lineBackground.setLengthUnit(this.lengthUnit);
            this.lineBackground.setIntAlpha(this.isBolUseAlphaLine() ? this.intAlpha : 255);
        } else {
            this.lineBackground = null;
        }
        this.fireModelChanged("lineBackground", this.lineBackground);
    }

    public ColorModel getFillColor() {
        return ColorHelper.getAlphaColorModel(this.fillColor, 255);
    }

    public ColorModel getFillColorWithAlpha() {
        return this.fillColor;
    }

    public final void setFillColor(ColorModel fillColor) {
        this.fillColor = this.bolUseAlphaArea ? ColorHelper.getAlphaColorModel(fillColor, this.intAlpha) : ColorHelper.getAlphaColorModel(fillColor, 255);
        this.fireModelChanged("fillColor", fillColor);
    }

    private void setTextColor() {
        if (this.textStyle != null && this.renderingText) {
            if (this.bolUseAlphaText) {
                this.textStyle.setColorOpaque(ColorHelper.getAlphaColorModel(this.textStyle.getColorOpaque(), this.intAlpha));
                this.textStyle.setColorText(ColorHelper.getAlphaColorModel(this.textStyle.getColorText(), this.intAlpha));
            } else {
                this.textStyle.setColorOpaque(ColorHelper.getAlphaColorModel(this.textStyle.getColorOpaque(), 255));
                this.textStyle.setColorText(ColorHelper.getAlphaColorModel(this.textStyle.getColorText(), 255));
            }
        }
    }

    private void setSymbolColor() {
        if (this.symStyle != null && this.renderingSymbol) {
            if (this.bolUseAlphaSymbol) {
                this.symStyle.setFillColor(ColorHelper.getAlphaColorModel(this.symStyle.getFillColor(), this.intAlpha));
                this.symStyle.setLineColor(ColorHelper.getAlphaColorModel(this.symStyle.getLineColor(), this.intAlpha));
            } else {
                this.symStyle.setFillColor(ColorHelper.getAlphaColorModel(this.symStyle.getFillColor(), 255));
                this.symStyle.setLineColor(ColorHelper.getAlphaColorModel(this.symStyle.getLineColor(), 255));
            }
        }
    }

    public TextStyleModel getTooltipStyle() {
        return this.tooltipStyle;
    }

    public void setTooltipStyle(TextStyleModel tooltipStyle) {
        this.tooltipStyle = tooltipStyle;
        this.fireModelChanged("tooltipStyle", tooltipStyle);
    }

    public TextStyleModel getTextStyle() {
        return this.textStyle;
    }

    public void setTextStyle(TextStyleModel textStyle) {
        this.textStyle = textStyle;
        this.setTextColor();
        this.fireModelChanged("textStyle", textStyle);
    }

    public SymbolStyleModel getSymStyle() {
        return this.symStyle;
    }

    public void setSymStyle(SymbolStyleModel symStyle) {
        this.symStyle = symStyle;
        this.setSymbolColor();
        this.fireModelChanged("symStyle", symStyle);
    }

    @Override
    public BasicStyleModel clone() throws CloneNotSupportedException {
        BasicStyleModel klon = (BasicStyleModel)super.clone();
        if (this.tooltipStyle != null) {
            klon.setTooltipStyle(this.tooltipStyle.clone());
        }
        if (this.textStyle != null) {
            klon.setTextStyle(this.textStyle.clone());
        }
        if (this.symStyle != null) {
            klon.setSymStyle(this.symStyle.clone());
        }
        if (this.lineForeground != null) {
            klon.setLineForeground(this.lineForeground.clone());
        }
        if (this.lineBase != null) {
            klon.setLineBase(this.lineBase.clone());
        }
        if (this.lineBackground != null) {
            klon.setLineBackground(this.lineBackground.clone());
        }
        return klon;
    }

    @Override
    public void cleanUp() {
        if (!this.renderingSymbol) {
            this.symStyle = null;
        }
        if (!this.renderingText) {
            this.textStyle = null;
        }
        if (!this.showTooltips) {
            this.tooltipStyle = null;
        }
        if (!this.renderingFill || !this.renderingFillPattern) {
            this.strFillSymName = null;
            this.strFillSymStore = null;
        }
    }
}

