/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.search;

import java.util.Objects;
import java.util.function.Function;

public enum WildcardSearchEnum {
    NO_WILDCARD("none", s -> Objects.toString(s, "")),
    WILDCARD_LEADING("leading", s -> "%" + Objects.toString(s, "")),
    WILDCARD_TRAILING("trailing", s -> Objects.toString(s, "") + "%"),
    WILDCARD_LEADING_AND_TRAILING("both", s -> "%" + Objects.toString(s, "") + "%");

    private final String value;
    private final Function<String, String> adjustSearchFunc;

    private WildcardSearchEnum(String value, Function<String, String> adjustSearchFunc) {
        this.value = value;
        this.adjustSearchFunc = Objects.requireNonNull(adjustSearchFunc);
    }

    public String getValue() {
        return this.value;
    }

    public String adjustSearchString(String s) {
        return this.adjustSearchFunc.apply(s);
    }

    public static WildcardSearchEnum byValue(String value) throws IllegalArgumentException {
        if (value == null || value.isBlank()) {
            return WILDCARD_TRAILING;
        }
        for (WildcardSearchEnum wildcard : WildcardSearchEnum.values()) {
            if (!Objects.equals(wildcard.getValue(), value)) continue;
            return wildcard;
        }
        throw new IllegalArgumentException("No enum constant with value " + value);
    }
}

