/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.search;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import de.riwagis.riwajump.model.JumpModel;
import de.riwagis.riwajump.model.search.SearchModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@XStreamAlias(value="searchcol")
public class SearchCollectionModel
extends JumpModel
implements Serializable,
Iterable<SearchModel> {
    private static final long serialVersionUID = 1L;
    @XStreamAlias(value="searchlist")
    private List<SearchModel> lstSearch = new ArrayList<SearchModel>();

    @Override
    public SearchCollectionModel clone() throws CloneNotSupportedException {
        SearchCollectionModel clonedModel = (SearchCollectionModel)super.clone();
        clonedModel.lstSearch = new ArrayList<SearchModel>();
        for (SearchModel searchModel : this.lstSearch) {
            clonedModel.lstSearch.add(searchModel.clone());
        }
        return clonedModel;
    }

    @Override
    public Iterator<SearchModel> iterator() {
        return this.lstSearch.iterator();
    }

    public int size() {
        return this.lstSearch.size();
    }

    public boolean isEmpty() {
        return this.lstSearch.isEmpty();
    }

    public SearchModel get(int index) {
        return this.lstSearch.get(index);
    }

    public SearchModel getByName(String name) {
        for (SearchModel currSearch : this.lstSearch) {
            if (!currSearch.getName().equals(name)) continue;
            return currSearch;
        }
        return null;
    }

    public List<SearchModel> getInternalList() {
        return this.lstSearch;
    }

    public void addSearches(SearchCollectionModel scm) {
        if (scm != null) {
            this.lstSearch.addAll(scm.lstSearch);
            this.fireModelChanged("seraches_addall", scm);
        }
    }

    public int addSearch(SearchModel aModel) {
        if (this.lstSearch.add(aModel)) {
            this.sortList();
            this.fireModelChanged("searches_add", aModel);
            return this.lstSearch.indexOf(aModel);
        }
        return -1;
    }

    public void addSearch(int index, SearchModel searchModel) {
        this.lstSearch.add(index, searchModel);
        this.fireModelChanged("searches_add", searchModel);
    }

    public void replaceSearch(SearchModel oldSearch, SearchModel newSearch) {
        if (this.lstSearch.contains(oldSearch)) {
            this.removeSearch(oldSearch);
            this.addSearch(newSearch);
        }
    }

    public boolean removeSearch(SearchModel aModel) {
        if (this.lstSearch.remove(aModel)) {
            this.fireModelChanged("searches_remove", aModel);
            return true;
        }
        return false;
    }

    public void clearSearch() {
        this.lstSearch.clear();
        this.fireModelChanged("searches_clear", null);
    }

    public void sortList() {
        Collections.sort(this.lstSearch);
    }
}

