/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.search;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import de.riwagis.riwajump.model.search.SearchInputModel;
import de.riwagis.riwajump.model.search.SearchModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@XStreamAlias(value="rsearch")
public class RootSearchModel
extends SearchModel {
    private static final long serialVersionUID = 1L;
    @XStreamAlias(value="inputs")
    private List<SearchInputModel> inputs = new ArrayList<SearchInputModel>();
    @XStreamAlias(value="subsearches")
    private List<SearchModel> subSearches = new ArrayList<SearchModel>();
    @XStreamAlias(value="layers")
    private List<String> layers = new ArrayList<String>();
    @XStreamAlias(value="store")
    private String datastore = "";
    @XStreamAlias(value="scale")
    private int scale = 500;
    @XStreamAlias(value="bshSearchTable")
    private String bshSearchTable = "";

    private Object readResolve() {
        for (SearchModel s : this.subSearches) {
            s.setRootSearchModel(this);
        }
        return this;
    }

    @Override
    public RootSearchModel clone() throws CloneNotSupportedException {
        RootSearchModel clone = (RootSearchModel)super.clone();
        if (this.inputs != null) {
            ArrayList<SearchInputModel> clonedInputs = new ArrayList<SearchInputModel>();
            for (SearchInputModel oldSearchInputModel : this.inputs) {
                clonedInputs.add(oldSearchInputModel.clone());
            }
            clone.inputs = clonedInputs;
        }
        if (this.subSearches != null) {
            ArrayList<SearchModel> clonedSubSearches = new ArrayList<SearchModel>();
            for (SearchModel oldSearchModel : this.subSearches) {
                SearchModel clonedSubSearch = oldSearchModel.clone();
                clonedSubSearch.setRootSearchModel(clone);
                clonedSubSearches.add(clonedSubSearch);
            }
            clone.subSearches = clonedSubSearches;
        }
        return clone;
    }

    public List<SearchInputModel> getInput() {
        return this.inputs;
    }

    public void setInput(List<SearchInputModel> inputs) {
        this.inputs = new ArrayList<SearchInputModel>(inputs);
        this.fireModelChanged("inputs", new ArrayList<SearchInputModel>(inputs));
    }

    public boolean addInputField(SearchInputModel model) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<SearchInputModel>();
        }
        if (this.inputs.add(model)) {
            this.fireModelChanged("inputs_add", model);
            return true;
        }
        return false;
    }

    public boolean removeInputField(SearchInputModel model) {
        if (this.inputs != null && this.inputs.remove(model)) {
            this.fireModelChanged("inputs_remove", model);
            return true;
        }
        return false;
    }

    public List<SearchModel> getSubSearches() {
        return Collections.unmodifiableList(this.subSearches);
    }

    public void setSubSearches(List<SearchModel> subSearches) {
        this.subSearches = new ArrayList<SearchModel>(subSearches);
        this.fireModelChanged("subSearches", Collections.unmodifiableList(this.subSearches));
    }

    public List<String> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public void setLayers(List<String> layers) {
        this.layers = new ArrayList<String>(layers);
        this.fireModelChanged("layers", Collections.unmodifiableList(this.layers));
    }

    public String getDatastore() {
        return this.datastore;
    }

    public void setDatastore(String datastore) {
        this.datastore = datastore;
        this.fireModelChanged("datastore", datastore);
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
        this.fireModelChanged("scale", scale);
    }

    public String getBshSearchTable() {
        return this.bshSearchTable;
    }

    public void setBshSearchTable(String bshSearchTable) {
        this.bshSearchTable = bshSearchTable;
        this.fireModelChanged("bshSearchTable", bshSearchTable);
    }

    @Override
    public RootSearchModel getRootSearchModel() {
        return this;
    }

    @Override
    public void setRootSearchModel(RootSearchModel model) {
        throw new UnsupportedOperationException("Object is of type RootSearchModel. Not possible to set parent search.");
    }
}

