/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.layerable;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import de.riwagis.riwajump.model.JumpModel;
import de.riwagis.riwajump.model.LayerManagerModel;
import de.riwagis.riwajump.model.layerable.AbstractLayerableModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@XStreamAlias(value="cat")
public class CategoryModel
extends JumpModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<AbstractLayerableModel> layerables = new ArrayList<AbstractLayerableModel>();
    private List<CategoryModel> subcategories = new ArrayList<CategoryModel>();
    private String name;
    private String description;
    private boolean visible = true;
    private transient LayerManagerModel layerManager;
    private transient CategoryModel parentCategory;

    public CategoryModel getParentCategory() {
        return this.parentCategory;
    }

    public void setParentCategory(CategoryModel parentCat) {
        this.parentCategory = parentCat;
        this.fireModelChanged("parentCategory", this.parentCategory);
    }

    public void setLayerManager(LayerManagerModel layerManager) {
        this.layerManager = layerManager;
        List<CategoryModel> lstCat = this.getSubcategories();
        for (CategoryModel tmpcat : lstCat) {
            tmpcat.setLayerManager(layerManager);
        }
        List<AbstractLayerableModel> lstLayers = this.getLayerables();
        for (AbstractLayerableModel tmplyr : lstLayers) {
            tmplyr.setLayerManager(layerManager);
        }
        this.fireModelChanged("layerManager", layerManager);
    }

    public LayerManagerModel getLayerManager() {
        return this.layerManager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fireModelChanged("name", name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fireModelChanged("description", description);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.fireModelChanged("visible", visible);
    }

    public List<AbstractLayerableModel> getLayerables() {
        return Collections.unmodifiableList(this.layerables);
    }

    public void setLayerables(List<AbstractLayerableModel> layerables) {
        this.layerables = new ArrayList<AbstractLayerableModel>(layerables);
        this.fireModelChanged("layerables", Collections.unmodifiableList(this.layerables));
    }

    public void addLayerable(int index, AbstractLayerableModel layerModel) {
        this.layerables.add(index, layerModel);
        this.fireModelChanged("layerables_add", layerModel);
    }

    public void addLayerable(AbstractLayerableModel layerModel) {
        this.layerables.add(layerModel);
        this.fireModelChanged("layerables_add", layerModel);
    }

    public boolean removeLayerable(AbstractLayerableModel layerModel) {
        if (this.layerables.remove(layerModel)) {
            this.fireModelChanged("layerables_remove", layerModel);
            return true;
        }
        return false;
    }

    public List<CategoryModel> getSubcategories() {
        return Collections.unmodifiableList(this.subcategories);
    }

    public void setSubcategories(List<CategoryModel> subcategories) {
        this.subcategories = new ArrayList<CategoryModel>(subcategories);
        this.fireModelChanged("subcategories", Collections.unmodifiableList(this.subcategories));
    }

    public void addSubcategory(int index, CategoryModel categoryModel) {
        this.subcategories.add(index, categoryModel);
        this.fireModelChanged("subcategories_add", categoryModel);
    }

    public void addSubcategory(CategoryModel categoryModel) {
        this.subcategories.add(categoryModel);
        this.fireModelChanged("subcategories_add", categoryModel);
    }

    public boolean removeSubcategory(CategoryModel categoryModel) {
        if (this.subcategories.remove(categoryModel)) {
            this.fireModelChanged("subcategories_remove", categoryModel);
            return true;
        }
        return false;
    }
}

