/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.layerable;

import de.riwagis.riwajump.model.JumpModel;
import de.riwagis.riwajump.model.LayerManagerModel;
import de.riwagis.riwajump.model.layerable.CategoryModel;
import de.riwagis.riwajump.model.layerable.ViewCategory;
import de.riwagis.riwajump.model.style.SimpleStyleCollectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class AbstractLayerableModel
extends JumpModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String key;
    private boolean visible = true;
    private boolean visibleInViewerTree = true;
    private boolean scaleDependentRenderingEnabled = false;
    private int intRenderPrio = 0;
    private String description = "";
    private List<SimpleStyleCollectionModel> lstStyleCollections = new ArrayList<SimpleStyleCollectionModel>();
    private transient LayerManagerModel layerManager;
    private transient CategoryModel category;
    private transient ViewCategory viewCategory;
    private boolean exportable = false;

    public ViewCategory getViewCategory() {
        if (this.viewCategory == null) {
            CategoryModel cat = this.getCategory();
            if (cat != null && cat.getParentCategory() != null) {
                this.viewCategory = this.getViewCategory(cat);
            } else {
                ViewCategory newViewCategory = new ViewCategory();
                newViewCategory.setLayersVisible(this.isVisible());
                newViewCategory.setViewName(this.getName());
                newViewCategory.setDescription(this.getDescription());
                this.viewCategory = newViewCategory;
            }
        }
        return this.viewCategory;
    }

    private ViewCategory getViewCategory(CategoryModel cat) {
        CategoryModel parent = cat.getParentCategory();
        if (parent != null && parent.getParentCategory() != null) {
            return this.getViewCategory(parent);
        }
        ViewCategory newViewCategory = new ViewCategory();
        newViewCategory.setLayersVisible(cat.isVisible());
        newViewCategory.setViewName(cat.getName());
        newViewCategory.setDescription(cat.getDescription());
        return newViewCategory;
    }

    public CategoryModel getCategory() {
        return this.category;
    }

    public void setCategory(CategoryModel category) {
        this.category = category;
        this.fireModelChanged("category", category);
    }

    public LayerManagerModel getLayerManager() {
        return this.layerManager;
    }

    public void setLayerManager(LayerManagerModel layerManager) {
        this.layerManager = layerManager;
        this.fireModelChanged("layerManager", layerManager);
    }

    protected AbstractLayerableModel() {
    }

    protected AbstractLayerableModel(String aName) {
        this.name = aName;
    }

    @Override
    public AbstractLayerableModel clone() throws CloneNotSupportedException {
        AbstractLayerableModel clon = (AbstractLayerableModel)super.clone();
        ArrayList<SimpleStyleCollectionModel> cloneLstStyleCollections = new ArrayList<SimpleStyleCollectionModel>();
        for (SimpleStyleCollectionModel styleColMod : this.lstStyleCollections) {
            cloneLstStyleCollections.add(styleColMod.clone());
        }
        clon.setLstStyleCollections(cloneLstStyleCollections);
        return clon;
    }

    public String toString() {
        return this.name != null ? this.name : "";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fireModelChanged("name", name);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
        this.fireModelChanged("key", key);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.fireModelChanged("visible", visible);
    }

    public boolean isVisibleInViewerTree() {
        return this.visibleInViewerTree;
    }

    public void setVisibleInViewerTree(boolean visibleInViewerTree) {
        this.visibleInViewerTree = visibleInViewerTree;
        this.fireModelChanged("visibleInViewerTree", visibleInViewerTree);
    }

    public boolean isScaleDependentRenderingEnabled() {
        return this.scaleDependentRenderingEnabled;
    }

    public void setScaleDependentRenderingEnabled(boolean scaleDependentRenderingEnabled) {
        this.scaleDependentRenderingEnabled = scaleDependentRenderingEnabled;
        this.fireModelChanged("scaleDependentRenderingEnabled", scaleDependentRenderingEnabled);
    }

    public int getIntRenderPrio() {
        return this.intRenderPrio;
    }

    public void setIntRenderPrio(int intRenderPrio) {
        this.intRenderPrio = intRenderPrio;
        this.fireModelChanged("intRenderPrio", intRenderPrio);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fireModelChanged("description", description);
    }

    public List<SimpleStyleCollectionModel> getLstStyleCollections() {
        return Collections.unmodifiableList(this.lstStyleCollections);
    }

    public void setLstStyleCollections(List<SimpleStyleCollectionModel> lstStyleCollections) {
        this.lstStyleCollections = new ArrayList<SimpleStyleCollectionModel>(lstStyleCollections);
        this.fireModelChanged("styleCollections", Collections.unmodifiableList(this.lstStyleCollections));
    }

    public void clearStyleCollections() {
        if (this.lstStyleCollections != null) {
            this.lstStyleCollections.clear();
            this.fireModelChanged("styleCollections_clear", null);
        }
    }

    public boolean addStyleCollection(SimpleStyleCollectionModel styleCollection) {
        if (this.lstStyleCollections == null) {
            this.lstStyleCollections = new ArrayList<SimpleStyleCollectionModel>();
        }
        if (this.lstStyleCollections.add(styleCollection)) {
            this.fireModelChanged("styleCollections_add", styleCollection);
            return true;
        }
        return false;
    }

    public boolean removeStyleCollection(SimpleStyleCollectionModel styleCollection) {
        if (this.lstStyleCollections != null && this.lstStyleCollections.remove(styleCollection)) {
            this.fireModelChanged("styleCollections_remove", styleCollection);
            return true;
        }
        return false;
    }

    public SimpleStyleCollectionModel getDefaultStyleCollection() {
        for (SimpleStyleCollectionModel currStyleCollection : this.lstStyleCollections) {
            if (!currStyleCollection.isBolDefault()) continue;
            return currStyleCollection;
        }
        return null;
    }

    public Collection<SimpleStyleCollectionModel> cloneStyleCollections() throws CloneNotSupportedException {
        ArrayList<SimpleStyleCollectionModel> lstStyleCollectionClone = new ArrayList<SimpleStyleCollectionModel>();
        for (SimpleStyleCollectionModel currStyleCollection : this.lstStyleCollections) {
            lstStyleCollectionClone.add(currStyleCollection.clone());
        }
        return lstStyleCollectionClone;
    }

    public SimpleStyleCollectionModel getStyleCollectionByScale(double dblScale) {
        if (this.lstStyleCollections == null || this.lstStyleCollections.isEmpty()) {
            return null;
        }
        if (!this.isScaleDependentRenderingEnabled()) {
            for (SimpleStyleCollectionModel validStyleCollection : this.lstStyleCollections) {
                if (!validStyleCollection.isBolDefault()) continue;
                return validStyleCollection;
            }
        } else {
            for (SimpleStyleCollectionModel validStyleCollection : this.lstStyleCollections) {
                long lngScale;
                if (validStyleCollection.isBolDefault() || (lngScale = Math.round(dblScale)) <= validStyleCollection.getMinScale().longValue() || lngScale > validStyleCollection.getMaxScale().longValue()) continue;
                return validStyleCollection;
            }
        }
        return null;
    }

    public boolean isExportable() {
        return this.exportable;
    }

    public void setExportable(boolean exportable) {
        this.exportable = exportable;
        this.fireModelChanged("exportable", exportable);
    }
}

