/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model.intelligence;

import de.riwagis.riwajump.model.JumpModel;
import de.riwagis.riwajump.model.intelligence.JumpModelIntelligence;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class IntelligenceFactory {
    private static final Map<Class<?>, IntelligenceFactory> factories = new HashMap();

    protected abstract JumpModelIntelligence createIntelligence(JumpModel var1, Object var2);

    public static <T extends JumpModel> void registerFactory(Class<T> modelClass, IntelligenceFactory factory) {
        factories.put(modelClass, factory);
    }

    public static JumpModelIntelligence createModelIntelligence(JumpModel model, Object contextObject) {
        IntelligenceFactory factory = factories.get(model.getClass());
        if (factory == null) {
            return null;
        }
        return factory.createIntelligence(model, contextObject);
    }

    public static <T extends JumpModel> void register(Class<T> clazz, Function<T, JumpModelIntelligence> intelligenceSupplier) {
        IntelligenceFactory.registerFactory(clazz, new DefaultIntelligenceFactory<T>(intelligenceSupplier));
    }

    public static <T extends JumpModel, U> void registerWithContext(Class<T> clazz, BiFunction<T, U, JumpModelIntelligence> intelligenceSupplier) {
        IntelligenceFactory.registerFactory(clazz, new DefaultWithContextIntelligenceFactory<T, U>(intelligenceSupplier));
    }

    private static class DefaultIntelligenceFactory<T extends JumpModel>
    extends IntelligenceFactory {
        private final Function<T, JumpModelIntelligence> intelligenceSupplier;

        public DefaultIntelligenceFactory(Function<T, JumpModelIntelligence> intelligenceSupplier) {
            this.intelligenceSupplier = intelligenceSupplier;
        }

        @Override
        protected JumpModelIntelligence createIntelligence(JumpModel model, Object contextObject) {
            return this.intelligenceSupplier.apply(model);
        }
    }

    private static class DefaultWithContextIntelligenceFactory<T extends JumpModel, U>
    extends IntelligenceFactory {
        private final BiFunction<T, U, JumpModelIntelligence> intelligenceSupplier;

        public DefaultWithContextIntelligenceFactory(BiFunction<T, U, JumpModelIntelligence> intelligenceSupplier) {
            this.intelligenceSupplier = intelligenceSupplier;
        }

        @Override
        protected JumpModelIntelligence createIntelligence(JumpModel model, Object contextObject) {
            return this.intelligenceSupplier.apply(model, contextObject);
        }
    }
}

