/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.Comparator;
import java.util.TreeMap;

@XStreamAlias(value="range")
public class Range
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean includingMin;
    private boolean includingMax;
    private Object max;
    private Object min;
    private static final Comparator<Object> INFINITY_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof PositiveInfinity || o2 instanceof NegativeInfinity) {
                return 1;
            }
            if (o1 instanceof NegativeInfinity || o2 instanceof PositiveInfinity) {
                return -1;
            }
            return ((Comparable)o1).compareTo(o2);
        }
    };
    public static final Comparator<Object> RANGE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            Range range1 = o1 instanceof Range ? (Range)o1 : new Range(o1, true, o1, true);
            Range range2 = o2 instanceof Range ? (Range)o2 : new Range(o2, true, o2, true);
            int max1ComparedToMin2 = INFINITY_COMPARATOR.compare(range1.getMax(), range2.getMin());
            if (max1ComparedToMin2 < 0 || max1ComparedToMin2 == 0 && (!range1.isIncludingMax() || !range2.isIncludingMin())) {
                return -1;
            }
            int min1ComparedToMax2 = INFINITY_COMPARATOR.compare(range1.getMin(), range2.getMax());
            if (min1ComparedToMax2 > 0 || min1ComparedToMax2 == 0 && (!range1.isIncludingMin() || !range2.isIncludingMax())) {
                return 1;
            }
            return 0;
        }
    };

    public String toString() {
        return this.min + " - " + this.max;
    }

    public Range() {
        this(new NegativeInfinity(), false, new PositiveInfinity(), false);
    }

    public Range(Object min, boolean includingMin, Object max, boolean includingMax) {
        if (!(!min.equals(max) || includingMin && includingMax)) {
            String inclMin = includingMin ? "[" : "(";
            String inclMax = includingMax ? "]" : ")";
            throw new IllegalArgumentException(inclMin + min + ", " + max + inclMax);
        }
        this.min = min;
        this.max = max;
        this.includingMin = includingMin;
        this.includingMax = includingMax;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return RANGE_COMPARATOR.compare(this, obj) == 0;
    }

    public boolean isIncludingMax() {
        return this.includingMax;
    }

    public boolean isIncludingMin() {
        return this.includingMin;
    }

    public Object getMax() {
        return this.max;
    }

    public Object getMin() {
        return this.min;
    }

    public void setIncludingMax(boolean isIncludingMax) {
        this.includingMax = isIncludingMax;
    }

    public void setIncludingMin(boolean isIncludingMin) {
        this.includingMin = isIncludingMin;
    }

    public void setMax(Object maximum) {
        this.max = maximum;
    }

    public void setMin(Object minimum) {
        this.min = minimum;
    }

    @XStreamAlias(value="rangeNegativeInfinity")
    public static final class NegativeInfinity
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public String toString() {
            return "";
        }
    }

    @XStreamAlias(value="rangePositiveInfinity")
    public static final class PositiveInfinity
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public String toString() {
            return "";
        }
    }

    public static class RangeTreeMap<K, V>
    extends TreeMap<K, V> {
        public RangeTreeMap() {
            super(RANGE_COMPARATOR);
        }
    }
}

