/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.model;

import de.riwagis.riwajump.model.event.JumpModelEvent;
import de.riwagis.riwajump.model.intelligence.IntelligenceFactory;
import de.riwagis.riwajump.model.intelligence.JumpModelIntelligence;
import java.io.Serializable;

public abstract class JumpModel<T extends JumpModel>
implements Cloneable,
Serializable {
    private transient JumpModelIntelligence intelligence = null;

    public T clone() throws CloneNotSupportedException {
        JumpModel clonedModel = (JumpModel)super.clone();
        clonedModel.setIntelligence(null);
        return (T)clonedModel;
    }

    public T cloneModel() {
        try {
            return (T)this.clone();
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException("Cloning is not supported.", cne);
        }
    }

    protected void fireModelChanged(String propertyName, Object propertyValue) {
        if (this.intelligence != null) {
            JumpModelEvent event = new JumpModelEvent(this, propertyName, propertyValue);
            this.intelligence.fireJumpModelChanged(event);
        }
    }

    public <U extends JumpModelIntelligence<T>> U createAndGetIntelligence(Object contextObject) {
        if (this.intelligence == null) {
            this.intelligence = IntelligenceFactory.createModelIntelligence(this, contextObject);
        }
        return (U)this.intelligence;
    }

    public <U extends JumpModelIntelligence<T>> U getIntelligence() {
        if (this.intelligence == null) {
            this.intelligence = IntelligenceFactory.createModelIntelligence(this, null);
        }
        return (U)this.intelligence;
    }

    public void setIntelligence(JumpModelIntelligence modelIntelligence) {
        this.intelligence = modelIntelligence;
    }
}

