/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.xulrunner;

import de.riwagis.browser.WindowManager;
import de.riwagis.browser.WindowManagerProvider;
import de.riwagis.browser.WindowManagerSettings;
import de.riwagis.browser.xulrunner.XulWindowManager;
import java.io.File;

public class XulWindowManagerProvider
implements WindowManagerProvider {
    @Override
    public String name() {
        return "XulWindowManager";
    }

    @Override
    public boolean isAvailable() {
        try {
            Class.forName("org.eclipse.swt.SWT");
            File xulPath = this.determineBinaryPath();
            return xulPath != null && xulPath.exists();
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    @Override
    public WindowManager create(WindowManagerSettings settings) {
        System.setProperty("org.eclipse.swt.browser.XULRunnerPath", this.determineBinaryPath().getAbsolutePath());
        return new XulWindowManager();
    }

    private File determineBinaryPath() {
        String archModel;
        return switch (archModel = System.getProperty("sun.arch.data.model")) {
            case "32" -> new File("xulrunner");
            case "64" -> new File("xulrunner64");
            default -> null;
        };
    }
}

