/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.xulrunner;

import de.riwagis.browser.BrowserFrame;
import de.riwagis.browser.BrowserPanel;
import de.riwagis.browser.OpenWindowConfiguration;
import de.riwagis.browser.WindowManager;
import de.riwagis.browser.xulrunner.XulBrowserFrame;
import de.riwagis.browser.xulrunner.XulBrowserPanel;
import de.riwagis.util.Config;
import de.riwagis.util.Support;
import de.riwagis.util.gui.components.TextareaDialog;
import de.riwagis.util.i18n.I18N;
import java.awt.Frame;
import java.awt.Toolkit;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XulWindowManager
extends WindowManager<XulBrowserFrame> {
    private static final Logger LOG = LoggerFactory.getLogger(XulWindowManager.class);
    private static Thread TH_DISPLAY = null;
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.browser.i18n.i18n");
    private static Shell ROOT_SHELL = null;
    private static WindowManager WM_INSTANCE = null;

    public XulWindowManager() {
        super(() -> new XulBrowserFrame());
        System.setProperty("sun.awt.xembedserver", "true");
        if (Support.isLinux()) {
            System.setProperty("SWT_GTK3", "0");
        }
        if (WindowManager.getInstance() instanceof XulWindowManager) {
            ((XulWindowManager)WindowManager.getInstance()).startDispatch();
            BrowserPanel brPanel = WindowManager.getInstance().createBrowserPanel();
            brPanel.dispose();
        }
    }

    public static synchronized WindowManager getInstance() {
        if (WM_INSTANCE == null) {
            WindowManager defaultInstance = WindowManager.getInstance();
            WM_INSTANCE = defaultInstance instanceof XulWindowManager ? defaultInstance : new XulWindowManager();
        }
        return WM_INSTANCE;
    }

    @Override
    public void closeWindow(String strName) {
        this.getDisplay().syncExec(() -> this.closeWindowInternal(strName));
    }

    static Browser getBrowser(Shell shell) {
        Browser browser = new Browser((Composite)shell, 32768);
        Menu popupmenu = new Menu((Decorations)shell, 8);
        MenuItem miCopy = new MenuItem(popupmenu, 8);
        miCopy.setText(i18n.get("jxbrowser.ContextMenu.reload"));
        miCopy.addListener(13, e -> browser.refresh());
        MenuItem miPaste = new MenuItem(popupmenu, 8);
        miPaste.setText(i18n.get("jxbrowser.ContextMenu.stop"));
        miPaste.addListener(13, e -> browser.stop());
        new MenuItem(popupmenu, 2);
        MenuItem miSource = new MenuItem(popupmenu, 8);
        miSource.setText(i18n.get("jxbrowser.ContextMenu.properties"));
        miSource.addListener(13, e -> {
            TextareaDialog txtDlg = new TextareaDialog((Frame)null, "Page source", browser.getUrl() + "\n" + browser.getText());
            SwingUtilities.invokeLater(() -> txtDlg.setVisible(true));
        });
        browser.setMenu(popupmenu);
        shell.setMenu(popupmenu);
        return browser;
    }

    @Override
    public void addWindowListeners(XulBrowserFrame browserFrame, final String strName) {
        if (strName != null && strName.length() > 0) {
            Shell shell = browserFrame.getWebBrowser().getShell();
            shell.addShellListener(new ShellListener(){

                public void shellActivated(ShellEvent se) {
                }

                public void shellClosed(ShellEvent se) {
                    XulWindowManager.this.getDisplay().syncExec(() -> XulWindowManager.this.closeWindowInternal(strName));
                }

                public void shellDeactivated(ShellEvent se) {
                }

                public void shellDeiconified(ShellEvent se) {
                }

                public void shellIconified(ShellEvent se) {
                }
            });
        }
    }

    @Override
    public BrowserFrame openWindow(OpenWindowConfiguration configuration) {
        XulBrowserFrame tmpBrowserFrame;
        XulBrowserFrame brDlg = tmpBrowserFrame = (XulBrowserFrame)this.openWindowInternal(configuration.getName());
        brDlg.setSize(configuration.getSize().width, configuration.getSize().height);
        brDlg.getDisplay().syncExec(() -> {
            try {
                this.addWindowListeners(brDlg, configuration.getName());
                brDlg.getDisplay().syncExec(() -> {
                    if (configuration.getLocation() != null && configuration.getLocation().x > -1) {
                        brDlg.setLocation(configuration.getLocation().x, configuration.getLocation().y);
                    } else {
                        brDlg.centreOnScreen();
                    }
                });
                brDlg.navigate(configuration.getAddress().toString());
                brDlg.setVisible(true);
                if (configuration.isShowToolbar()) {
                    brDlg.showToolbar();
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        });
        return brDlg;
    }

    @Override
    public synchronized void callServer(String url) {
        LOG.debug(String.format("callServer('%s')", url));
        this.getBasicURL();
        this.startDispatch();
        this.getDisplay().asyncExec(() -> {
            Shell shell = new Shell(this.getDisplay());
            Browser internalBrowser = XulWindowManager.getBrowser(shell);
            internalBrowser.setUrl(this.getBasicURL() + url);
        });
    }

    @Override
    public void callServer(String url, Map<String, String> postData, Runnable callEndedListener) {
    }

    public synchronized void startDispatch() {
        this.startDispatch(false);
    }

    private synchronized void startDispatch(boolean restart) {
        if (ROOT_SHELL != null && !ROOT_SHELL.isDisposed()) {
            if (!restart) {
                LOG.debug("SWT dispatch thread not started again.");
                return;
            }
            LOG.debug("SWT dispatch disposed - trying to restart.");
            ROOT_SHELL.dispose();
        }
        CountDownLatch isReady = new CountDownLatch(1);
        Runnable rDispatch = () -> {
            LOG.debug("SWT dispatch thread starting.");
            DeviceData data = new DeviceData();
            Display swtDisplay = new Display(data);
            ROOT_SHELL = new Shell(swtDisplay);
            isReady.countDown();
            while (!ROOT_SHELL.isDisposed()) {
                try {
                    if (swtDisplay.readAndDispatch()) continue;
                    swtDisplay.sleep();
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            LOG.debug("SWT dispatch thread stopped.");
        };
        TH_DISPLAY = new Thread(rDispatch, "SWT_THREAD");
        TH_DISPLAY.start();
        try {
            if (!isReady.await(10000L, TimeUnit.MILLISECONDS)) {
                LOG.error("Error in WindowManager.startDispatch. Maybe dispatching does not work properly.");
            }
        }
        catch (InterruptedException ex) {
            LOG.error(String.format("interrupted: %s", ex.getMessage()), (Throwable)ex);
        }
    }

    public Shell getShell() {
        return new Shell(this.getDisplay());
    }

    public Display getDisplay() {
        if (ROOT_SHELL == null) {
            return null;
        }
        return ROOT_SHELL.getDisplay();
    }

    public synchronized void stopDispatch() {
        LOG.debug("SWT dispatch thread - try to stop.");
        if (this.getDisplay() == null || this.getDisplay().isDisposed()) {
            return;
        }
        this.getDisplay().asyncExec(() -> {
            if (ROOT_SHELL != null && !ROOT_SHELL.isDisposed()) {
                ROOT_SHELL.dispose();
            }
        });
    }

    @Override
    public BrowserPanel createBrowserPanel() {
        return new XulBrowserPanel();
    }

    @Override
    public void navigateAndFocusBrowserFrame(XulBrowserFrame brDlg, String strURL) {
        this.getDisplay().asyncExec(() -> {
            brDlg.setVisible(true);
            if (strURL != null) {
                brDlg.navigate(this.getBasicURL() + strURL);
            }
        });
    }

    public static double retrieveFontScale() {
        return (double)Toolkit.getDefaultToolkit().getScreenResolution() / 96.0;
    }

    @Override
    public void shutdown() {
        this.stopDispatch();
    }
}

