/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.xulrunner;

import de.riwagis.browser.BrowserPanel;
import de.riwagis.browser.QueryListener;
import de.riwagis.browser.WindowManager;
import de.riwagis.browser.util.BrowserSupport;
import de.riwagis.browser.xulrunner.XulWindowManager;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XulBrowserPanel
extends BrowserPanel {
    private static final Logger LOG = LoggerFactory.getLogger(XulBrowserPanel.class);
    private Browser browser = null;
    private Shell shell = null;
    private Canvas canvas;
    private String strLastURL = "about:blank";
    private boolean openLinkExternal = false;
    private LocationListener locationListener = null;
    private OpenWindowListener openWindowListener = null;
    private final List<ActionListener> lstTitleListeners = new ArrayList<ActionListener>();

    public XulBrowserPanel() {
        this.initComponents();
        this.canvas = new Canvas();
        BorderLayout bLy = new BorderLayout();
        this.setLayout(bLy);
        this.add((Component)this.canvas, "Center");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.initBrowser();
    }

    public synchronized void addTitleListener(ActionListener listener) {
        this.lstTitleListeners.add(listener);
    }

    private synchronized void fireTitleChanged(String strTitle) {
        for (ActionListener currListener : this.lstTitleListeners) {
            currListener.actionPerformed(new ActionEvent(this, 1001, strTitle));
        }
    }

    private XulWindowManager getXulWindowManager() {
        return (XulWindowManager)WindowManager.getInstance();
    }

    private void initBrowser() {
        if (this.browser == null) {
            this.getXulWindowManager().startDispatch();
            this.getXulWindowManager().getDisplay().syncExec(() -> {
                this.shell = SWT_AWT.new_Shell((Display)this.getXulWindowManager().getDisplay(), (Canvas)this.canvas);
                this.browser = XulWindowManager.getBrowser(this.shell);
                this.browser.setLayoutData((Object)new GridData(1808));
                this.browser.setUrl(this.strLastURL);
                this.shell.addControlListener(new ControlListener(){

                    public void controlMoved(ControlEvent ce) {
                    }

                    public void controlResized(ControlEvent ce) {
                        XulBrowserPanel.this.browser.setSize(XulBrowserPanel.this.shell.getSize());
                    }
                });
                this.browser.addTitleListener(te -> SwingUtilities.invokeLater(() -> this.fireTitleChanged(te.title)));
                this.browser.addCloseWindowListener(we -> SwingUtilities.invokeLater(() -> {
                    Window awtWin = SwingUtilities.windowForComponent(this.canvas);
                    awtWin.setVisible(false);
                }));
                if (this.locationListener != null) {
                    this.browser.addLocationListener(this.locationListener);
                }
                if (this.openWindowListener != null) {
                    this.browser.addOpenWindowListener(this.openWindowListener);
                }
                this.shell.layout();
            });
        }
    }

    public Browser getWebBrowser() {
        return this.browser;
    }

    @Override
    public void navigate(String strURL) {
        if (this.browser == null || this.browser.isDisposed()) {
            this.browser = null;
            this.initBrowser();
        }
        if (strURL == null) {
            strURL = "about:blank";
        }
        this.strLastURL = strURL;
        this.getXulWindowManager().getDisplay().syncExec(() -> {
            if (this.browser != null) {
                this.browser.setUrl(this.strLastURL);
            }
        });
    }

    @Override
    public void refresh() {
        this.getXulWindowManager().getDisplay().syncExec(() -> this.browser.refresh());
    }

    @Override
    public boolean isLoading() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void dispose() {
        this.getXulWindowManager().getDisplay().syncExec(() -> {
            try {
                if (this.browser != null) {
                    this.browser.dispose();
                }
            }
            catch (Exception e) {
                LOG.error("Error disposing browser.", (Throwable)e);
            }
            try {
                if (this.shell != null) {
                    this.shell.dispose();
                }
            }
            catch (Exception e) {
                LOG.error("Error disposing shell.", (Throwable)e);
            }
        });
    }

    private void initComponents() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                XulBrowserPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
    }

    private void formComponentShown(ComponentEvent evt) {
        this.getXulWindowManager().getDisplay().syncExec(() -> {
            if (this.browser != null) {
                this.browser.redraw();
            }
        });
    }

    @Override
    public void setHTML(String html) {
        if (this.browser == null || this.browser.isDisposed()) {
            this.browser = null;
            this.initBrowser();
        }
        this.getXulWindowManager().getDisplay().syncExec(() -> {
            if (this.browser != null) {
                this.browser.setText(html);
            }
        });
    }

    @Override
    public String getHTML() {
        return this.browser.getText();
    }

    @Override
    public String getURL() {
        this.getXulWindowManager().getDisplay().syncExec(() -> {
            if (this.browser != null) {
                this.strLastURL = this.browser.getUrl();
            }
        });
        return this.strLastURL;
    }

    @Override
    public void setOpenLinkExternal(boolean openLineExternal) {
        if (this.openLinkExternal == openLineExternal) {
            return;
        }
        if (openLineExternal) {
            this.locationListener = new LocationListener(){

                public void changing(LocationEvent event) {
                    if (StringUtils.equals((CharSequence)"about:blank", (CharSequence)event.location)) {
                        return;
                    }
                    BrowserSupport.openBrowser(event.location);
                    event.doit = false;
                }

                public void changed(LocationEvent event) {
                }
            };
            this.openWindowListener = event -> {
                event.browser = this.browser;
                event.required = true;
            };
        } else {
            if (this.locationListener != null) {
                this.browser.removeLocationListener(this.locationListener);
                this.locationListener = null;
            }
            if (this.openWindowListener != null) {
                this.browser.removeOpenWindowListener(this.openWindowListener);
                this.openWindowListener = null;
            }
        }
    }

    @Override
    public boolean getOpenLinkExternal() {
        return this.openLinkExternal;
    }

    @Override
    public void execJS(String jscript) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String execJSWithReturn(String jscript) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void execJSWithReturn(String jscript, Consumer<String> successHandler, Consumer<String> errorHandler) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void addQueryListener(QueryListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeQueryListener(QueryListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Collection<QueryListener> getQueryListeners() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

