/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.xulrunner;

import de.riwagis.browser.BrowserFrame;
import de.riwagis.browser.QueryListener;
import de.riwagis.browser.WindowManager;
import de.riwagis.browser.images.IconSWT;
import de.riwagis.browser.xulrunner.XulWindowManager;
import de.riwagis.util.Support;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class XulBrowserFrame
implements BrowserFrame {
    private static final Lock lock = new ReentrantLock();
    private final AtomicBoolean loading = new AtomicBoolean(false);
    private final Display display;
    private Browser browser;
    private Shell shell;
    private Cursor waitCursor;

    public XulBrowserFrame() {
        lock.lock();
        try {
            XulBrowserFrame.getXulWindowManager().startDispatch();
            this.display = XulBrowserFrame.getXulWindowManager().getDisplay();
            this.display.syncExec(() -> {
                this.shell = XulBrowserFrame.getXulWindowManager().getShell();
                this.waitCursor = new Cursor((Device)this.shell.getDisplay(), 1);
                this.browser = XulWindowManager.getBrowser(this.shell);
                this.shell.setLayout((Layout)new FillLayout());
                this.shell.setImage(IconSWT.imageSWT("icon.png"));
                this.shell.setSize(500, 500);
                this.shell.setLocation(200, 200);
                this.browser.addTitleListener(te -> this.shell.setText(te.title));
                this.browser.addOpenWindowListener(event -> {
                    XulBrowserFrame app = new XulBrowserFrame();
                    app.getWebBrowser().setData(XulBrowserFrame.class.toString(), (Object)app);
                    event.browser = app.getWebBrowser();
                });
                this.browser.addCloseWindowListener(event -> {
                    Browser browser = (Browser)event.widget;
                    XulBrowserFrame app = (XulBrowserFrame)browser.getData(XulBrowserFrame.class.toString());
                    app.setVisible(false);
                });
                this.browser.addVisibilityWindowListener(new VisibilityWindowListener(){

                    public void hide(WindowEvent e) {
                    }

                    public void show(WindowEvent e) {
                        Browser browser = (Browser)e.widget;
                        XulBrowserFrame app = (XulBrowserFrame)browser.getData(XulBrowserFrame.class.toString());
                        app.show(e.location, e.size);
                    }
                });
                this.browser.addProgressListener(new ProgressListener(){

                    public void changed(ProgressEvent event) {
                        XulBrowserFrame.this.shell.setCursor(XulBrowserFrame.this.waitCursor);
                        XulBrowserFrame.this.loading.set(true);
                    }

                    public void completed(ProgressEvent event) {
                        XulBrowserFrame.this.shell.setCursor(null);
                        XulBrowserFrame.this.loading.set(false);
                    }
                });
            });
        }
        finally {
            lock.unlock();
        }
    }

    private static XulWindowManager getXulWindowManager() {
        return (XulWindowManager)WindowManager.getInstance();
    }

    public Display getDisplay() {
        return this.display;
    }

    private void show(Point location, Point size) {
        this.display.syncExec(() -> {
            Shell shell = this.browser.getShell();
            if (location != null) {
                shell.setLocation(location);
            }
            if (size != null) {
                shell.setSize(size);
            }
            this.showFrameInternal();
        });
    }

    private void showFrameInternal() {
        this.display.asyncExec(() -> {
            this.shell.open();
            if (Support.isLinux()) {
                this.shell.setVisible(false);
            }
            this.shell.setVisible(true);
            this.shell.setMinimized(false);
        });
    }

    @Override
    public void setVisible(boolean bolVisible) {
        this.display.syncExec(() -> {
            Shell shell = this.browser.getShell();
            if (bolVisible) {
                this.showFrameInternal();
            } else if (shell.isVisible()) {
                shell.close();
            }
        });
    }

    @Override
    public void setPosSize(int left, int top, int width, int height) {
        this.display.syncExec(() -> {
            Shell shell = this.browser.getShell();
            shell.setSize(width, height);
            shell.setLocation(left, top);
        });
    }

    @Override
    public void showToolbar() {
        this.display.syncExec(() -> {
            ToolBar toolbar = new ToolBar((Composite)this.browser.getShell(), 0);
            FormData data = new FormData();
            data.top = new FormAttachment(0, 1);
            toolbar.setLayoutData((Object)data);
            ToolItem itemPrint = new ToolItem(toolbar, 8);
            itemPrint.setText("Drucken");
            itemPrint.addListener(13, event -> this.browser.setUrl("javascript:print()"));
            this.browser.getShell().setLayout((Layout)new FormLayout());
            data = new FormData();
            data.top = new FormAttachment((Control)toolbar, 0);
            data.left = new FormAttachment(0, 0);
            data.bottom = new FormAttachment(100, 0);
            data.right = new FormAttachment(100, 0);
            this.browser.setLayoutData((Object)data);
            this.shell.layout();
        });
    }

    @Override
    public void navigate(String strURL) {
        this.display.syncExec(() -> {
            if (this.browser.isDisposed()) {
                return;
            }
            this.browser.setUrl(strURL);
        });
    }

    @Override
    public String getURL() {
        return this.browser.getUrl();
    }

    @Override
    public void refresh() {
        this.display.syncExec(() -> {
            if (!this.browser.isDisposed()) {
                this.browser.refresh();
            }
        });
    }

    public Browser getWebBrowser() {
        return this.browser;
    }

    @Override
    public void centreOnScreen() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - this.browser.getShell().getBounds().width) / 2;
        int y = (screenSize.height - this.browser.getShell().getBounds().height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        int xfin = x;
        int yfin = y;
        XulBrowserFrame.getXulWindowManager().getDisplay().syncExec(() -> this.setLocation(xfin, yfin));
    }

    @Override
    public void setLocation(int x, int y) {
        this.display.syncExec(() -> {
            if (this.browser.isDisposed()) {
                return;
            }
            this.browser.getShell().setLocation(x, y);
        });
    }

    @Override
    public void setSize(int intWidth, int intHeight) {
        double zoomFactor = XulWindowManager.retrieveFontScale();
        Dimension dimScreen = Toolkit.getDefaultToolkit().getScreenSize();
        int intWidthZoomed = (int)((double)intWidth * zoomFactor);
        int intHeightZoomed = (int)((double)intHeight * zoomFactor);
        this.display.syncExec(() -> {
            if (this.browser.isDisposed()) {
                return;
            }
            int intWidthInternal = Math.min((int)dimScreen.getWidth(), intWidthZoomed);
            int intHeightInternal = Math.min((int)dimScreen.getHeight(), intHeightZoomed);
            this.browser.getShell().setSize(intWidthInternal, intHeightInternal);
        });
    }

    @Override
    public void requestFocus() {
        this.display.syncExec(() -> {
            if (this.browser.isDisposed()) {
                return;
            }
            this.browser.getShell().setFocus();
        });
    }

    @Override
    public void dispose() {
        this.display.syncExec(() -> {
            if (!this.browser.isDisposed()) {
                this.browser.dispose();
            }
            if (!this.shell.isDisposed()) {
                this.shell.dispose();
            }
        });
    }

    @Override
    public void setTitle(String strTitle) {
        this.display.syncExec(() -> {
            if (this.browser.isDisposed()) {
                return;
            }
            this.browser.getShell().setText(strTitle);
        });
    }

    @Override
    public void execJS(String jscript) {
        Display.getDefault().asyncExec(() -> this.browser.execute(jscript));
    }

    @Override
    public String execJSWithReturn(String jscript) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void execJSWithReturn(String jscript, Consumer<String> successHandler, Consumer<String> errorHandler) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void addQueryListener(QueryListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeQueryListener(QueryListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Collection<QueryListener> getQueryListeners() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) {
        XulBrowserFrame bshell = new XulBrowserFrame();
        bshell.getDisplay().syncExec(() -> {
            Shell shell = bshell.getWebBrowser().getShell();
            bshell.navigate("http://www.google.de");
            bshell.showToolbar();
            bshell.setVisible(true);
            bshell.execJS("document.body.style.backgroundColor = \"red\";");
            while (!shell.isDisposed()) {
                if (XulBrowserFrame.getXulWindowManager().getDisplay().readAndDispatch()) continue;
                XulBrowserFrame.getXulWindowManager().getDisplay().sleep();
            }
        });
    }

    @Override
    public boolean isLoading() {
        return this.loading.get();
    }
}

