/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.xulrunner;

import de.riwagis.browser.WindowManager;
import de.riwagis.browser.xulrunner.XulWindowManager;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.util.EmptyStackException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxEventQueue
extends EventQueue {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LinuxEventQueue.class);

    @Override
    public void postEvent(AWTEvent event) {
        this.pushSWT();
        super.postEvent(event);
        this.popSWT();
    }

    @Override
    protected void dispatchEvent(AWTEvent event) {
        this.pushSWT();
        super.dispatchEvent(event);
        this.popSWT();
    }

    @Override
    public AWTEvent getNextEvent() throws InterruptedException {
        this.pushSWT();
        AWTEvent event = super.getNextEvent();
        this.popSWT();
        return event;
    }

    @Override
    public synchronized AWTEvent peekEvent() {
        this.pushSWT();
        AWTEvent event = super.peekEvent();
        this.popSWT();
        return event;
    }

    @Override
    public synchronized AWTEvent peekEvent(int id) {
        this.pushSWT();
        AWTEvent event = super.peekEvent(id);
        this.popSWT();
        return event;
    }

    @Override
    protected void pop() throws EmptyStackException {
        this.pushSWT();
        super.pop();
        this.popSWT();
    }

    @Override
    public synchronized void push(EventQueue newEventQueue) {
        this.pushSWT();
        super.push(newEventQueue);
        this.popSWT();
    }

    private void popSWT() {
        this.wake();
    }

    private void pushSWT() {
        this.wake();
    }

    private void wake() {
        if (!(WindowManager.getInstance() instanceof XulWindowManager)) {
            return;
        }
        XulWindowManager manager = (XulWindowManager)WindowManager.getInstance();
        try {
            if (manager.getDisplay() != null && !manager.getDisplay().isDisposed()) {
                manager.getDisplay().wake();
            }
        }
        catch (Exception e) {
            log.error("Could not wake display in XULRunner", (Throwable)e);
        }
    }
}

