/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.webview;

import de.riwagis.browser.BrowserFrame;
import de.riwagis.browser.BrowserPanel;
import de.riwagis.browser.OpenWindowConfiguration;
import de.riwagis.browser.WindowManager;
import de.riwagis.browser.webview.WVBrowserFrame;
import de.riwagis.browser.webview.WVBrowserPanel;
import de.riwagis.util.gui.ExceptionDialog;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WVWindowManager
extends WindowManager<WVBrowserFrame> {
    private static final Logger LOG = LoggerFactory.getLogger(WVWindowManager.class);
    private static final AtomicBoolean FX_STARTED = new AtomicBoolean(false);
    private static WindowManager WM_INSTANCE = null;

    public WVWindowManager() {
        super(() -> new WVBrowserFrame());
    }

    public static synchronized WindowManager getInstance() {
        if (WM_INSTANCE == null) {
            WindowManager defaultInstance = WindowManager.getInstance();
            WM_INSTANCE = defaultInstance instanceof WVWindowManager ? defaultInstance : new WVWindowManager();
        }
        return WM_INSTANCE;
    }

    @Override
    public void closeWindow(String strName) {
        this.closeWindowInternal(strName);
    }

    private static synchronized void startFxApp() {
        if (SwingUtilities.isEventDispatchThread()) {
            new JFXPanel();
            Platform.setImplicitExit((boolean)false);
            FX_STARTED.set(true);
        } else if (!FX_STARTED.get()) {
            CountDownLatch latch = new CountDownLatch(1);
            SwingUtilities.invokeLater(() -> {
                new JFXPanel();
                Platform.setImplicitExit((boolean)false);
                latch.countDown();
                FX_STARTED.set(true);
            });
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void addWindowListeners(WVBrowserFrame browserFrame, String strName) {
        if (strName != null && strName.length() > 0) {
            WVBrowserFrame brDlg = browserFrame;
            brDlg.setOnHiding(event -> this.closeWindowInternal(strName));
        }
    }

    @Override
    public BrowserFrame openWindow(OpenWindowConfiguration configuration) {
        WVWindowManager.startFxApp();
        WVBrowserFrame[] tmpBrowserFrame = new WVBrowserFrame[1];
        CountDownLatch latch = new CountDownLatch(1);
        Platform.runLater(() -> {
            try {
                tmpBrowserFrame[0] = (WVBrowserFrame)this.openWindowInternal(configuration.getName());
            }
            finally {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        WVBrowserFrame brDlg = tmpBrowserFrame[0];
        if (configuration.isShowToolbar()) {
            brDlg.showToolbar();
        }
        try {
            brDlg.setSize(configuration.getSize().width, configuration.getSize().height);
            this.addWindowListeners(brDlg, configuration.getName());
            if (configuration.getLocation() != null && configuration.getLocation().x > -1) {
                brDlg.setLocation(configuration.getLocation().x, configuration.getLocation().y);
            } else {
                brDlg.centreOnScreen();
            }
            brDlg.navigate(configuration.getAddress().toString());
            brDlg.setVisible(true);
            Platform.runLater(() -> brDlg.requestFocus());
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException(null, (Exception)e, WVWindowManager.class);
        }
        return brDlg;
    }

    @Override
    public synchronized void callServer(String url) {
        LOG.debug(String.format("callServer('%s')", url));
        this.getBasicURL();
        WVWindowManager.startFxApp();
        Platform.runLater(() -> this.navigateInvisibleBrowser(this.getBasicURL() + url));
    }

    @Override
    public void callServer(String url, Map<String, String> postData, Runnable callEndedListener) {
    }

    @Override
    public BrowserPanel createBrowserPanel() {
        WVWindowManager.startFxApp();
        return new WVBrowserPanel();
    }

    @Override
    public void navigateAndFocusBrowserFrame(WVBrowserFrame brDlg, String strURL) {
        SwingUtilities.invokeLater(() -> {
            brDlg.setVisible(true);
            Platform.runLater(() -> brDlg.requestFocus());
            if (strURL != null) {
                brDlg.navigate(this.getBasicURL() + strURL);
            }
        });
    }
}

