/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.webview;

import de.riwagis.util.Config;
import de.riwagis.util.i18n.I18N;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.MouseButton;
import javafx.scene.web.WebView;

public class WVContextMenu {
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.browser.i18n.i18n");
    private final WebView webView;
    private int zoomLevel = 0;

    WVContextMenu(WebView webView) {
        this.webView = webView;
        webView.setContextMenuEnabled(false);
        ContextMenu contextMenu = new ContextMenu();
        MenuItem reload = new MenuItem(i18n.get("webview.contextmenu.reload"));
        reload.setOnAction(e -> webView.getEngine().reload());
        MenuItem zoomIn = new MenuItem(i18n.get("webview.contextmenu.zoom-in"));
        zoomIn.setOnAction(e -> this.increaseZoom());
        MenuItem zoomOut = new MenuItem(i18n.get("webview.contextmenu.zoom-out"));
        zoomOut.setOnAction(e -> this.decreaseZoom());
        MenuItem zoomReset = new MenuItem(i18n.get("webview.contextmenu.zoom-reset"));
        zoomReset.setOnAction(e -> this.resetZoom());
        contextMenu.getItems().addAll((Object[])new MenuItem[]{reload, new SeparatorMenuItem(), zoomIn, zoomOut, zoomReset});
        webView.setOnMousePressed(e -> {
            if (e.getButton() == MouseButton.SECONDARY) {
                contextMenu.show((Node)webView, e.getScreenX(), e.getScreenY());
            } else {
                contextMenu.hide();
            }
        });
    }

    void resetZoom() {
        this.zoomLevel = 0;
        this.webView.setZoom(this.calculateZoomDpiScaled());
    }

    void decreaseZoom() {
        --this.zoomLevel;
        this.webView.setZoom(this.calculateZoomDpiScaled());
    }

    void increaseZoom() {
        ++this.zoomLevel;
        this.webView.setZoom(this.calculateZoomDpiScaled());
    }

    private double calculateZoomDpiScaled() {
        return Math.pow(1.2, this.zoomLevel);
    }
}

