/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.webview;

import de.riwagis.browser.BrowserPanel;
import de.riwagis.browser.QueryListener;
import de.riwagis.browser.util.BrowserSupport;
import de.riwagis.browser.webview.JavaScriptDialog;
import de.riwagis.browser.webview.WVContextMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WVBrowserPanel
extends BrowserPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WVBrowserPanel.class);
    private final JFXPanel jfxPanel;
    private WebEngine engine;
    private boolean openLinkExternal = false;
    private ChangeListener<String> locationPropertyChangeListener = null;

    public WVBrowserPanel() {
        BorderLayout bly = new BorderLayout();
        this.setLayout(bly);
        this.jfxPanel = new JFXPanel();
        this.createScene();
        this.add((Component)this.jfxPanel, "Center");
    }

    private void createScene() {
        Platform.runLater(() -> {
            Platform.setImplicitExit((boolean)false);
            WebView view = new WebView();
            WVContextMenu wvContextMenu = new WVContextMenu(view);
            wvContextMenu.resetZoom();
            this.engine = view.getEngine();
            Scene scene = new Scene((Parent)view);
            this.engine.titleProperty().addListener((observable, oldValue, newValue) -> SwingUtilities.invokeLater(() -> {}));
            this.engine.setOnStatusChanged(event -> SwingUtilities.invokeLater(() -> {}));
            this.engine.getLoadWorker().workDoneProperty().addListener((observableValue, oldValue, newValue) -> SwingUtilities.invokeLater(() -> {}));
            this.engine.getLoadWorker().runningProperty().addListener((observableValue, oldValue, newValue) -> {});
            this.engine.getLoadWorker().exceptionProperty().addListener((o, old, value) -> {
                if (this.engine.getLoadWorker().getState() == Worker.State.FAILED) {
                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog((Component)this.jfxPanel, value != null ? this.engine.getLocation() + "\n" + value.getMessage() : this.engine.getLocation() + "\nUnexpected error.", "Loading error...", 0));
                }
            });
            this.engine.setConfirmHandler(p -> JavaScriptDialog.showConfirm(null, p));
            this.engine.setPromptHandler(p -> JavaScriptDialog.showPrompt(null, p.getMessage(), p.getDefaultValue()));
            this.engine.setOnAlert(event -> JavaScriptDialog.showAlert(null, (String)event.getData()));
            this.jfxPanel.setScene(scene);
        });
    }

    @Override
    public void navigate(String strURL) {
        Platform.runLater(() -> {
            String tmp = WVBrowserPanel.toURL(strURL);
            if (strURL == null) {
                tmp = WVBrowserPanel.toURL("");
            }
            this.engine.load(tmp);
        });
    }

    private static String toURL(String str) {
        try {
            return new URL(str).toExternalForm();
        }
        catch (MalformedURLException exception) {
            return null;
        }
    }

    @Override
    public void refresh() {
        Platform.runLater(() -> this.engine.reload());
    }

    @Override
    public boolean isLoading() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setHTML(String html) {
        Platform.runLater(() -> this.engine.loadContent(html));
    }

    @Override
    public String getHTML() {
        return this.engine.getDocument().getTextContent();
    }

    @Override
    public String getURL() {
        return this.engine.getLocation();
    }

    @Override
    public void setOpenLinkExternal(boolean openLineExternal) {
        if (this.openLinkExternal == openLineExternal) {
            return;
        }
        this.openLinkExternal = openLineExternal;
        Platform.runLater(() -> {
            if (this.openLinkExternal) {
                if (this.locationPropertyChangeListener == null) {
                    this.locationPropertyChangeListener = (observableValue, oldValue, newValue) -> {
                        if (StringUtils.isNotBlank((CharSequence)newValue) && !StringUtils.equals((CharSequence)newValue, (CharSequence)"about:blank")) {
                            SwingUtilities.invokeLater(() -> BrowserSupport.openBrowser(newValue));
                            Platform.runLater(() -> {
                                if (!StringUtils.isEmpty((CharSequence)newValue)) {
                                    this.engine.getLoadWorker().cancel();
                                    this.engine.loadContent(newValue);
                                }
                            });
                        }
                    };
                }
                this.engine.locationProperty().addListener(this.locationPropertyChangeListener);
            } else if (this.locationPropertyChangeListener != null) {
                this.engine.locationProperty().removeListener(this.locationPropertyChangeListener);
                this.locationPropertyChangeListener = null;
            }
        });
    }

    @Override
    public boolean getOpenLinkExternal() {
        return this.openLinkExternal;
    }

    @Override
    public void execJS(String jscript) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String execJSWithReturn(String jscript) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void execJSWithReturn(String jscript, Consumer<String> successHandler, Consumer<String> errorHandler) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void addQueryListener(QueryListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeQueryListener(QueryListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Collection<QueryListener> getQueryListeners() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

