/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.webview;

import de.riwagis.browser.BrowserFrame;
import de.riwagis.browser.QueryListener;
import de.riwagis.browser.images.IconFX;
import de.riwagis.browser.webview.JavaScriptDialog;
import de.riwagis.browser.webview.WVContextMenu;
import de.riwagis.util.Config;
import de.riwagis.util.i18n.I18N;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WVBrowserFrame
extends Stage
implements BrowserFrame {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WVBrowserFrame.class);
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.browser.i18n.i18n");
    private final Scene scene;
    private final WebView webView = new WebView();
    private final ToolBar toolBar;
    private final Button printButton;
    private final WVContextMenu wvContextMenu;

    public WVBrowserFrame() {
        this.configureEngine(this.webView);
        this.wvContextMenu = new WVContextMenu(this.webView);
        this.wvContextMenu.resetZoom();
        this.printButton = new Button(i18n.get("webview.frame.print"));
        this.toolBar = new ToolBar();
        this.toolBar.managedProperty().bind((ObservableValue)this.toolBar.visibleProperty());
        this.toolBar.setVisible(false);
        this.toolBar.getItems().add((Object)this.printButton);
        BorderPane borderPane = new BorderPane();
        borderPane.setTop((Node)this.toolBar);
        borderPane.setCenter((Node)this.webView);
        this.scene = new Scene((Parent)borderPane);
        this.setScene(this.scene);
        this.getIcons().add((Object)IconFX.fximage("icon.png"));
        this.printButton.setOnAction(e -> {
            PrinterJob job = PrinterJob.createPrinterJob();
            if (job != null) {
                if (job.showPrintDialog(this.scene.getWindow())) {
                    this.webView.getEngine().print(job);
                }
                job.endJob();
            }
        });
    }

    @Override
    public void setPosSize(int left, int top, int width, int height) {
        this.setLocation(left, top);
        this.setSize(width, height);
    }

    @Override
    public void showToolbar() {
        Platform.runLater(() -> this.toolBar.setVisible(true));
    }

    @Override
    public void navigate(String strURL) {
        Platform.runLater(() -> {
            String tmp = WVBrowserFrame.toURL(strURL);
            if (strURL == null) {
                tmp = WVBrowserFrame.toURL("http://" + strURL);
            }
            this.getEngine().load(tmp);
        });
    }

    @Override
    public String getURL() {
        return this.getEngine().getLocation();
    }

    private static String toURL(String str) {
        try {
            return new URL(str).toExternalForm();
        }
        catch (MalformedURLException exception) {
            return null;
        }
    }

    @Override
    public void refresh() {
        Platform.runLater(() -> this.getEngine().reload());
    }

    @Override
    public void centreOnScreen() {
    }

    @Override
    public void setVisible(boolean bolVisible) {
        Platform.runLater(() -> {
            if (bolVisible) {
                this.show();
            } else {
                this.hide();
            }
        });
    }

    @Override
    public void setLocation(int x, int y) {
        Platform.runLater(() -> {
            this.setX(x);
            this.setY(y);
        });
    }

    @Override
    public void setSize(int intWidth, int intHeight) {
        Platform.runLater(() -> {
            this.setWidth(intWidth);
            this.setHeight(intHeight);
        });
    }

    @Override
    public void dispose() {
    }

    @Override
    public void execJS(String jscript) {
        Platform.runLater(() -> this.getEngine().executeScript(jscript));
    }

    @Override
    public String execJSWithReturn(String jscript) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void execJSWithReturn(String jscript, Consumer<String> successHandler, Consumer<String> errorHandler) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void addQueryListener(QueryListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeQueryListener(QueryListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Collection<QueryListener> getQueryListeners() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isLoading() {
        return this.getEngine().getLoadWorker().isRunning();
    }

    private WebEngine configureEngine(WebView view) {
        WebEngine newEngine = view.getEngine();
        newEngine.titleProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(() -> this.setTitle((String)newValue)));
        newEngine.setOnStatusChanged(event -> log.debug("WebView changed status to {}", event.getData()));
        newEngine.getLoadWorker().exceptionProperty().addListener((o, old, value) -> {
            if (newEngine.getLoadWorker().getState() == Worker.State.FAILED) {
                SwingUtilities.invokeLater(() -> {
                    String strError = "Loading error...\n\n" + (value != null ? newEngine.getLocation() + "\n" + value.getMessage() : newEngine.getLocation() + "\nUnexpected error.");
                    JavaScriptDialog.showAlert(this, strError);
                });
            }
        });
        newEngine.setConfirmHandler(p -> JavaScriptDialog.showConfirm(this, p));
        newEngine.setPromptHandler(p -> {
            String strResult = JavaScriptDialog.showPrompt(this, p.getMessage(), p.getDefaultValue());
            return strResult;
        });
        newEngine.setOnAlert(event -> Platform.runLater(() -> JavaScriptDialog.showAlert(this, (String)event.getData())));
        newEngine.setCreatePopupHandler(popupFeatures -> {
            WVBrowserFrame newStage = new WVBrowserFrame();
            newStage.setWidth(500.0);
            newStage.setHeight(500.0);
            newStage.setResizable(popupFeatures.isResizable());
            newStage.show();
            return newStage.getEngine();
        });
        newEngine.setOnVisibilityChanged(t -> {
            if (!((Boolean)t.getData()).booleanValue() && this.isShowing()) {
                this.close();
            }
        });
        return newEngine;
    }

    private WebEngine getEngine() {
        return this.webView.getEngine();
    }
}

