/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.webview;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class JavaScriptDialog
extends Stage {
    boolean accept = true;
    final Stage self = this;
    private TextField field;
    private Label label;
    private final BorderPane borderPane;
    private final VBox messageBox;
    private final HBox buttonBox;
    private Button acceptBtn;
    private Button rejectBtn;

    public JavaScriptDialog(Stage primaryStage) {
        super(StageStyle.TRANSPARENT);
        super.centerOnScreen();
        super.initModality(Modality.WINDOW_MODAL);
        super.setIconified(false);
        super.setResizable(false);
        super.initOwner((Window)primaryStage);
        primaryStage.getScene().getRoot().setEffect(null);
        this.borderPane = new BorderPane();
        this.messageBox = new VBox();
        this.messageBox.setAlignment(Pos.CENTER_LEFT);
        this.borderPane.setCenter((Node)this.messageBox);
        BorderPane.setAlignment((Node)this.messageBox, (Pos)Pos.CENTER);
        this.buttonBox = new HBox();
        this.buttonBox.setAlignment(Pos.BOTTOM_RIGHT);
        this.buttonBox.getStyleClass().add((Object)"button-box");
        this.borderPane.setBottom((Node)this.buttonBox);
        BorderPane.setAlignment((Node)this.buttonBox, (Pos)Pos.BOTTOM_RIGHT);
    }

    public Label getLabel() {
        return this.label;
    }

    public Button addRejectButton() {
        return this.addRejectButton("Cancel");
    }

    public Label setMessage(String msg) {
        if (this.label == null) {
            this.label = new Label();
            this.label.setId("msg");
            this.messageBox.getChildren().add((Object)this.label);
        }
        this.label.setText(msg);
        return this.label;
    }

    public Button addRejectButton(String rejectText) {
        if (this.rejectBtn == null) {
            this.rejectBtn = new Button();
            this.rejectBtn.setCancelButton(true);
            this.rejectBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    JavaScriptDialog.this.accept = false;
                    JavaScriptDialog.this.self.close();
                }
            });
            this.buttonBox.getChildren().add((Object)this.rejectBtn);
        }
        this.rejectBtn.setText(rejectText);
        return this.rejectBtn;
    }

    public TextField addPrompt() {
        return this.setPrompt(null);
    }

    public TextField setPrompt(String defaultValue) {
        if (this.field == null) {
            this.field = new TextField();
            this.messageBox.getChildren().add((Object)this.field);
        }
        if (defaultValue != null) {
            this.field.setText(defaultValue);
        }
        return this.field;
    }

    public Button addAcceptButton() {
        return this.addAcceptButton("Ok");
    }

    public Button addAcceptButton(String acceptText) {
        if (this.acceptBtn == null) {
            this.acceptBtn = new Button();
            this.acceptBtn.setDefaultButton(true);
            this.acceptBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    JavaScriptDialog.this.accept = true;
                    JavaScriptDialog.this.getOwner().getScene().getRoot().setEffect(null);
                    JavaScriptDialog.this.self.close();
                }
            });
            this.buttonBox.getChildren().add((Object)this.acceptBtn);
        }
        this.acceptBtn.setText(acceptText);
        return this.acceptBtn;
    }

    public void showAndWait() {
        HBox hbox = new HBox();
        hbox.getStyleClass().add((Object)"modal-dialog");
        hbox.getChildren().add((Object)this.borderPane);
        this.setScene(new Scene((Parent)hbox, (Paint)Color.TRANSPARENT));
        this.getScene().setFill(null);
        this.getScene().getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("JavaScriptDialog.css").toExternalForm());
        this.label.setWrapText(true);
        this.label.setMinWidth(200.0);
        this.label.setMaxWidth(500.0);
        this.label.setMaxHeight(400.0);
        Parent root = this.getScene().getRoot();
        final Delta dragDelta = new Delta();
        root.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                dragDelta.x = JavaScriptDialog.this.self.getX() - mouseEvent.getScreenX();
                dragDelta.y = JavaScriptDialog.this.self.getY() - mouseEvent.getScreenY();
            }
        });
        root.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                JavaScriptDialog.this.self.setX(mouseEvent.getScreenX() + dragDelta.x);
                JavaScriptDialog.this.self.setY(mouseEvent.getScreenY() + dragDelta.y);
            }
        });
        super.showAndWait();
    }

    public boolean accepted() {
        return this.accept;
    }

    public String getPrompt() {
        if (!this.accept) {
            return null;
        }
        return this.field.getText();
    }

    public static String showPrompt(Stage owner, String message, String defaultValue) {
        JavaScriptDialog dialog = new JavaScriptDialog(owner);
        if (message != null) {
            dialog.setMessage(message);
        }
        dialog.setPrompt(defaultValue);
        dialog.addAcceptButton();
        dialog.addRejectButton();
        dialog.showAndWait();
        return dialog.getPrompt();
    }

    public static boolean showConfirm(Stage owner, String msg) {
        JavaScriptDialog dialog = new JavaScriptDialog(owner);
        dialog.setMessage(msg);
        dialog.addAcceptButton();
        dialog.addRejectButton();
        dialog.showAndWait();
        return dialog.accepted();
    }

    public static void showAlert(Stage stage, String msg) {
        JavaScriptDialog dialog = new JavaScriptDialog(stage);
        dialog.setMessage(msg);
        dialog.addAcceptButton();
        dialog.showAndWait();
    }

    class Delta {
        double x;
        double y;

        Delta() {
        }
    }
}

