/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.util;

import de.riwagis.browser.BrowserFrame;
import de.riwagis.util.gui.ExceptionDialog;
import java.awt.Desktop;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BrowserSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BrowserSupport.class);

    private BrowserSupport() {
    }

    public static void openBrowser(String strURL) {
        boolean bolLinuxChecked = false;
        strURL = StringUtils.replace((String)strURL, (String)" ", (String)"%20");
        try {
            if (!Desktop.isDesktopSupported()) {
                bolLinuxChecked = true;
                if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
                    Runtime.getRuntime().exec("xdg-open " + strURL);
                    return;
                }
                throw new UnsupportedOperationException("Desktop is not supported.");
            }
            Desktop.getDesktop().browse(new URI(strURL));
        }
        catch (Exception e) {
            try {
                if (!bolLinuxChecked && System.getProperty("os.name").equalsIgnoreCase("linux")) {
                    bolLinuxChecked = true;
                    Runtime.getRuntime().exec("xdg-open " + strURL);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ExceptionDialog.handleGuiException(null, (Throwable)e, (String)"webgiscli");
        }
    }

    public static void runWhenBrowserLoaded(BrowserFrame browserFrame, Runnable execute) {
        BrowserSupport.runWhenBrowserLoaded(browserFrame, 60, execute);
    }

    public static void runWhenBrowserLoaded(final BrowserFrame browserFrame, int maxSeconds, final Runnable execute) {
        final StopWatch w = new StopWatch();
        w.start();
        Objects.requireNonNull(browserFrame, "browserFrame must not be null");
        final CountDownLatch latch = new CountDownLatch(60);
        final ScheduledExecutorService xecutr = Executors.newSingleThreadScheduledExecutor();
        xecutr.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
                float sec = (float)w.getTime() / 1000.0f;
                if (!browserFrame.isLoading()) {
                    execute.run();
                    LOG.info(String.format("frame loading finished: %.2fsec.", Float.valueOf(sec)));
                    xecutr.shutdown();
                }
                if (latch.getCount() <= 0L) {
                    LOG.info(String.format("frame not loaded: %.2fsec.", Float.valueOf(sec)));
                    xecutr.shutdown();
                }
            }
        }, 2L, 1L, TimeUnit.SECONDS);
    }
}

