/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.browser.jxbrowser;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.engine.Engine;
import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.logging.Level;
import de.riwagis.browser.BrowserFrame;
import de.riwagis.browser.BrowserPanel;
import de.riwagis.browser.OpenWindowConfiguration;
import de.riwagis.browser.WindowManager;
import de.riwagis.browser.WindowManagerSettings;
import de.riwagis.browser.jxbrowser.JxBrowserFrame;
import de.riwagis.browser.jxbrowser.JxBrowserPanel;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.ExceptionDialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JxWindowManager
extends WindowManager<JxBrowserFrame> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JxWindowManager.class);
    private static final String LICENSE_KEY = "jxbrowser.license.key";
    private static WindowManager WM_INSTANCE = null;
    private final Engine engine;

    public JxWindowManager(WindowManagerSettings settings) {
        super(() -> new JxBrowserFrame());
        com.teamdev.jxbrowser.logging.Logger.level((Level)Level.INFO);
        if (StringUtils.isBlank((CharSequence)System.getProperty(LICENSE_KEY))) {
            System.setProperty(LICENSE_KEY, "6P835FT5HAUKE4F98YLBWQD46HVXIR5DYVK6VZ3AGYJ3RX6VQAFPBYF1WUPZWPTKCNQ4");
        }
        EngineOptions.Builder engineBuilder = EngineOptions.newBuilder((RenderingMode)RenderingMode.HARDWARE_ACCELERATED).enableIncognito();
        if (settings.getDebugPort() != 0) {
            engineBuilder.remoteDebuggingPort(settings.getDebugPort());
        }
        this.engine = Engine.newInstance((EngineOptions)engineBuilder.build());
    }

    public static synchronized WindowManager getInstance() {
        if (WM_INSTANCE == null) {
            WindowManager defaultInstance = WindowManager.getInstance();
            WM_INSTANCE = defaultInstance instanceof JxWindowManager ? defaultInstance : new JxWindowManager(new WindowManagerSettings());
        }
        return WM_INSTANCE;
    }

    @Override
    public void closeWindow(String strName) throws SystemException {
        this.closeWindowInternal(strName);
    }

    public Browser createNewBrowser() {
        return this.engine.newBrowser();
    }

    @Override
    public void addWindowListeners(JxBrowserFrame browserFrame, final String strName) {
        if (strName != null && strName.length() > 0) {
            JxBrowserFrame brDlg = browserFrame;
            brDlg.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    JxWindowManager.this.closeWindowInternal(strName);
                }
            });
        }
    }

    @Override
    public BrowserFrame openWindow(OpenWindowConfiguration configuration) {
        JxBrowserFrame tmpBrowserFrame;
        JxBrowserFrame brDlg = tmpBrowserFrame = (JxBrowserFrame)this.openWindowInternal(configuration.getName());
        try {
            brDlg.setSize(configuration.getSize());
            this.addWindowListeners(brDlg, configuration.getName());
            if (configuration.getLocation() != null && configuration.getLocation().x > -1) {
                brDlg.setLocation(configuration.getLocation());
            } else {
                brDlg.centreOnScreen();
            }
            brDlg.navigate(configuration.getAddress().toString());
            brDlg.setVisible(true);
            brDlg.requestFocus();
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException(null, (Exception)e, JxWindowManager.class);
        }
        return brDlg;
    }

    @Override
    public synchronized void callServer(String url) {
        log.debug(String.format("callServer('%s')", url));
        this.getBasicURL();
        SwingUtilities.invokeLater(() -> this.navigateInvisibleBrowser(this.getBasicURL() + url));
    }

    @Override
    public void callServer(String url, Map<String, String> postData, Runnable callEndedListener) {
        log.debug(String.format("callServerWithPost('%s')", url));
        String postField = postData.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
        SwingUtilities.invokeLater(() -> ((JxBrowserFrame)this.getInvisibleBrowser()).navigateWithPostData(this.getBasicURL() + url, postField, callEndedListener));
    }

    @Override
    public BrowserPanel createBrowserPanel() {
        return new JxBrowserPanel();
    }

    @Override
    public void navigateAndFocusBrowserFrame(JxBrowserFrame brDlg, String strURL) {
        SwingUtilities.invokeLater(() -> {
            brDlg.setVisible(true);
            brDlg.requestFocus();
            if (strURL != null) {
                brDlg.navigate(this.getBasicURL() + strURL);
            }
        });
    }

    @Override
    public void shutdown() {
        this.engine.close();
    }
}

